/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.simulator;

import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jmri.jmrix.can.cbus.simulator.CbusEventResponder;
import jmri.jmrix.can.cbus.swing.simulator.Bundle;
import jmri.jmrix.can.cbus.swing.simulator.DirectionPane;
import jmri.util.swing.ComboBoxToolTipRenderer;
import jmri.util.swing.JSpinnerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvResponderPane
extends JPanel {
    private final CbusEventResponder _evr;
    private static final Logger log = LoggerFactory.getLogger(EvResponderPane.class);

    public EvResponderPane(CbusEventResponder evr) {
        this._evr = evr;
        if (this._evr != null) {
            this.init();
        }
    }

    private void init() {
        int _mode = this._evr.getMode();
        JLabel _nodeLabel = new JLabel("<html><h3>" + Bundle.getMessage("CbusNode") + " : </h3></html>");
        _nodeLabel.setToolTipText(Bundle.getMessage("simNodeSelect"));
        JComboBox<Object> _selectMode = new JComboBox<Object>();
        _selectMode.setEditable(false);
        ComboBoxToolTipRenderer renderer = new ComboBoxToolTipRenderer();
        _selectMode.setRenderer(renderer);
        ArrayList<String> tooltips = new ArrayList<String>();
        String getSelected = "";
        for (int i = 0; i < this._evr.evModes.size(); ++i) {
            String option = this._evr.evModes.get(i);
            _selectMode.addItem(option);
            tooltips.add(this._evr.evModesTip.get(i));
            if (i != _mode) continue;
            getSelected = option;
        }
        _selectMode.setSelectedItem(getSelected);
        _selectMode.addActionListener(e -> {
            String chosen = (String)_selectMode.getSelectedItem();
            for (int i = 0; i < this._evr.evModes.size(); ++i) {
                String option = this._evr.evModes.get(i);
                if (!option.equals(chosen)) continue;
                log.debug("chosen {} {}", (Object)i, (Object)chosen);
                this._evr.setMode(i);
            }
        });
        renderer.setTooltips(tooltips);
        JSpinner _spinner = new JSpinner(new SpinnerNumberModel(this._evr.getNode(), -1, 65535, 1));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(_spinner, "#");
        _spinner.setEditor(editor);
        JSpinnerUtil.setCommitsOnValidEdit(_spinner, true);
        _spinner.addChangeListener(e -> {
            int minmax = (Integer)_spinner.getValue();
            log.debug("value {}", (Object)minmax);
            this._evr.setNode(minmax);
        });
        _spinner.setToolTipText(Bundle.getMessage("simNodeSelect"));
        DirectionPane dp = new DirectionPane(this._evr);
        JPanel topPane = new JPanel();
        topPane.add(_selectMode);
        topPane.add(_nodeLabel);
        topPane.add(_spinner);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add(topPane);
        this.add(dp);
    }
}

