/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.simulator;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.node.CbusNodeCanListener;
import jmri.jmrix.can.cbus.simulator.CbusDummyNode;
import jmri.jmrix.can.cbus.simulator.CbusSimCanListener;
import jmri.jmrix.can.cbus.simulator.CbusSimulatedModuleProvider;
import jmri.jmrix.can.cbus.simulator.CbusSimulator;
import jmri.jmrix.can.cbus.swing.simulator.DirectionPane;
import jmri.util.swing.ComboBoxToolTipRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NdPane
extends JPanel {
    private JComboBox<String> _selectNd;
    private CbusDummyNode _node;
    private JButton _flimButton;
    private JLabel _sessionText;
    private DirectionPane directionPane;
    private final CanSystemConnectionMemo _memo;
    private static final Logger log = LoggerFactory.getLogger(NdPane.class);

    public NdPane(CbusDummyNode nd, CanSystemConnectionMemo sysmemo) {
        this._node = nd;
        this._memo = sysmemo;
        this.init();
    }

    private void init() {
        this._sessionText = new JLabel();
        this._selectNd = new JComboBox();
        this._selectNd.setEditable(false);
        ComboBoxToolTipRenderer renderer = new ComboBoxToolTipRenderer();
        this._selectNd.setRenderer(renderer);
        ArrayList<String> tooltips = new ArrayList<String>();
        this._selectNd.addItem("None");
        tooltips.add("Select a module to start the Simulation.");
        CbusSimulatedModuleProvider.getInstancesCollection().forEach(module -> {
            log.debug("found SPI {}", (Object)module.getModuleType());
            this._selectNd.addItem(module.getModuleType());
            tooltips.add(module.getToolTipText());
            if (module.matchesManuAndModuleId(this._node)) {
                this._selectNd.setSelectedItem(module.getModuleType());
            }
        });
        renderer.setTooltips(tooltips);
        this._selectNd.addActionListener(this::moduleSelectorChanged);
        this._flimButton = new JButton("FLiM");
        this._flimButton.addActionListener(e -> this._node.flimButton());
        JPanel topPane = new JPanel();
        topPane.add(this._selectNd);
        topPane.add(this._sessionText);
        topPane.add(this._flimButton);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add(topPane);
        this.directionPane = new DirectionPane(null);
        this.add(this.directionPane);
        this.updateNodeGui();
    }

    private void moduleSelectorChanged(ActionEvent e) {
        CbusSimulatedModuleProvider providerNode;
        String chosen = (String)this._selectNd.getSelectedItem();
        log.debug("Selected module {} {}", (Object)chosen, (Object)e);
        CbusSimulator sim = InstanceManager.getNullableDefault(CbusSimulator.class);
        if (this._node != null) {
            if (sim != null) {
                sim.removeNode(this._node);
            } else {
                log.warn("No Simulator Running to deregister Node {}", (Object)this._node);
            }
            this._node.dispose();
            this._node = null;
        }
        if ((providerNode = CbusSimulatedModuleProvider.getProviderByName(chosen)) != null) {
            this._node = providerNode.getNewDummyNode(this._memo, 0);
            if (sim != null) {
                sim.addNode(this._node);
            } else {
                log.warn("No Simulator Running to register Node {}", (Object)this._node);
            }
        }
        this.updateNodeGui();
    }

    public void updateNodeGui() {
        this._flimButton.setEnabled(this._node != null);
        if (this._node != null) {
            this._node.setPane(this);
            CbusNodeCanListener ncl = this._node.getCanListener();
            if (ncl instanceof CbusSimCanListener) {
                this.directionPane.setSimCanListener((CbusSimCanListener)ncl);
            }
            this._sessionText.setText("<html> <h2> " + this._node.getNodeNumber() + " </h2> </html>");
        } else {
            this.directionPane.setSimCanListener(null);
            this._sessionText.setText("<html> <h2>   </h2> </html>");
        }
    }
}

