/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.simulator;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusConfigurationManager;
import jmri.jmrix.can.cbus.simulator.CbusSimulator;
import jmri.jmrix.can.cbus.swing.simulator.Bundle;
import jmri.jmrix.can.cbus.swing.simulator.CsPane;
import jmri.jmrix.can.cbus.swing.simulator.EvResponderPane;
import jmri.jmrix.can.cbus.swing.simulator.NdPane;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanel;
import jmri.util.swing.sdi.JmriJFrameInterface;

public class SimulatorPane
extends CanPanel {
    private CbusSimulator _sim;
    private JPanel p1;
    private JPanel _csPanes;
    private JPanel _ndPanes;
    private JPanel _evPanes;
    private Boolean _disposeSimOnWindowClose = false;
    private JScrollPane mainScroll;

    @Override
    public void initComponents(@Nonnull CanSystemConnectionMemo memo) {
        super.initComponents(memo);
        this._sim = memo.get(CbusSimulator.class);
        this.init();
    }

    @Override
    public String getTitle() {
        return this.prependConnToString(Bundle.getMessage("MenuItemNetworkSim"));
    }

    private void init() {
        int i;
        this._disposeSimOnWindowClose = false;
        this.setLayout(new BoxLayout(this, 1));
        this.p1 = new JPanel();
        this.p1.setLayout(new BoxLayout(this.p1, 1));
        this._csPanes = new JPanel();
        this._evPanes = new JPanel();
        this._ndPanes = new JPanel();
        this._csPanes.setLayout(new BoxLayout(this._csPanes, 1));
        this._evPanes.setLayout(new BoxLayout(this._evPanes, 1));
        this._ndPanes.setLayout(new BoxLayout(this._ndPanes, 1));
        this._csPanes.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("CmndStations")));
        this._evPanes.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ResponseEvents")));
        this._ndPanes.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("CbusNodes")));
        for (i = 0; i < this._sim.getNumCS(); ++i) {
            CsPane thispane = new CsPane(this._sim.getCS(i));
            this._csPanes.add(thispane);
            thispane.setVisible(true);
        }
        for (i = 0; i < this._sim.getNumNd(); ++i) {
            NdPane thispanend = new NdPane(this._sim.getNd(i), this.memo);
            this._ndPanes.add(thispanend);
            thispanend.setVisible(true);
        }
        NdPane thispanend = new NdPane(null, this.memo);
        this._ndPanes.add(thispanend);
        thispanend.setVisible(true);
        for (int i2 = 0; i2 < this._sim.getNumEv(); ++i2) {
            EvResponderPane thispane = new EvResponderPane(this._sim.getEv(i2));
            this._evPanes.add(thispane);
            thispane.setVisible(true);
        }
        this._csPanes.setVisible(true);
        this._evPanes.setVisible(true);
        this._ndPanes.setVisible(true);
        this.p1.add(this._csPanes);
        this.p1.add(this._ndPanes);
        this.p1.add(this._evPanes);
        this.mainScroll = new JScrollPane(this.p1);
        this.add(this.mainScroll);
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menuList = new ArrayList<JMenu>();
        JMenu optionsMenu = new JMenu(Bundle.getMessage("OptionsMenu"));
        JMenu addMenu = new JMenu(Bundle.getMessage("MenuAdd"));
        JCheckBoxMenuItem closeSimOnDispose = new JCheckBoxMenuItem(Bundle.getMessage("StopSimWinClose"));
        closeSimOnDispose.setSelected(false);
        closeSimOnDispose.addActionListener(e -> {
            this._disposeSimOnWindowClose = closeSimOnDispose.isSelected();
        });
        JMenuItem newCs = new JMenuItem(Bundle.getMessage("CommandStation"));
        newCs.addActionListener(e -> {
            CsPane thispane = new CsPane(this._sim.getNewCS());
            this._csPanes.add(thispane);
            this.revalidate();
        });
        JMenuItem newEv = new JMenuItem(Bundle.getMessage("EventResponders"));
        newEv.addActionListener(e -> {
            EvResponderPane thispane = new EvResponderPane(this._sim.getNewEv());
            this._evPanes.add(thispane);
            this.revalidate();
        });
        JMenuItem newNd = new JMenuItem(Bundle.getMessage("CbusNode"));
        newNd.addActionListener(e -> {
            NdPane thispanend = new NdPane(null, this.memo);
            this._ndPanes.add(thispanend);
            this.revalidate();
        });
        optionsMenu.add(closeSimOnDispose);
        addMenu.add(newCs);
        addMenu.add(newEv);
        addMenu.add(newNd);
        menuList.add(optionsMenu);
        menuList.add(addMenu);
        return menuList;
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.can.cbus.swing.simulator.SimulatorPane";
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.memo != null && this._disposeSimOnWindowClose.booleanValue()) {
            this.memo.get(CbusConfigurationManager.class).disposeOf(this._sim, CbusSimulator.class);
        }
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemNetworkSim"), new JmriJFrameInterface(), SimulatorPane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }
}

