/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.implementation.AbstractSensor;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialSensor
extends AbstractSensor {
    int lastStateFromLayout = 1;
    private static final Logger log = LoggerFactory.getLogger(SerialSensor.class);

    public SerialSensor(String systemName) {
        super(systemName);
        this._knownState = 1;
    }

    public SerialSensor(String systemName, String userName) {
        super(systemName, userName);
        this._knownState = 1;
    }

    @Override
    public void requestUpdateFromLayout() {
        try {
            this.setKnownState(this.lastStateFromLayout);
        }
        catch (JmriException e) {
            log.error("Exception while setting state", (Throwable)e);
        }
    }

    @Override
    @CheckReturnValue
    public int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2, @Nonnull NamedBean n) {
        return CMRISystemConnectionMemo.compareSystemNameSuffix(suffix1, suffix2);
    }
}

