/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.swing.Timer;
import jmri.NamedBean;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.SerialNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTurnout
extends AbstractTurnout {
    CMRISystemConnectionMemo _memo = null;
    String tSystemName;
    protected int tBit;
    protected SerialNode tNode = null;
    protected Timer mPulseClosedTimer = null;
    protected Timer mPulseThrownTimer = null;
    protected boolean mPulseTimerOn = false;
    private static final Logger log = LoggerFactory.getLogger(SerialTurnout.class);

    public SerialTurnout(@Nonnull String systemName, String userName, CMRISystemConnectionMemo memo) {
        super(systemName, userName);
        this.tSystemName = systemName;
        this._memo = memo;
        this.tBit = this._memo.getBitFromSystemName(systemName);
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both CLOSED and THROWN: {}", (Object)newState);
                return;
            }
            this.sendMessage(true);
        } else {
            this.sendMessage(false);
        }
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        log.debug("Send command to {} Pushbutton", (Object)(_pushButtonLockout ? "Lock" : "Unlock"));
    }

    protected void sendMessage(boolean closed) {
        if (!this.mPulseTimerOn) {
            if (this.tNode == null) {
                this.tNode = (SerialNode)this._memo.getNodeFromSystemName(this.tSystemName, this._memo.getTrafficController());
                if (this.tNode == null) {
                    log.error("Trying to set a C/MRI turnout that doesn't exist: {} - ignored", (Object)this.tSystemName);
                    return;
                }
            }
            if (this.getNumberControlBits() == 1) {
                if (this.getControlType() == 0) {
                    if ((this.tNode.getOutputBit(this.tBit) ^ this.getInverted()) != closed) {
                        this.tNode.setOutputBit(this.tBit, closed ^ this.getInverted());
                    } else {
                        int kState = this.getKnownState();
                        if (closed) {
                            if ((kState & 4) != 0) {
                                this.tNode.setOutputBit(this.tBit, false ^ this.getInverted());
                                if (this.mPulseClosedTimer == null) {
                                    this.mPulseClosedTimer = new Timer(this.tNode.getPulseWidth(), new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            SerialTurnout.this.tNode.setOutputBit(SerialTurnout.this.tBit, true ^ SerialTurnout.this.getInverted());
                                            SerialTurnout.this.mPulseClosedTimer.stop();
                                            SerialTurnout.this.mPulseTimerOn = false;
                                        }
                                    });
                                }
                                this.mPulseTimerOn = true;
                                this.mPulseClosedTimer.start();
                            }
                        } else if ((kState & 2) != 0) {
                            this.tNode.setOutputBit(this.tBit, true ^ this.getInverted());
                            if (this.mPulseThrownTimer == null) {
                                this.mPulseThrownTimer = new Timer(this.tNode.getPulseWidth(), new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        SerialTurnout.this.tNode.setOutputBit(SerialTurnout.this.tBit, false ^ SerialTurnout.this.getInverted());
                                        SerialTurnout.this.mPulseThrownTimer.stop();
                                        SerialTurnout.this.mPulseTimerOn = false;
                                    }
                                });
                            }
                            this.mPulseTimerOn = true;
                            this.mPulseThrownTimer.start();
                        }
                    }
                } else {
                    int iTime = this.tNode.getPulseWidth();
                    int kState = this.getKnownState();
                    if (closed && (kState & 4) != 0 || !closed && (kState & 2) != 0) {
                        this.tNode.setOutputBit(this.tBit, false ^ this.getInverted());
                        if (this.mPulseClosedTimer == null) {
                            this.mPulseClosedTimer = new Timer(iTime, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    SerialTurnout.this.tNode.setOutputBit(SerialTurnout.this.tBit, true ^ SerialTurnout.this.getInverted());
                                    SerialTurnout.this.mPulseClosedTimer.stop();
                                    SerialTurnout.this.mPulseTimerOn = false;
                                }
                            });
                        }
                        this.mPulseTimerOn = true;
                        this.mPulseClosedTimer.start();
                    }
                }
            } else if (this.getNumberControlBits() == 2) {
                if (this.getControlType() == 0) {
                    this.tNode.setOutputBit(this.tBit, closed ^ this.getInverted());
                    this.tNode.setOutputBit(this.tBit + 1, !(closed ^ this.getInverted()));
                } else {
                    int iTime = this.tNode.getPulseWidth();
                    int kState = this.getKnownState();
                    if (closed && (kState & 4) != 0) {
                        this.tNode.setOutputBit(this.tBit, false ^ this.getInverted());
                        if (this.mPulseClosedTimer == null) {
                            this.mPulseClosedTimer = new Timer(iTime, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    SerialTurnout.this.tNode.setOutputBit(SerialTurnout.this.tBit, true ^ SerialTurnout.this.getInverted());
                                    SerialTurnout.this.mPulseClosedTimer.stop();
                                    SerialTurnout.this.mPulseTimerOn = false;
                                }
                            });
                        }
                        this.mPulseTimerOn = true;
                        this.mPulseClosedTimer.start();
                    } else if (!closed && (kState & 2) != 0) {
                        this.tNode.setOutputBit(this.tBit + 1, false ^ this.getInverted());
                        if (this.mPulseThrownTimer == null) {
                            this.mPulseThrownTimer = new Timer(iTime, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    SerialTurnout.this.tNode.setOutputBit(SerialTurnout.this.tBit + 1, true ^ SerialTurnout.this.getInverted());
                                    SerialTurnout.this.mPulseThrownTimer.stop();
                                    SerialTurnout.this.mPulseTimerOn = false;
                                }
                            });
                        }
                        this.mPulseTimerOn = true;
                        this.mPulseThrownTimer.start();
                    }
                }
            }
        }
    }

    @Override
    @CheckReturnValue
    public int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2, @Nonnull NamedBean n) {
        return CMRISystemConnectionMemo.compareSystemNameSuffix(suffix1, suffix2);
    }
}

