/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial.cmrinetmanager;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.cmrinetmanager.Bundle;
import jmri.jmrix.cmri.serial.cmrinetmetrics.CMRInetMetricsData;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMRInetMetricsFrame
extends JmriJFrame {
    protected JPanel networkMetricsPanel = null;
    protected Border networkMetricsBorder = BorderFactory.createEtchedBorder();
    protected Border networkMetricsBorderTitled;
    protected JPanel networkMetricsDataPanel = null;
    protected Border networkMetricsDataBorder = BorderFactory.createEtchedBorder();
    protected Border networkMetricsDataBorderTitled = BorderFactory.createTitledBorder(this.networkMetricsDataBorder, "Data Metrics", 1, 1);
    protected JTable netMetricsTable = null;
    protected TableModel netMetricsTableModel = null;
    protected JTable netMetricsDataTable = null;
    protected TableModel netMetricsDataTableModel = null;
    JButton doneButton = new JButton(Bundle.getMessage("DoneButtonText"));
    JButton saveMetricsButton = new JButton(Bundle.getMessage("SaveMetricsButtonText"));
    JButton resetAllMetricsButton = new JButton(Bundle.getMessage("ResetAllMetricsButtonText"));
    final JFileChooser metricsSaveChooser = new JmriJFileChooser();
    CMRInetMetricsFrame curFrame;
    private CMRISystemConnectionMemo _memo = null;
    private CMRInetMetricsData metricsData;
    volatile PrintStream logStream = null;
    private String[] CMRInetMetricsErrColumnsNames = new String[]{"Error", "Count", " ", "Reset"};
    private String[] CMRInetMetricsDataColumnsNames = new String[]{"Metric", "Count", " ", "Reset"};
    private static final Logger log = LoggerFactory.getLogger(CMRInetMetricsFrame.class);

    public CMRInetMetricsFrame(CMRISystemConnectionMemo memo) {
        this._memo = memo;
        this.curFrame = this;
    }

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("MetricsWindowTitle") + Bundle.getMessage("WindowConnectionMemo") + this._memo.getUserName());
        this.setLayout(new FlowLayout(0));
        this.setPreferredSize(new Dimension(860, 410));
        this.networkMetricsBorderTitled = BorderFactory.createTitledBorder(this.networkMetricsBorder, "Error Metrics", 1, 1);
        this.networkMetricsPanel = new JPanel();
        this.networkMetricsPanel.setLayout(new FlowLayout(0));
        this.networkMetricsPanel.setLayout(new BoxLayout(this.networkMetricsPanel, 3));
        this.networkMetricsPanel.setBorder(this.networkMetricsBorder);
        this.netMetricsTableModel = new NetMetricsTableModel();
        this.netMetricsTable = new JTable(this.netMetricsTableModel);
        this.netMetricsTable.setPreferredScrollableViewportSize(new Dimension(400, 150));
        this.netMetricsTable.setFillsViewportHeight(true);
        this.netMetricsTable.setShowGrid(false);
        this.netMetricsTable.setGridColor(Color.BLACK);
        this.netMetricsTable.setBackground(Color.WHITE);
        this.netMetricsTable.setRowSelectionAllowed(false);
        this.netMetricsTable.setFont(new Font("Helvetica", 1, 13));
        this.netMetricsTable.setRowHeight(30);
        this.netMetricsTable.getTableHeader().setReorderingAllowed(false);
        this.netMetricsTable.addMouseListener(new ErrMetricButtonMouseListener(this.netMetricsTable));
        JScrollPane netMetricsTableScrollPane = new JScrollPane(this.netMetricsTable);
        this.networkMetricsPanel.add((Component)netMetricsTableScrollPane, "Before");
        TableColumnModel netMetricsTableModel = this.netMetricsTable.getColumnModel();
        DefaultTableCellRenderer dtcen = new DefaultTableCellRenderer();
        dtcen.setHorizontalAlignment(0);
        DefaultTableCellRenderer dtlft = new DefaultTableCellRenderer();
        dtlft.setHorizontalAlignment(2);
        DefaultTableCellRenderer dtrgt = new DefaultTableCellRenderer();
        dtrgt.setHorizontalAlignment(4);
        TableCellRenderer rendererFromHeader = this.netMetricsTable.getTableHeader().getDefaultRenderer();
        JLabel headerLabel = (JLabel)((Object)rendererFromHeader);
        headerLabel.setHorizontalAlignment(0);
        TableColumn errorNameColumn = netMetricsTableModel.getColumn(0);
        errorNameColumn.setMinWidth(200);
        errorNameColumn.setMaxWidth(200);
        errorNameColumn.setCellRenderer(dtlft);
        errorNameColumn.setResizable(false);
        TableColumn errorCountColumn = netMetricsTableModel.getColumn(1);
        errorCountColumn.setMinWidth(100);
        errorCountColumn.setMaxWidth(100);
        errorCountColumn.setCellRenderer(dtrgt);
        errorCountColumn.setResizable(false);
        TableColumn blankColumn = netMetricsTableModel.getColumn(2);
        blankColumn.setMinWidth(20);
        blankColumn.setMaxWidth(20);
        blankColumn.setCellRenderer(dtrgt);
        blankColumn.setResizable(false);
        ErrMetricButtonRenderer buttonRenderer = new ErrMetricButtonRenderer();
        TableColumn resetCountColumn = netMetricsTableModel.getColumn(3);
        resetCountColumn.setMinWidth(80);
        resetCountColumn.setMaxWidth(80);
        resetCountColumn.setCellRenderer(buttonRenderer);
        resetCountColumn.setResizable(false);
        this.networkMetricsPanel.setBorder(this.networkMetricsBorderTitled);
        this.networkMetricsPanel.setPreferredSize(new Dimension(415, 300));
        this.networkMetricsPanel.setVisible(true);
        this.add(this.networkMetricsPanel);
        this.networkMetricsDataPanel = new JPanel();
        this.networkMetricsDataPanel.setLayout(new FlowLayout(0));
        this.networkMetricsDataPanel.setLayout(new BoxLayout(this.networkMetricsDataPanel, 2));
        this.networkMetricsDataPanel.setBorder(this.networkMetricsDataBorder);
        this.netMetricsDataTableModel = new NetMetricsDataTableModel();
        this.netMetricsDataTable = new JTable(this.netMetricsDataTableModel);
        this.netMetricsDataTable.setPreferredScrollableViewportSize(new Dimension(400, 150));
        this.netMetricsDataTable.setFillsViewportHeight(true);
        this.netMetricsDataTable.setShowGrid(false);
        this.netMetricsDataTable.setGridColor(Color.BLACK);
        this.netMetricsDataTable.setBackground(Color.WHITE);
        this.netMetricsDataTable.setRowSelectionAllowed(false);
        this.netMetricsDataTable.setFont(new Font("Helvetica", 1, 13));
        this.netMetricsDataTable.setRowHeight(30);
        this.netMetricsDataTable.getTableHeader().setReorderingAllowed(false);
        this.netMetricsDataTable.addMouseListener(new DataButtonMouseListener(this.netMetricsDataTable));
        JScrollPane netMetricsDataTableScrollPane = new JScrollPane(this.netMetricsDataTable);
        this.networkMetricsDataPanel.add((Component)netMetricsDataTableScrollPane, "Before");
        TableColumnModel netMetricsDataTableModel = this.netMetricsDataTable.getColumnModel();
        TableCellRenderer dataRendererFromHeader = this.netMetricsDataTable.getTableHeader().getDefaultRenderer();
        JLabel dataHeaderLabel = (JLabel)((Object)dataRendererFromHeader);
        dataHeaderLabel.setHorizontalAlignment(0);
        TableColumn dataNameColumn = netMetricsDataTableModel.getColumn(0);
        dataNameColumn.setMinWidth(200);
        dataNameColumn.setMaxWidth(200);
        dataNameColumn.setCellRenderer(dtlft);
        dataNameColumn.setResizable(false);
        TableColumn dataCountColumn = netMetricsDataTableModel.getColumn(1);
        dataCountColumn.setMinWidth(100);
        dataCountColumn.setMaxWidth(100);
        dataCountColumn.setCellRenderer(dtrgt);
        dataCountColumn.setResizable(false);
        TableColumn dataBlankColumn = netMetricsDataTableModel.getColumn(2);
        dataBlankColumn.setMinWidth(20);
        dataBlankColumn.setMaxWidth(20);
        dataBlankColumn.setCellRenderer(dtrgt);
        dataBlankColumn.setResizable(false);
        DataButtonRenderer dataButtonRenderer = new DataButtonRenderer();
        TableColumn dataResetCountColumn = netMetricsDataTableModel.getColumn(3);
        dataResetCountColumn.setMinWidth(80);
        dataResetCountColumn.setMaxWidth(80);
        dataResetCountColumn.setCellRenderer(dataButtonRenderer);
        dataResetCountColumn.setResizable(false);
        this.networkMetricsDataPanel.setBorder(this.networkMetricsDataBorderTitled);
        this.networkMetricsDataPanel.setPreferredSize(new Dimension(415, 300));
        this.networkMetricsDataPanel.setVisible(true);
        this.add(this.networkMetricsDataPanel);
        JPanel mainButtons = new JPanel();
        mainButtons.setLayout(new FlowLayout(1));
        mainButtons.setPreferredSize(new Dimension(845, 50));
        this.saveMetricsButton.setVisible(true);
        this.saveMetricsButton.setEnabled(true);
        this.saveMetricsButton.setToolTipText(Bundle.getMessage("SaveMetricsButtonText"));
        this.saveMetricsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CMRInetMetricsFrame.this.saveMetricsButtonActionPerformed(e);
            }
        });
        mainButtons.add(this.saveMetricsButton);
        this.resetAllMetricsButton.setVisible(true);
        this.resetAllMetricsButton.setToolTipText(Bundle.getMessage("ResetAllMetricsButtonText"));
        this.resetAllMetricsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CMRInetMetricsFrame.this.resetAllMetricsButtonActionPerformed(e);
            }
        });
        mainButtons.add(this.resetAllMetricsButton);
        this.doneButton.setVisible(true);
        this.doneButton.setToolTipText(Bundle.getMessage("DoneButtonTip"));
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CMRInetMetricsFrame.this.doneButtonActionPerformed();
            }
        });
        mainButtons.add(this.doneButton);
        mainButtons.setVisible(true);
        this.add(mainButtons);
        this.addHelpMenu("package.jmri.jmrix.cmri.serial.cmrinetmanager.CMRInetMetricsFrame", true);
        this.pack();
        this.metricsData = this._memo.getTrafficController().getMetricsData();
    }

    public void doneButtonActionPerformed() {
        this.setVisible(false);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMetricsButtonActionPerformed(ActionEvent e) {
        Object fileName = "CMRInetMetrics_";
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd_HHmmss");
        long curTicks = System.currentTimeMillis();
        fileName = "CMRInetMetrics_" + df.format(curTicks) + ".txt";
        this.metricsSaveChooser.setSelectedFile(new File((String)fileName));
        int retVal = this.metricsSaveChooser.showSaveDialog(null);
        if (retVal == 0) {
            try {
                int i;
                this.logStream = new PrintStream(new FileOutputStream(this.metricsSaveChooser.getSelectedFile()));
                this.logStream.println("-----  CMRInet Error Metrics  -----");
                for (i = 0; i != 5; ++i) {
                    this.logStream.println(String.format("%-30s %d", CMRInetMetricsData.CMRInetMetricErrName[i], this.metricsData.getMetricErrValue(i)));
                }
                this.logStream.print("\n\n");
                this.logStream.println("-----  CMRInet Data Metrics  -----");
                for (i = 0; i != CMRInetMetricsData.CMRInetMetricDataLAST; ++i) {
                    this.logStream.println(String.format("%-30s %d", CMRInetMetricsData.CMRInetMetricDataName[i], this.metricsData.getMetricDataValue(i)));
                }
                PrintStream i2 = this.logStream;
                synchronized (i2) {
                    this.logStream.flush();
                    this.logStream.close();
                }
            }
            catch (IOException | RuntimeException ex) {
                log.error("exception ", (Throwable)ex);
            }
        }
    }

    public void resetAllMetricsButtonActionPerformed(ActionEvent e) {
        this.metricsData.clearAllDataMetrics();
        this.metricsData.clearAllErrMetrics();
    }

    private static class DataButtonMouseListener
    extends MouseAdapter {
        private final JTable table;

        public DataButtonMouseListener(JTable table) {
            this.table = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object value;
            int column = this.table.getColumnModel().getColumnIndexAtX(e.getX());
            int row = e.getY() / this.table.getRowHeight();
            if (row < this.table.getRowCount() && row >= 0 && column < this.table.getColumnCount() && column >= 0 && (value = this.table.getValueAt(row, column)) instanceof JButton) {
                ((JButton)value).doClick();
            }
        }
    }

    private static class DataButtonRenderer
    implements TableCellRenderer {
        private DataButtonRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JButton button = (JButton)value;
            if (isSelected) {
                button.setForeground(table.getSelectionForeground());
                button.setBackground(table.getSelectionBackground());
            } else {
                button.setForeground(table.getForeground());
                button.setBackground(UIManager.getColor("Button.background"));
            }
            return button;
        }
    }

    public class NetMetricsDataTableModel
    extends AbstractTableModel {
        public static final int DATANAME_COLUMN = 0;
        public static final int DATACOUNT_COLUMN = 1;
        public static final int DATABLANK_COLUMN = 2;
        public static final int DATARESET_COLUMN = 3;
        public static final int DATANUMCOLUMNS = 4;

        @Override
        public String getColumnName(int c) {
            return CMRInetMetricsFrame.this.CMRInetMetricsDataColumnsNames[c];
        }

        public Class<?> getColumnClass(int r, int c) {
            switch (c) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 3: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return CMRInetMetricsData.CMRInetMetricDataName.length;
        }

        @Override
        public Object getValueAt(final int r, int c) {
            switch (c) {
                case 0: {
                    return CMRInetMetricsData.CMRInetMetricDataName[r];
                }
                case 1: {
                    return CMRInetMetricsFrame.this.metricsData.CMRInetMetricDataCount[r];
                }
                case 3: {
                    JButton button = new JButton(CMRInetMetricsFrame.this.CMRInetMetricsDataColumnsNames[c]);
                    button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            CMRInetMetricsFrame.this.metricsData.zeroMetricDataValue(r);
                        }
                    });
                    this.fireTableDataChanged();
                    return button;
                }
            }
            return " ";
        }

        public void setValueAt(int value, int r, int c) {
            switch (c) {
                case 1: {
                    CMRInetMetricsFrame.this.metricsData.setMetricDataValue(r, value);
                    break;
                }
            }
            this.fireTableDataChanged();
        }
    }

    private static class ErrMetricButtonMouseListener
    extends MouseAdapter {
        private final JTable table;

        public ErrMetricButtonMouseListener(JTable table) {
            this.table = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object value;
            int column = this.table.getColumnModel().getColumnIndexAtX(e.getX());
            int row = e.getY() / this.table.getRowHeight();
            if (row < this.table.getRowCount() && row >= 0 && column < this.table.getColumnCount() && column >= 0 && (value = this.table.getValueAt(row, column)) instanceof JButton) {
                ((JButton)value).doClick();
            }
        }
    }

    private static class ErrMetricButtonRenderer
    implements TableCellRenderer {
        private ErrMetricButtonRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JButton button = (JButton)value;
            if (isSelected) {
                button.setForeground(table.getSelectionForeground());
                button.setBackground(table.getSelectionBackground());
            } else {
                button.setForeground(table.getForeground());
                button.setBackground(UIManager.getColor("Button.background"));
            }
            return button;
        }
    }

    public class NetMetricsTableModel
    extends AbstractTableModel {
        public static final int ERRORNAME_COLUMN = 0;
        public static final int ERRORCOUNT_COLUMN = 1;
        public static final int BLANK_COLUMN = 2;
        public static final int ERRORRESET_COLUMN = 3;
        public static final int NUMCOLUMNS = 4;

        @Override
        public String getColumnName(int c) {
            return CMRInetMetricsFrame.this.CMRInetMetricsErrColumnsNames[c];
        }

        public Class<?> getColumnClass(int r, int c) {
            switch (c) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 3: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return CMRInetMetricsData.CMRInetMetricErrName.length;
        }

        @Override
        public Object getValueAt(final int r, int c) {
            switch (c) {
                case 0: {
                    return CMRInetMetricsData.CMRInetMetricErrName[r];
                }
                case 1: {
                    return CMRInetMetricsFrame.this.metricsData.getMetricErrorCount(r);
                }
                case 3: {
                    JButton button = new JButton(CMRInetMetricsFrame.this.CMRInetMetricsErrColumnsNames[c]);
                    button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            CMRInetMetricsFrame.this.metricsData.zeroMetricErrValue(r);
                        }
                    });
                    this.fireTableDataChanged();
                    return button;
                }
            }
            return " ";
        }

        public void setValueAt(int value, int r, int c) {
            switch (c) {
                case 1: {
                    CMRInetMetricsFrame.this.metricsData.setMetricErrorValue(r, value);
                    break;
                }
            }
            this.fireTableDataChanged();
        }
    }
}

