/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial.cmrinetmetrics;

import jmri.jmrix.cmri.serial.SerialListener;
import jmri.jmrix.cmri.serial.SerialMessage;
import jmri.jmrix.cmri.serial.SerialReply;
import jmri.jmrix.cmri.serial.cmrinetmetrics.CMRInetMetricsData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMRInetMetricsCollector
implements SerialListener {
    private CMRInetMetricsData _data = new CMRInetMetricsData();
    private static final Logger log = LoggerFactory.getLogger((String)CMRInetMetricsCollector.class.getName());

    public CMRInetMetricsCollector() {
        this._data.clearAllErrMetrics();
        this._data.clearAllDataMetrics();
    }

    protected void init() {
        log.info("CMRInetMetricsCollector - init");
    }

    public CMRInetMetricsData getMetricData() {
        return this._data;
    }

    @Override
    public synchronized void message(SerialMessage l) {
        int aPacketTypeID = 0;
        if (l.getNumDataElements() < 2) {
            this._data.incMetricErrValue(1);
            return;
        }
        aPacketTypeID = l.getElement(1);
        switch (aPacketTypeID) {
            case 65: 
            case 67: 
            case 68: 
            case 69: {
                break;
            }
            case 73: {
                this._data.incMetricDataValue(CMRInetMetricsData.CMRInetMetricInitMsgs);
                break;
            }
            case 77: {
                break;
            }
            case 80: {
                this._data.startPollIntervalTimer();
                break;
            }
            case 81: 
            case 82: 
            case 84: 
            case 87: {
                break;
            }
            default: {
                this._data.incMetricErrValue(4);
            }
        }
    }

    @Override
    public synchronized void reply(SerialReply l) {
        int aPacketTypeID = 0;
        if (l.getNumDataElements() < 2) {
            this._data.incMetricErrValue(2);
            return;
        }
        aPacketTypeID = l.getElement(1);
        switch (aPacketTypeID) {
            case 65: 
            case 67: 
            case 68: {
                break;
            }
            case 69: 
            case 82: {
                this._data.computePollInterval();
                break;
            }
            case 73: 
            case 77: 
            case 80: 
            case 81: {
                break;
            }
            case 84: 
            case 87: {
                break;
            }
            default: {
                this._data.incMetricErrValue(4);
            }
        }
    }
}

