/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial.diagnostic;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.SerialListener;
import jmri.jmrix.cmri.serial.SerialMessage;
import jmri.jmrix.cmri.serial.SerialNode;
import jmri.jmrix.cmri.serial.SerialReply;
import jmri.jmrix.cmri.serial.SerialTrafficController;
import jmri.jmrix.cmri.serial.diagnostic.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticFrame
extends JmriJFrame
implements SerialListener {
    protected int numTestNodes = 0;
    protected SerialNode[] testNodes = new SerialNode[128];
    protected int[] testNodeAddresses = new int[128];
    protected SerialNode testNode = null;
    public int testNodeAddr = 0;
    protected String testNodeID = "x";
    protected int testNodeType = 0;
    JComboBox<String> nodeSelBox = new JComboBox();
    JComboBox<String> testSelectBox = new JComboBox();
    public static final int testType_Outputs = 0;
    public static final int testType_Wraparound = 1;
    public static final int testType_SendCommand = 2;
    public static final int testType_WriteBytes = 3;
    protected int selTestType = 0;
    protected boolean outTest = true;
    protected boolean wrapTest = false;
    protected boolean isSMINI = false;
    protected boolean isUSIC_SUSIC = true;
    protected boolean isCPNODE = false;
    protected int numOutputCards = 2;
    protected int numInputCards = 1;
    protected int numCards = 3;
    protected int numIOXInputCards = 0;
    protected int numIOXOutputCards = 0;
    protected int outCardNum = 0;
    protected int obsDelay = 500;
    protected int inCardNum = 2;
    protected int filterDelay = 0;
    protected boolean testRunning = false;
    protected boolean testSuspended = false;
    protected byte[] outBytes = new byte[256];
    protected int curOutByte = 0;
    protected int curOutBit = 0;
    protected short curOutValue = 0;
    protected int nOutBytes = 6;
    protected int begOutByte = 0;
    protected int endOutByte = 2;
    protected int totalOutBytes = 0;
    protected int portsPerCard = 0;
    protected byte[] inBytes = new byte[256];
    protected byte[] wrapBytes = new byte[4];
    protected int nInBytes = 3;
    protected int begInByte = 0;
    protected int replyCount = 0;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="unsync access only during initialization")
    protected int endInByte = 2;
    protected int numErrors = 0;
    protected int numIterations = 0;
    protected Timer outTimer;
    protected Timer wrapTimer;
    protected Timer pollTimer;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="unsync access only during initialization")
    protected boolean waitingOnInput = false;
    protected boolean waitingResponse = false;
    protected boolean needInputTest = false;
    protected int count = 20;
    int debugCount = 0;
    ButtonGroup testGroup = new ButtonGroup();
    JCheckBox invertOutButton = new JCheckBox(Bundle.getMessage("ButtonInvert"), false);
    JCheckBox invertWrapButton = new JCheckBox(Bundle.getMessage("ButtonInvert"), false);
    JCheckBox invertWriteButton = new JCheckBox(Bundle.getMessage("ButtonInvert"), false);
    JButton initButton = new JButton(Bundle.getMessage("ButtonInitializeNode"));
    JButton pollButton = new JButton(Bundle.getMessage("ButtonPollNode"));
    JButton writeButton = new JButton(Bundle.getMessage("ButtonWriteBytes"));
    JButton haltPollButton = new JButton("Halt Polling");
    JTextField uaAddrField = new JTextField(3);
    JTextField outCardField = new JTextField(3);
    JTextField inCardField = new JTextField(3);
    JTextField obsDelayField = new JTextField(5);
    JTextField filterDelayField = new JTextField(5);
    JTextField writeCardField = new JTextField(3);
    JTextField writeBytesField = new JTextField(9);
    JButton runButton = new JButton(Bundle.getMessage("ButtonRun"));
    JButton stopButton = new JButton(Bundle.getMessage("ButtonStop"));
    JButton continueButton = new JButton(Bundle.getMessage("ButtonContinue"));
    JLabel nodeText1 = new JLabel();
    JLabel nodeText2 = new JLabel();
    JLabel testReqEquip = new JLabel(Bundle.getMessage("NeededEquipmentTitle"));
    JLabel testEquip = new JLabel();
    JLabel nodeReplyLabel = new JLabel(Bundle.getMessage("NodeReplyLabel"));
    JLabel nodeReplyText = new JLabel();
    JLabel writeCardLabel = new JLabel("Out Card:");
    JLabel writeBytesLabel = new JLabel("Output Bytes (Hex):");
    JLabel statusText1 = new JLabel();
    JLabel statusText2 = new JLabel();
    JLabel compareErr = new JLabel();
    DiagnosticFrame curFrame = this;
    private CMRISystemConnectionMemo _memo = null;
    private static final Logger log = LoggerFactory.getLogger(DiagnosticFrame.class);

    public DiagnosticFrame(CMRISystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    public void initComponents() {
        this.initializeNodes();
        this.nodeSelBox.setEditable(false);
        if (this.numTestNodes > 0) {
            this.nodeSelBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DiagnosticFrame.this.displayNodeInfo((String)DiagnosticFrame.this.nodeSelBox.getSelectedItem());
                }
            });
        }
        this.setTitle(Bundle.getMessage("DiagnosticTitle") + Bundle.getMessage("WindowConnectionMemo") + this._memo.getUserName());
        this.setSize(500, 200);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel panelNode = new JPanel();
        panelNode.setLayout(new BoxLayout(panelNode, 1));
        JPanel panelNode1 = new JPanel();
        panelNode1.setLayout(new FlowLayout());
        panelNode1.add(new JLabel(Bundle.getMessage("LabelNodeAddress")));
        panelNode1.add(this.nodeSelBox);
        this.nodeSelBox.setToolTipText(Bundle.getMessage("SelectNodeAddressTip"));
        panelNode1.add(this.nodeText1);
        this.nodeText1.setText("Node Type/Card Size");
        panelNode.add(panelNode1);
        JPanel panelNode2 = new JPanel();
        panelNode2.setLayout(new FlowLayout());
        this.nodeText2.setText("Ins and Outs");
        panelNode2.add(this.nodeText2);
        panelNode.add(panelNode2);
        Border panelNodeBorder = BorderFactory.createEtchedBorder();
        TitledBorder panelNodeTitled = BorderFactory.createTitledBorder(panelNodeBorder, Bundle.getMessage("TestNodeTitle"));
        panelNode.setBorder(panelNodeTitled);
        contentPane.add(panelNode);
        JPanel panelTest = new JPanel();
        panelTest.setLayout(new BoxLayout(panelTest, 1));
        JPanel panelTest1 = new JPanel();
        panelTest1.setLayout(new FlowLayout(3));
        this.testSelectBox.addItem(Bundle.getMessage("ButtonTestOutput"));
        this.testSelectBox.addItem(Bundle.getMessage("ButtonTestLoopback"));
        this.testSelectBox.addItem(Bundle.getMessage("ButtonTestSendCommands"));
        panelTest1.add(this.testSelectBox);
        this.testSelectBox.setToolTipText(Bundle.getMessage("TestTypeToolLabel"));
        this.haltPollButton.setVisible(true);
        this.haltPollButton.setToolTipText(Bundle.getMessage("HaltPollButtonTip"));
        this.haltPollButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagnosticFrame.this.haltpollButtonActionPerformed();
            }
        });
        panelTest1.add(this.haltPollButton);
        SerialTrafficController stc = this._memo.getTrafficController();
        if (stc.getPollNetwork()) {
            this.haltPollButton.setText(Bundle.getMessage("HaltPollButtonText"));
        } else {
            this.haltPollButton.setText(Bundle.getMessage("ResumePollButtonText"));
        }
        panelTest.add(panelTest1);
        JPanel panel11 = new JPanel();
        panel11.setLayout(new FlowLayout(0));
        this.testReqEquip.setText(Bundle.getMessage("NeededEquipmentTitle"));
        panel11.add(this.testReqEquip);
        panel11.add(this.testEquip);
        this.testEquip.setToolTipText(Bundle.getMessage("NeededTestEquipmentTip"));
        panelTest.add(panel11);
        Border panel1Border = BorderFactory.createEtchedBorder();
        TitledBorder panel1Titled = BorderFactory.createTitledBorder(panel1Border, Bundle.getMessage("TestTypeTitle"));
        panelTest.setBorder(panel1Titled);
        contentPane.add(panelTest);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        final JPanel panel21 = new JPanel();
        panel21.setLayout(new FlowLayout());
        panel21.add(new JLabel("  " + Bundle.getMessage("OutCardLabel")));
        panel21.add(this.outCardField);
        this.outCardField.setToolTipText(Bundle.getMessage("OutCardToolTip"));
        this.outCardField.setText("0");
        panel21.add(this.invertOutButton);
        this.invertOutButton.setToolTipText(Bundle.getMessage("InvertToolTip"));
        panel21.add(new JLabel("   " + Bundle.getMessage("ObservationDelayLabel")));
        panel21.add(this.obsDelayField);
        this.obsDelayField.setToolTipText(Bundle.getMessage("ObservationDelayToolTip"));
        this.obsDelayField.setText(Integer.toString(this.obsDelay));
        final JPanel panel22 = new JPanel();
        panel22.setLayout(new FlowLayout());
        panel22.add(new JLabel(Bundle.getMessage("InCardToolLabel")));
        panel22.add(this.inCardField);
        panel22.add(this.invertWrapButton);
        this.invertWrapButton.setToolTipText(Bundle.getMessage("InvertToolTip"));
        this.inCardField.setToolTipText(Bundle.getMessage("InCardToolTip"));
        this.inCardField.setText("2");
        panel22.add(new JLabel("   " + Bundle.getMessage("FilteringDelayLabel")));
        panel22.add(this.filterDelayField);
        this.filterDelayField.setToolTipText(Bundle.getMessage("FilteringDelayToolTip"));
        this.filterDelayField.setText("0");
        final JPanel panel23 = new JPanel();
        panel23.setLayout(new FlowLayout(0));
        panel23.add(this.initButton);
        this.initButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagnosticFrame.this.sendInitalizePacket();
            }
        });
        this.pollButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagnosticFrame.this.pollButtonActionPerformed(e);
            }
        });
        final JPanel panel23a = new JPanel();
        panel23a.setLayout(new FlowLayout(0));
        panel23a.add(this.pollButton);
        panel23a.add(this.nodeReplyLabel);
        panel23a.add(this.nodeReplyText);
        final JPanel panel24 = new JPanel();
        panel24.setLayout(new FlowLayout(0));
        panel24.add(this.writeButton);
        this.writeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagnosticFrame.this.sendButtonActionPerformed(e);
            }
        });
        panel24.add(this.writeCardLabel);
        panel24.add(this.writeCardField);
        this.writeCardField.setText("0");
        panel24.add(this.invertWriteButton);
        panel24.add(this.writeBytesLabel);
        panel24.add(this.writeBytesField);
        this.writeBytesField.setText("0");
        final JPanel panel25 = new JPanel();
        panel25.setLayout(new FlowLayout());
        panel2.add(panel21);
        panel2.add(panel22);
        panel22.setVisible(false);
        panel2.add(panel23);
        panel23.setVisible(false);
        panel2.add(panel23a);
        panel23a.setVisible(false);
        panel2.add(panel24);
        panel24.setVisible(false);
        panel2.add(panel25);
        panel25.setVisible(false);
        Border panel2Border = BorderFactory.createEtchedBorder();
        TitledBorder panel2Titled = BorderFactory.createTitledBorder(panel2Border, Bundle.getMessage("TestSetUpTitle"));
        panel2.setBorder(panel2Titled);
        contentPane.add(panel2);
        this.testSelectBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DiagnosticFrame.this.selTestType = DiagnosticFrame.this.testSelectBox.getSelectedIndex();
                switch (DiagnosticFrame.this.selTestType) {
                    case 0: {
                        DiagnosticFrame.this.testEquip.setText(Bundle.getMessage("OutputTestEquipment"));
                        panel21.setVisible(true);
                        panel22.setVisible(false);
                        panel23.setVisible(false);
                        panel23a.setVisible(false);
                        panel24.setVisible(false);
                        panel25.setVisible(false);
                        DiagnosticFrame.this.runButton.setEnabled(true);
                        DiagnosticFrame.this.stopButton.setEnabled(true);
                        DiagnosticFrame.this.continueButton.setVisible(false);
                        DiagnosticFrame.this.displayNodeInfo(DiagnosticFrame.this.testNodeID);
                        break;
                    }
                    case 1: {
                        DiagnosticFrame.this.testEquip.setText(Bundle.getMessage("WrapTestEquipment"));
                        panel21.setVisible(true);
                        panel22.setVisible(true);
                        panel23.setVisible(false);
                        panel23a.setVisible(false);
                        panel24.setVisible(false);
                        panel25.setVisible(false);
                        DiagnosticFrame.this.invertOutButton.setVisible(false);
                        DiagnosticFrame.this.runButton.setEnabled(true);
                        DiagnosticFrame.this.stopButton.setEnabled(true);
                        DiagnosticFrame.this.continueButton.setVisible(true);
                        DiagnosticFrame.this.invertWrapButton.setSelected(DiagnosticFrame.this.testNodeType == 3);
                        DiagnosticFrame.this.displayNodeInfo(DiagnosticFrame.this.testNodeID);
                        break;
                    }
                    case 2: {
                        DiagnosticFrame.this.testEquip.setText(Bundle.getMessage("SendCommandEquipment"));
                        panel21.setVisible(false);
                        panel22.setVisible(false);
                        panel23.setVisible(true);
                        panel23a.setVisible(true);
                        panel24.setVisible(true);
                        panel25.setVisible(false);
                        DiagnosticFrame.this.runButton.setEnabled(false);
                        DiagnosticFrame.this.stopButton.setEnabled(false);
                        DiagnosticFrame.this.continueButton.setVisible(false);
                        DiagnosticFrame.this.displayNodeInfo(DiagnosticFrame.this.testNodeID);
                        break;
                    }
                    case 3: {
                        DiagnosticFrame.this.testEquip.setText(Bundle.getMessage("WriteBytesEquipment"));
                        panel21.setVisible(false);
                        panel22.setVisible(false);
                        panel23.setVisible(false);
                        panel23a.setVisible(false);
                        panel24.setVisible(false);
                        panel25.setVisible(true);
                        DiagnosticFrame.this.displayNodeInfo(DiagnosticFrame.this.testNodeID);
                        break;
                    }
                    default: {
                        log.debug("default case in testSelectBox switch");
                    }
                }
            }
        });
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel31 = new JPanel();
        panel31.setLayout(new FlowLayout());
        this.statusText1.setText(Bundle.getMessage("StatusLine1"));
        this.statusText1.setVisible(true);
        this.statusText1.setMaximumSize(new Dimension(this.statusText1.getMaximumSize().width, this.statusText1.getPreferredSize().height));
        panel31.add(this.statusText1);
        JPanel panel32 = new JPanel();
        panel32.setLayout(new FlowLayout());
        this.statusText2.setText(Bundle.getMessage("StatusLine2", Bundle.getMessage("ButtonRun")));
        this.statusText2.setVisible(true);
        this.statusText2.setMaximumSize(new Dimension(this.statusText2.getMaximumSize().width, this.statusText2.getPreferredSize().height));
        panel32.add(this.statusText2);
        JPanel panel33 = new JPanel();
        panel33.setLayout(new FlowLayout());
        this.compareErr.setText("   ");
        this.compareErr.setVisible(true);
        this.compareErr.setMaximumSize(new Dimension(this.compareErr.getMaximumSize().width, this.compareErr.getPreferredSize().height));
        panel33.add(this.compareErr);
        panel3.add(panel31);
        panel3.add(panel32);
        panel3.add(panel33);
        Border panel3Border = BorderFactory.createEtchedBorder();
        TitledBorder panel3Titled = BorderFactory.createTitledBorder(panel3Border, Bundle.getMessage("StatusTitle"));
        panel3.setBorder(panel3Titled);
        contentPane.add(panel3);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new FlowLayout());
        this.continueButton.setText(Bundle.getMessage("ButtonContinue"));
        this.continueButton.setVisible(false);
        this.continueButton.setToolTipText(Bundle.getMessage("ContinueTestToolTip"));
        this.continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagnosticFrame.this.continueButtonActionPerformed(e);
            }
        });
        panel4.add(this.continueButton);
        this.stopButton.setText(Bundle.getMessage("ButtonStop"));
        this.stopButton.setVisible(true);
        this.stopButton.setToolTipText(Bundle.getMessage("StopToolTip"));
        panel4.add(this.stopButton);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagnosticFrame.this.stopButtonActionPerformed(e);
            }
        });
        this.runButton.setText(Bundle.getMessage("ButtonRun"));
        this.runButton.setVisible(true);
        this.runButton.setToolTipText(Bundle.getMessage("RunTestToolTip"));
        panel4.add(this.runButton);
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagnosticFrame.this.runButtonActionPerformed(e);
            }
        });
        contentPane.add(panel4);
        if (this.numTestNodes > 0) {
            this.displayNodeInfo((String)this.nodeSelBox.getSelectedItem());
        }
        this.testSelectBox.setSelectedIndex(this.selTestType);
        this.addHelpMenu("package.jmri.jmrix.cmri.serial.diagnostic.DiagnosticFrame", true);
        this.pack();
    }

    public void initializeNodes() {
        String str = "";
        for (int i = 0; i < 128; ++i) {
            this.testNodeAddresses[i] = -1;
            this.testNodes[i] = null;
        }
        SerialNode node = (SerialNode)this._memo.getTrafficController().getNode(0);
        int index = 1;
        while (node != null) {
            this.testNodes[this.numTestNodes] = node;
            this.testNodeAddresses[this.numTestNodes] = node.getNodeAddress();
            str = Integer.toString(this.testNodeAddresses[this.numTestNodes]);
            this.nodeSelBox.addItem(str);
            if (index == 1) {
                this.testNode = node;
                this.testNodeAddr = this.testNodeAddresses[this.numTestNodes];
                this.testNodeID = "y";
            }
            ++this.numTestNodes;
            node = (SerialNode)this._memo.getTrafficController().getNode(index);
            ++index;
        }
    }

    public void displayNodeInfo(String nodeID) {
        if (!nodeID.equals(this.testNodeID)) {
            int aTestNum = Integer.parseInt(nodeID);
            SerialNode s = null;
            for (int k = 0; k < this.numTestNodes; ++k) {
                if (aTestNum != this.testNodeAddresses[k]) continue;
                s = this.testNodes[k];
            }
            if (s == null) {
                log.error("Cannot find Node {} in list of configured Nodes.", (Object)nodeID);
                return;
            }
            this.testNodeID = nodeID;
            this.testNode = s;
            this.testNodeAddr = aTestNum;
            int bitsPerCard = this.testNode.getNumBitsPerCard();
            this.testNodeType = this.testNode.getNodeType();
            String s1 = "";
            String s2 = "";
            switch (this.testNodeType) {
                case 1: {
                    bitsPerCard = this.testNode.getNumBitsPerCard();
                    this.numInputCards = this.testNode.numInputCards();
                    this.numOutputCards = this.testNode.numOutputCards();
                    this.numIOXInputCards = 0;
                    this.numIOXOutputCards = 0;
                    this.nodeText1.setText("  SMINI - " + bitsPerCard + " " + Bundle.getMessage("BitsPerCard"));
                    this.nodeText2.setText(this.numInputCards + " " + Bundle.getMessage("InputCard") + ", " + this.numOutputCards + " " + Bundle.getMessage("OutputCard") + "s");
                    break;
                }
                case 2: {
                    bitsPerCard = this.testNode.getNumBitsPerCard();
                    this.numInputCards = this.testNode.numInputCards();
                    this.numOutputCards = this.testNode.numOutputCards();
                    this.numIOXInputCards = 0;
                    this.numIOXOutputCards = 0;
                    if (this.numInputCards > 1) {
                        s1 = "s";
                    }
                    if (this.numOutputCards > 1) {
                        s2 = "s";
                    }
                    this.nodeText1.setText("  USIC_SUSIC - " + bitsPerCard + " " + Bundle.getMessage("BitsPerCard"));
                    this.nodeText2.setText(this.numInputCards + " " + Bundle.getMessage("InputCard") + s1 + ", " + this.numOutputCards + " " + Bundle.getMessage("OutputCard") + s2);
                    break;
                }
                case 3: {
                    bitsPerCard = this.testNode.getNumBitsPerCard();
                    this.numInputCards = this.testNode.numInputCards();
                    this.numOutputCards = this.testNode.numOutputCards();
                    this.numIOXInputCards = this.testNode.numInputCards() - 2;
                    this.numIOXOutputCards = this.testNode.numOutputCards() - 2;
                    if (this.numInputCards > 1) {
                        s1 = "s";
                    }
                    if (this.numOutputCards > 1) {
                        s2 = "s";
                    }
                    this.nodeText1.setText("  CPNODE - " + bitsPerCard + " " + Bundle.getMessage("BitsPerCard"));
                    this.nodeText2.setText(this.numInputCards + " " + Bundle.getMessage("InputCard") + s1 + ", " + this.numOutputCards + " " + Bundle.getMessage("OutputCard") + s2 + "  IOX: " + this.numIOXInputCards + " " + Bundle.getMessage("InputsTitle") + ", " + this.numIOXOutputCards + " " + Bundle.getMessage("OutputsTitle"));
                    this.invertWrapButton.setSelected(this.testNodeType == 3);
                    break;
                }
                case 4: {
                    this.numIOXInputCards = 0;
                    this.numIOXOutputCards = 0;
                    this.nodeText1.setText("CPMEGA - " + bitsPerCard + " " + Bundle.getMessage("BitsPerCard"));
                    break;
                }
                default: {
                    this.nodeText1.setText("Unknown Node Type " + this.testNodeType);
                }
            }
        }
        this.statusText1.setVisible(true);
        this.statusText2.setVisible(true);
    }

    public void runButtonActionPerformed(ActionEvent e) {
        if (!this.testRunning && this.readSetupData()) {
            if (this.outTest) {
                if (this.initializeOutputTest()) {
                    this.runOutputTest();
                }
            } else if (this.wrapTest && this.initializeWraparoundTest()) {
                this.runWraparoundTest();
            }
        }
    }

    protected boolean readSetupData() {
        switch (this.selTestType) {
            case 0: {
                this.outTest = true;
                this.wrapTest = false;
                break;
            }
            case 1: {
                this.outTest = false;
                this.wrapTest = true;
                break;
            }
            case 2: 
            case 3: {
                this.outTest = false;
                this.wrapTest = false;
                break;
            }
            default: {
                log.debug("default case in testSelectBox switch");
            }
        }
        this.testNode = (SerialNode)this._memo.getTrafficController().getNodeFromAddress(this.testNodeAddr);
        if (this.testNode == null) {
            this.statusText1.setText(Bundle.getMessage("DiagnosticError3"));
            this.statusText1.setVisible(true);
            return false;
        }
        int type = this.testNode.getNodeType();
        this.isSMINI = type == 1;
        this.isUSIC_SUSIC = type == 2;
        this.isCPNODE = type == 3;
        this.numOutputCards = this.testNode.numOutputCards();
        this.numInputCards = this.testNode.numInputCards();
        this.numCards = this.numOutputCards + this.numInputCards;
        try {
            this.outCardNum = Integer.parseInt(this.outCardField.getText());
        }
        catch (Exception e) {
            this.statusText1.setText(Bundle.getMessage("DiagnosticError4"));
            this.statusText1.setVisible(true);
            return false;
        }
        if (this.isUSIC_SUSIC) {
            if (this.outCardNum < 0 || this.outCardNum >= this.numCards) {
                this.statusText1.setText(Bundle.getMessage("DiagnosticError5", Integer.toString(this.numCards - 1)));
                this.statusText1.setVisible(true);
                return false;
            }
            if (!this.testNode.isOutputCard(this.outCardNum)) {
                this.statusText1.setText(Bundle.getMessage("DiagnosticError6"));
                this.statusText1.setVisible(true);
                return false;
            }
        }
        if (this.isSMINI && (this.outCardNum < 0 || this.outCardNum > 1)) {
            this.statusText1.setText(Bundle.getMessage("DiagnosticError7"));
            this.statusText1.setVisible(true);
            return false;
        }
        if (this.isCPNODE && !this.testNode.isOutputCard(this.outCardNum + 2)) {
            this.statusText1.setText(Bundle.getMessage("DiagnosticError6"));
            this.statusText1.setVisible(true);
            return false;
        }
        if (this.outTest) {
            try {
                this.obsDelay = Integer.parseInt(this.obsDelayField.getText());
            }
            catch (Exception e) {
                this.statusText1.setText(Bundle.getMessage("DiagnosticError8"));
                this.statusText1.setVisible(true);
                return false;
            }
        }
        if (this.wrapTest) {
            try {
                this.inCardNum = Integer.parseInt(this.inCardField.getText());
            }
            catch (Exception e) {
                this.statusText1.setText(Bundle.getMessage("DiagnosticError9"));
                this.statusText1.setVisible(true);
                return false;
            }
            if (this.isUSIC_SUSIC) {
                if (this.inCardNum < 0 || this.inCardNum >= this.numCards) {
                    this.statusText1.setText(Bundle.getMessage("DiagnosticError10", Integer.toString(this.numCards - 1)));
                    this.statusText1.setVisible(true);
                    return false;
                }
                if (!this.testNode.isInputCard(this.inCardNum)) {
                    this.statusText1.setText(Bundle.getMessage("DiagnosticError11"));
                    this.statusText1.setVisible(true);
                    return false;
                }
            }
            if (this.isSMINI && this.inCardNum != 2) {
                this.statusText1.setText(Bundle.getMessage("DiagnosticError12"));
                this.statusText1.setVisible(true);
                return false;
            }
            try {
                this.filterDelay = Integer.parseInt(this.filterDelayField.getText());
            }
            catch (Exception e) {
                this.statusText1.setText(Bundle.getMessage("DiagnosticError13"));
                this.statusText1.setVisible(true);
                return false;
            }
        }
        this.portsPerCard = this.testNode.getNumBitsPerCard() / 8;
        this.begOutByte = this.testNodeType != 3 ? this.testNode.getOutputCardIndex(this.outCardNum) * this.portsPerCard : this.testNode.getOutputCardIndex(this.outCardNum + 2) * this.portsPerCard;
        this.endOutByte = this.begOutByte + this.portsPerCard - 1;
        this.nOutBytes = this.numOutputCards * this.portsPerCard;
        if (this.wrapTest) {
            this.begInByte = this.testNode.getInputCardIndex(this.inCardNum) * this.portsPerCard;
            this.endInByte = this.begInByte + this.portsPerCard - 1;
            this.nInBytes = this.numInputCards * this.portsPerCard;
        }
        return true;
    }

    public void continueButtonActionPerformed(ActionEvent e) {
        if (this.testRunning && this.testSuspended) {
            this.testSuspended = false;
            if (this.wrapTest) {
                this.statusText1.setText(Bundle.getMessage("StatusRunningWraparoundTest"));
                this.statusText1.setVisible(true);
            }
        }
    }

    public void stopButtonActionPerformed(ActionEvent e) {
        if (this.testRunning) {
            if (this.outTest) {
                this.stopOutputTest();
            } else if (this.wrapTest) {
                this.stopWraparoundTest();
            }
            this.testRunning = false;
        }
    }

    public void haltpollButtonActionPerformed() {
        SerialTrafficController stc;
        stc.setPollNetwork(!(stc = this._memo.getTrafficController()).getPollNetwork());
        if (stc.getPollNetwork()) {
            this.haltPollButton.setText(Bundle.getMessage("HaltPollButtonText"));
        } else {
            this.haltPollButton.setText(Bundle.getMessage("ResumePollButtonText"));
        }
    }

    protected synchronized boolean initializeOutputTest() {
        for (int i = 0; i < this.nOutBytes; ++i) {
            this.outBytes[i] = 0;
        }
        if (this.obsDelay < 250) {
            this.obsDelay = 250;
        }
        this.curOutByte = this.begOutByte;
        this.curOutBit = 0;
        this._memo.getTrafficController().sendSerialMessage((SerialMessage)this.testNode.createInitPacket(), this.curFrame);
        try {
            this.wait(1000L);
        }
        catch (InterruptedException e) {
            log.debug("interrupted");
            return false;
        }
        this.numIterations = 0;
        this.testRunning = true;
        return true;
    }

    protected void runOutputTest() {
        this.outTimer = new Timer(this.obsDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evnt) {
                if (DiagnosticFrame.this.testRunning && DiagnosticFrame.this.outTest) {
                    int[] outBitPattern = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
                    String[] portID = new String[]{"A", "B", "C", "D"};
                    if (DiagnosticFrame.this.invertOutButton.isSelected()) {
                        for (int i = 0; i < 8; ++i) {
                            outBitPattern[i] = ~outBitPattern[i];
                        }
                    }
                    DiagnosticFrame.this.outBytes[DiagnosticFrame.this.curOutByte] = (byte)outBitPattern[DiagnosticFrame.this.curOutBit];
                    SerialMessage m = DiagnosticFrame.this.createOutPacket();
                    m.setTimeout(50);
                    DiagnosticFrame.this._memo.getTrafficController().sendSerialMessage(m, DiagnosticFrame.this.curFrame);
                    DiagnosticFrame.this.statusText1.setText(Bundle.getMessage("StatusLine3", portID[DiagnosticFrame.this.curOutByte - DiagnosticFrame.this.begOutByte], Integer.toString(DiagnosticFrame.this.curOutBit)));
                    DiagnosticFrame.this.statusText1.setVisible(true);
                    StringBuilder st = new StringBuilder();
                    for (int i = DiagnosticFrame.this.begOutByte; i <= DiagnosticFrame.this.endOutByte; ++i) {
                        st.append("  ");
                        for (int j = 0; j < 8; ++j) {
                            if (i == DiagnosticFrame.this.curOutByte && j == DiagnosticFrame.this.curOutBit) {
                                st.append("1 ");
                                continue;
                            }
                            st.append("0 ");
                        }
                    }
                    DiagnosticFrame.this.statusText2.setText(st.reverse().toString());
                    DiagnosticFrame.this.statusText2.setVisible(true);
                    ++DiagnosticFrame.this.curOutBit;
                    if (DiagnosticFrame.this.curOutBit > 7) {
                        DiagnosticFrame.this.curOutBit = 0;
                        DiagnosticFrame.this.outBytes[DiagnosticFrame.this.curOutByte] = 0;
                        ++DiagnosticFrame.this.curOutByte;
                        if (DiagnosticFrame.this.curOutByte > DiagnosticFrame.this.endOutByte) {
                            DiagnosticFrame.this.curOutByte = DiagnosticFrame.this.begOutByte;
                            ++DiagnosticFrame.this.numIterations;
                        }
                    }
                }
            }
        });
        this.outTimer.start();
    }

    protected void stopOutputTest() {
        if (this.testRunning && this.outTest) {
            this.outTimer.stop();
            this.statusText1.setText(Bundle.getMessage("StatusLine4", Integer.toString(this.numIterations)));
            this.statusText1.setVisible(true);
            this.statusText2.setText("  ");
            this.statusText2.setVisible(true);
        }
    }

    protected synchronized boolean sendInitalizePacket() {
        this._memo.getTrafficController().sendSerialMessage((SerialMessage)this.testNode.createInitPacket(), this.curFrame);
        try {
            this.wait(1000L);
        }
        catch (InterruptedException e) {
            log.debug("interrupted");
            return false;
        }
        return true;
    }

    protected synchronized boolean initializeWraparoundTest() {
        for (int i = 0; i < this.nOutBytes; ++i) {
            this.outBytes[i] = 0;
        }
        this.curOutByte = this.begOutByte;
        this.curOutValue = 0;
        if (!this.sendInitalizePacket()) {
            return false;
        }
        this.numErrors = 0;
        this.numIterations = 0;
        this.testRunning = true;
        this.testSuspended = false;
        this.waitingOnInput = false;
        this.needInputTest = false;
        this.count = 50;
        this.compareErr.setText("  ");
        return true;
    }

    protected void runWraparoundTest() {
        this.statusText1.setText(Bundle.getMessage("StatusRunningWraparoundTest"));
        this.statusText1.setVisible(true);
        this.wrapTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evnt) {
                if (DiagnosticFrame.this.testRunning && !DiagnosticFrame.this.testSuspended) {
                    if (DiagnosticFrame.this.waitingOnInput) {
                        --DiagnosticFrame.this.count;
                        if (DiagnosticFrame.this.count == 0) {
                            DiagnosticFrame.this.statusText2.setText(Bundle.getMessage("StatusLine5"));
                            DiagnosticFrame.this.statusText2.setVisible(true);
                        }
                    } else {
                        if (DiagnosticFrame.this.needInputTest) {
                            DiagnosticFrame.this.needInputTest = false;
                            boolean comparisonError = false;
                            int j = 0;
                            int i = DiagnosticFrame.this.begInByte;
                            while (i <= DiagnosticFrame.this.endInByte) {
                                if (DiagnosticFrame.this.invertWrapButton.isSelected()) {
                                    DiagnosticFrame.this.inBytes[i] = ~DiagnosticFrame.this.inBytes[j];
                                }
                                if (DiagnosticFrame.this.inBytes[i] != DiagnosticFrame.this.wrapBytes[j]) {
                                    comparisonError = true;
                                }
                                ++i;
                                ++j;
                            }
                            if (comparisonError) {
                                int i2;
                                DiagnosticFrame.this.statusText1.setText(Bundle.getMessage("StatusLine6", Bundle.getMessage("ButtonStop"), Bundle.getMessage("ButtonContinue")));
                                DiagnosticFrame.this.statusText1.setVisible(true);
                                StringBuilder st = new StringBuilder(Bundle.getMessage("StatusLine7pt1"));
                                for (i2 = DiagnosticFrame.this.begOutByte; i2 <= DiagnosticFrame.this.endOutByte; ++i2) {
                                    st.append(" ");
                                    st.append(Integer.toHexString(DiagnosticFrame.this.outBytes[i2] & 0xFF).toUpperCase());
                                }
                                st.append("    ");
                                st.append(Bundle.getMessage("StatusLine7pt2"));
                                for (i2 = DiagnosticFrame.this.begInByte; i2 <= DiagnosticFrame.this.endInByte; ++i2) {
                                    st.append(" ");
                                    st.append(Integer.toHexString(DiagnosticFrame.this.inBytes[i2] & 0xFF).toUpperCase());
                                }
                                DiagnosticFrame.this.compareErr.setText(st.toString());
                                DiagnosticFrame.this.compareErr.setVisible(true);
                                ++DiagnosticFrame.this.numErrors;
                                DiagnosticFrame.this.testSuspended = true;
                                return;
                            }
                        }
                        DiagnosticFrame.this.outBytes[DiagnosticFrame.this.curOutByte] = (byte)DiagnosticFrame.this.curOutValue;
                        if (DiagnosticFrame.this.isSMINI) {
                            if (DiagnosticFrame.this.curOutByte > 2) {
                                DiagnosticFrame.this.outBytes[DiagnosticFrame.this.curOutByte - 3] = (byte)DiagnosticFrame.this.curOutValue;
                            } else {
                                DiagnosticFrame.this.outBytes[DiagnosticFrame.this.curOutByte + 3] = (byte)DiagnosticFrame.this.curOutValue;
                            }
                        }
                        SerialMessage m = DiagnosticFrame.this.createOutPacket();
                        m.setTimeout(50 + DiagnosticFrame.this.filterDelay);
                        DiagnosticFrame.this._memo.getTrafficController().sendSerialMessage(m, DiagnosticFrame.this.curFrame);
                        short[] outBitPattern = new short[]{1, 2, 4, 8, 16, 32, 64, 128};
                        String[] portID = new String[]{"A", "B", "C", "D"};
                        StringBuilder st = new StringBuilder(Bundle.getMessage("PortLabel"));
                        StringBuilder bp = new StringBuilder("  ");
                        st.append(portID[DiagnosticFrame.this.curOutByte - DiagnosticFrame.this.begOutByte]);
                        st.append(",  ");
                        st.append(Bundle.getMessage("PatternLabel"));
                        for (int j = 0; j < 8; ++j) {
                            if ((DiagnosticFrame.this.curOutValue & outBitPattern[j]) != 0) {
                                bp.append("1 ");
                                continue;
                            }
                            bp.append("0 ");
                        }
                        DiagnosticFrame.this.statusText2.setText(st.toString() + bp.reverse().toString());
                        DiagnosticFrame.this.statusText2.setVisible(true);
                        int k = 0;
                        int i = DiagnosticFrame.this.begOutByte;
                        while (i <= DiagnosticFrame.this.endOutByte) {
                            DiagnosticFrame.this.wrapBytes[k] = DiagnosticFrame.this.outBytes[i];
                            ++i;
                            ++k;
                        }
                        DiagnosticFrame.this.waitingOnInput = true;
                        DiagnosticFrame.this.needInputTest = true;
                        DiagnosticFrame.this.count = 50;
                        DiagnosticFrame.this._memo.getTrafficController().sendSerialMessage(SerialMessage.getPoll(DiagnosticFrame.this.testNodeAddr), DiagnosticFrame.this.curFrame);
                        DiagnosticFrame.this.curOutValue = (short)(DiagnosticFrame.this.curOutValue + 1);
                        if (DiagnosticFrame.this.curOutValue > 255) {
                            DiagnosticFrame.this.curOutValue = 0;
                            DiagnosticFrame.this.outBytes[DiagnosticFrame.this.curOutByte] = 0;
                            if (DiagnosticFrame.this.isSMINI) {
                                if (DiagnosticFrame.this.curOutByte > 2) {
                                    DiagnosticFrame.this.outBytes[DiagnosticFrame.this.curOutByte - 3] = 0;
                                } else {
                                    DiagnosticFrame.this.outBytes[DiagnosticFrame.this.curOutByte + 3] = 0;
                                }
                            }
                            ++DiagnosticFrame.this.curOutByte;
                            if (DiagnosticFrame.this.curOutByte > DiagnosticFrame.this.endOutByte) {
                                DiagnosticFrame.this.curOutByte = DiagnosticFrame.this.begOutByte;
                                ++DiagnosticFrame.this.numIterations;
                            }
                        }
                    }
                }
            }
        });
        this.wrapTimer.start();
    }

    protected void stopWraparoundTest() {
        if (this.testRunning && this.wrapTest) {
            this.wrapTimer.stop();
            this.statusText1.setText(Bundle.getMessage("StatusLine8", Integer.toString(this.numErrors)));
            this.statusText1.setVisible(true);
            this.statusText2.setText(Bundle.getMessage("StatusLine9", Integer.toString(this.numIterations)));
            this.statusText2.setVisible(true);
        }
    }

    SerialMessage createOutPacket() {
        int nDLE = 0;
        for (int i = 0; i < this.nOutBytes; ++i) {
            if (this.outBytes[i] != 2 && this.outBytes[i] != 3 && this.outBytes[i] != 16) continue;
            ++nDLE;
        }
        SerialMessage m = new SerialMessage(this.nOutBytes + nDLE + 2);
        m.setElement(0, this.testNodeAddr + 65);
        m.setElement(1, 84);
        int k = 2;
        for (int i = 0; i < this.nOutBytes; ++i) {
            if (this.outBytes[i] == 2 || this.outBytes[i] == 3 || this.outBytes[i] == 16) {
                m.setElement(k, 16);
                ++k;
            }
            m.setElement(k, this.outBytes[i]);
            ++k;
        }
        return m;
    }

    public synchronized void pollButtonActionPerformed(ActionEvent e) {
        this.portsPerCard = this.testNode.getNumBitsPerCard() / 8;
        this.begInByte = this.testNode.getInputCardIndex(this.inCardNum) * this.portsPerCard;
        this.endInByte = this.begInByte + this.portsPerCard;
        this.nInBytes = this.numInputCards * this.portsPerCard;
        this.needInputTest = true;
        this.waitingOnInput = true;
        this.waitingResponse = false;
        this.count = 30;
        this._memo.getTrafficController().sendSerialMessage(SerialMessage.getPoll(this.testNodeAddr), this.curFrame);
        this.statusText2.setText("");
        this.nodeReplyText.setText("");
        this.pollNodeReadReply();
    }

    protected synchronized void pollNodeReadReply() {
        this.pollTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evnt) {
                if (DiagnosticFrame.this.waitingOnInput) {
                    --DiagnosticFrame.this.count;
                    if (DiagnosticFrame.this.count == 0) {
                        DiagnosticFrame.this.nodeReplyText.setText(Bundle.getMessage("PollTimeOut"));
                        DiagnosticFrame.this.waitingOnInput = false;
                        DiagnosticFrame.this.pollTimer.stop();
                        return;
                    }
                } else if (DiagnosticFrame.this.waitingResponse) {
                    DiagnosticFrame.this.nodeReplyText.setText(Bundle.getMessage("InByteCount", DiagnosticFrame.this.replyCount));
                    DiagnosticFrame.this.nodeReplyText.setVisible(true);
                    DiagnosticFrame.this.waitingOnInput = false;
                    DiagnosticFrame.this.pollTimer.stop();
                    return;
                }
            }
        });
        this.pollTimer.start();
        this.waitingResponse = true;
    }

    public synchronized void sendButtonActionPerformed(ActionEvent e) {
        this.portsPerCard = this.testNode.getNumBitsPerCard() / 8;
        byte[] b = StringUtil.bytesFromHexString(this.writeBytesField.getText());
        this.totalOutBytes = this.numOutputCards * this.portsPerCard;
        this.statusText1.setText(" ");
        if (b.length == 0) {
            this.statusText1.setText(Bundle.getMessage("WriteBytesError1"));
            return;
        }
        if (b.length > this.portsPerCard) {
            this.statusText1.setText(Bundle.getMessage("WriteBytesError2", this.portsPerCard));
            return;
        }
        this.outCardNum = Integer.parseInt(this.writeCardField.getText());
        if (this.testNodeType != 3) {
            if (!this.testNode.isOutputCard(this.outCardNum)) {
                this.statusText1.setText(Bundle.getMessage("DiagnosticError6"));
                return;
            }
            this.begOutByte = this.testNode.getOutputCardIndex(this.outCardNum) * this.portsPerCard;
        } else {
            if (!this.testNode.isOutputCard(this.outCardNum + 2)) {
                this.statusText1.setText(Bundle.getMessage("DiagnosticError6"));
                return;
            }
            this.begOutByte = this.testNode.getOutputCardIndex(this.outCardNum + 2) * this.portsPerCard;
        }
        int zero = this.invertWriteButton.isSelected() ? -1 : 0;
        for (int i = 0; i < this.totalOutBytes; ++i) {
            this.outBytes[i] = (byte)zero;
        }
        int j = this.begOutByte;
        for (int i = 0; i < this.portsPerCard; ++i) {
            this.outBytes[j] = this.invertWriteButton.isSelected() ? (byte)(~b[i]) : b[i];
            ++j;
        }
        this.nOutBytes = this.totalOutBytes;
        SerialMessage m = this.createOutPacket();
        m.setTimeout(50);
        this._memo.getTrafficController().sendSerialMessage(m, this.curFrame);
    }

    @Override
    public void message(SerialMessage m) {
    }

    @Override
    public synchronized void reply(SerialReply l) {
        if (this.waitingOnInput && l.isRcv() && this.testNodeAddr == l.getUA()) {
            for (int i = this.begInByte; i <= this.endInByte; ++i) {
                this.inBytes[i] = (byte)l.getElement(i + 2);
            }
            this.replyCount = l.getNumDataElements() - 2;
            this.waitingOnInput = false;
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.testRunning) {
            if (this.outTest) {
                this.stopOutputTest();
            } else if (this.wrapTest) {
                this.stopWraparoundTest();
            }
        }
        super.windowClosing(e);
    }
}

