/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial.nodeiolist;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jmri.InstanceManager;
import jmri.Sensor;
import jmri.Turnout;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.SerialNode;
import jmri.jmrix.cmri.serial.nodeiolist.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeIOListFrame
extends JmriJFrame {
    ArrayList<SerialNode> cmriNode = new ArrayList();
    protected boolean inputSelected = true;
    protected SerialNode selNode = null;
    public int selNodeNum = 0;
    public int numBits = 48;
    public int numInputBits = 24;
    public int numOutputBits = 48;
    JLabel nodeLabel = new JLabel(Bundle.getMessage("NodeBoxLabel") + " ");
    JLabel nodeAddrBox = new JLabel("??");
    ButtonGroup bitTypeGroup = new ButtonGroup();
    JRadioButton inputBits = new JRadioButton(Bundle.getMessage("ShowInputButton") + "   ", true);
    JRadioButton outputBits = new JRadioButton(Bundle.getMessage("ShowOutputButton"), false);
    JLabel nodeInfoText = new JLabel("Node Information Text");
    JLabel nodeDesc = new JLabel("Description:");
    protected JPanel assignmentPanel = null;
    protected Border inputBorder = BorderFactory.createEtchedBorder();
    protected Border inputBorderTitled = BorderFactory.createTitledBorder(this.inputBorder, Bundle.getMessage("AssignmentPanelInputName"));
    protected Border outputBorder = BorderFactory.createEtchedBorder();
    protected Border outputBorderTitled = BorderFactory.createTitledBorder(this.outputBorder, Bundle.getMessage("AssignmentPanelOutputName"));
    protected JTable assignmentTable = null;
    protected TableModel assignmentListModel = null;
    JButton printButton = new JButton(Bundle.getMessage("PrintButtonText"));
    JButton doneButton = new JButton(Bundle.getMessage("DoneButtonText"));
    NodeIOListFrame curFrame;
    private CMRISystemConnectionMemo _memo = null;
    private String[] assignmentTableColumnNames = new String[]{Bundle.getMessage("HeadingBit"), Bundle.getMessage("HeadingAddress"), Bundle.getMessage("HeadingSystemName"), Bundle.getMessage("HeadingUserName"), Bundle.getMessage("HeadingComment")};
    private static final Logger log = LoggerFactory.getLogger(NodeIOListFrame.class);

    public NodeIOListFrame(CMRISystemConnectionMemo memo) {
        this._memo = memo;
        this.curFrame = this;
    }

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("WindowTitle") + Bundle.getMessage("WindowConnectionMemo") + this._memo.getUserName());
        this.setSize(500, 300);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this.initializeNodes();
        if (this.cmriNode.size() > 0) {
            this.inputBits.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (!NodeIOListFrame.this.inputSelected) {
                        NodeIOListFrame.this.inputSelected = true;
                        NodeIOListFrame.this.displayNodeIOBits(NodeIOListFrame.this.selNodeNum);
                    }
                }
            });
            this.outputBits.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (NodeIOListFrame.this.inputSelected) {
                        NodeIOListFrame.this.inputSelected = false;
                        NodeIOListFrame.this.displayNodeIOBits(NodeIOListFrame.this.selNodeNum);
                    }
                }
            });
        } else {
            this.nodeInfoText.setText(Bundle.getMessage("NoNodesError"));
        }
        this.nodeLabel.setToolTipText(Bundle.getMessage("NodeBoxTip"));
        this.inputBits.setToolTipText(Bundle.getMessage("ShowInputTip"));
        this.outputBits.setToolTipText(Bundle.getMessage("ShowOutputTip"));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        JPanel panel11 = new JPanel();
        panel11.add(this.nodeLabel);
        this.bitTypeGroup.add(this.outputBits);
        this.bitTypeGroup.add(this.inputBits);
        panel11.add(this.inputBits);
        panel11.add(this.outputBits);
        JPanel panel12 = new JPanel();
        panel12.add(this.nodeInfoText);
        JPanel panel13 = new JPanel();
        panel13.add(this.nodeDesc);
        panel13.setVisible(true);
        this.nodeDesc.setVisible(false);
        panel1.add(panel13);
        panel1.add(panel11);
        panel1.add(panel12);
        Border panel1Border = BorderFactory.createEtchedBorder();
        TitledBorder panel1Titled = BorderFactory.createTitledBorder(panel1Border, Bundle.getMessage("NodePanelName") + " " + this._memo.getUserName());
        panel1.setBorder(panel1Titled);
        contentPane.add(panel1);
        this.assignmentPanel = new JPanel();
        this.assignmentPanel.setLayout(new BoxLayout(this.assignmentPanel, 1));
        this.assignmentListModel = new AssignmentTableModel();
        this.assignmentTable = new JTable(this.assignmentListModel);
        this.assignmentTable.setRowSelectionAllowed(false);
        this.assignmentTable.setPreferredScrollableViewportSize(new Dimension(300, 350));
        TableColumnModel assignmentColumnModel = this.assignmentTable.getColumnModel();
        TableColumn bitColumn = assignmentColumnModel.getColumn(0);
        bitColumn.setMinWidth(20);
        bitColumn.setMaxWidth(40);
        bitColumn.setResizable(true);
        TableColumn addressColumn = assignmentColumnModel.getColumn(1);
        addressColumn.setMinWidth(40);
        addressColumn.setMaxWidth(85);
        addressColumn.setResizable(true);
        TableColumn sysColumn = assignmentColumnModel.getColumn(2);
        sysColumn.setMinWidth(90);
        sysColumn.setMaxWidth(150);
        sysColumn.setResizable(true);
        TableColumn userColumn = assignmentColumnModel.getColumn(3);
        userColumn.setMinWidth(90);
        userColumn.setMaxWidth(250);
        userColumn.setResizable(true);
        assignmentColumnModel.getColumn(4);
        userColumn.setMinWidth(90);
        userColumn.setMaxWidth(250);
        userColumn.setResizable(true);
        JScrollPane assignmentScrollPane = new JScrollPane(this.assignmentTable);
        this.assignmentPanel.add((Component)assignmentScrollPane, "Center");
        if (this.inputSelected) {
            this.assignmentPanel.setBorder(this.inputBorderTitled);
        } else {
            this.assignmentPanel.setBorder(this.outputBorderTitled);
        }
        contentPane.add(this.assignmentPanel);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new FlowLayout());
        this.printButton.setVisible(true);
        this.printButton.setToolTipText(Bundle.getMessage("PrintButtonTip"));
        if (this.cmriNode.size() > 0) {
            this.printButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NodeIOListFrame.this.printButtonActionPerformed(e);
                }
            });
        }
        panel3.add(this.printButton);
        contentPane.add(panel3);
        this.doneButton.setVisible(true);
        this.doneButton.setToolTipText(Bundle.getMessage("DoneButtonTip"));
        if (this.cmriNode.size() > 0) {
            this.doneButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NodeIOListFrame.this.doneButtonActionPerformed();
                }
            });
        }
        panel3.add(this.doneButton);
        this.addHelpMenu("package.jmri.jmrix.cmri.serial.assignment.ListFrame", true);
        this.pack();
    }

    public void initializeNodes() {
        SerialNode node = (SerialNode)this._memo.getTrafficController().getNode(0);
        int index = 0;
        while (node != null) {
            this.cmriNode.add(node);
            node = (SerialNode)this._memo.getTrafficController().getNode(index);
            ++index;
        }
    }

    public void displayNodeIOBits(int nodeID) {
        this.nodeLabel.setText("Node: " + nodeID + "     ");
        this.selNodeNum = nodeID;
        this.nodeDesc.setText("");
        for (int i = 0; i < this.cmriNode.size(); ++i) {
            if (this.cmriNode.get(i).getNodeAddress() != nodeID) continue;
            this.selNode = this.cmriNode.get(i);
        }
        String nodeType = "";
        int type = this.selNode.getNodeType();
        int bitsPerCard = this.selNode.getNumBitsPerCard();
        int numInputCards = this.selNode.numInputCards();
        int numOutputCards = this.selNode.numOutputCards();
        switch (type) {
            case 1: {
                this.numInputBits = 24;
                this.numOutputBits = 48;
                nodeType = "SMINI - ";
                break;
            }
            case 2: {
                this.numInputBits = bitsPerCard * numInputCards;
                this.numOutputBits = bitsPerCard * numOutputCards;
                nodeType = "USIC_SUSIC - ";
                break;
            }
            case 3: {
                this.numInputBits = bitsPerCard * numInputCards;
                this.numOutputBits = bitsPerCard * numOutputCards;
                nodeType = "CPNODE - ";
                break;
            }
            case 4: {
                this.numInputBits = bitsPerCard * numInputCards;
                this.numOutputBits = bitsPerCard * numOutputCards;
                nodeType = "CPMEGA - ";
                break;
            }
        }
        this.nodeInfoText.setText(nodeType + bitsPerCard + " " + Bundle.getMessage("BitsPerCard") + ", " + this.numInputBits + " " + Bundle.getMessage("InputBitsAnd") + " " + this.numOutputBits + " " + Bundle.getMessage("OutputBits"));
        String name = this.selNode.getcmriNodeDesc();
        if (name != null && !name.isEmpty()) {
            this.nodeDesc.setText(Bundle.getMessage("NodeDesc") + " " + name);
            this.nodeDesc.setVisible(true);
        }
        if (this.inputSelected) {
            this.numBits = this.numInputBits;
            this.assignmentPanel.setBorder(this.inputBorderTitled);
        } else {
            this.numBits = this.numOutputBits;
            this.assignmentPanel.setBorder(this.outputBorderTitled);
        }
        ((AssignmentTableModel)this.assignmentListModel).fireTableDataChanged();
    }

    public void doneButtonActionPerformed() {
        this.setVisible(false);
        this.dispose();
    }

    public void printButtonActionPerformed(ActionEvent e) {
        int[] colWidth = new int[5];
        TableColumnModel assignmentColumnModel = this.assignmentTable.getColumnModel();
        colWidth[0] = assignmentColumnModel.getColumn(0).getWidth();
        colWidth[1] = assignmentColumnModel.getColumn(1).getWidth();
        colWidth[2] = assignmentColumnModel.getColumn(2).getWidth();
        colWidth[3] = assignmentColumnModel.getColumn(3).getWidth();
        colWidth[4] = assignmentColumnModel.getColumn(4).getWidth();
        String head = this.inputSelected ? Bundle.getMessage("Connection") + " " + this._memo.getUserName() + "  " + Bundle.getMessage("AssignmentPanelInputName") + " " + Bundle.getMessage("NodeBoxLabel") + " " + this.selNodeNum + "  " : Bundle.getMessage("Connection") + " " + this._memo.getUserName() + "  " + Bundle.getMessage("AssignmentPanelOutputName") + " " + Bundle.getMessage("NodeBoxLabel") + " " + this.selNodeNum + "  ";
        HardcopyWriter writer = null;
        try {
            writer = new HardcopyWriter(this.curFrame, head, 10, 0.8, 0.5, 0.5, 0.5, false);
        }
        catch (HardcopyWriter.PrintCanceledException ex) {
            return;
        }
        writer.increaseLineSpacing(20);
        ((AssignmentTableModel)this.assignmentListModel).printTable(writer, colWidth);
    }

    public class AssignmentTableModel
    extends AbstractTableModel {
        private String free = Bundle.getMessage("AssignmentFree");
        private int curRow = -1;
        private String curRowSysName = "";
        public static final int BIT_COLUMN = 0;
        public static final int ADDRESS_COLUMN = 1;
        public static final int SYSNAME_COLUMN = 2;
        public static final int USERNAME_COLUMN = 3;
        public static final int COMMENT_COLUMN = 4;
        public static final int MAX_COLS = 5;

        @Override
        public String getColumnName(int c) {
            return NodeIOListFrame.this.assignmentTableColumnNames[c];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return NodeIOListFrame.this.numBits;
        }

        @Override
        public Object getValueAt(int r, int c) {
            if (c == 0) {
                return Integer.toString(r + 1);
            }
            if (c == 1) {
                return Integer.toString(NodeIOListFrame.this.selNodeNum * 1000 + r + 1);
            }
            if (c == 2) {
                String sName = null;
                if (this.curRow != r) {
                    sName = NodeIOListFrame.this.inputSelected ? NodeIOListFrame.this._memo.isInputBitFree(NodeIOListFrame.this.selNodeNum, r + 1) : NodeIOListFrame.this._memo.isOutputBitFree(NodeIOListFrame.this.selNodeNum, r + 1);
                    this.curRow = r;
                    this.curRowSysName = sName;
                } else {
                    sName = this.curRowSysName;
                }
                if (sName == null) {
                    return this.free;
                }
                return sName;
            }
            if (c == 3) {
                String sName = null;
                if (this.curRow != r) {
                    sName = NodeIOListFrame.this.inputSelected ? NodeIOListFrame.this._memo.isInputBitFree(NodeIOListFrame.this.selNodeNum, r + 1) : NodeIOListFrame.this._memo.isOutputBitFree(NodeIOListFrame.this.selNodeNum, r + 1);
                    this.curRow = r;
                    this.curRowSysName = sName;
                } else {
                    sName = this.curRowSysName;
                }
                if (sName == null) {
                    return "";
                }
                return NodeIOListFrame.this._memo.getUserNameFromSystemName(sName);
            }
            if (c == 4) {
                String sName = null;
                if (this.curRow != r) {
                    sName = NodeIOListFrame.this.inputSelected ? NodeIOListFrame.this._memo.isInputBitFree(NodeIOListFrame.this.selNodeNum, r + 1) : NodeIOListFrame.this._memo.isOutputBitFree(NodeIOListFrame.this.selNodeNum, r + 1);
                    this.curRow = r;
                    this.curRowSysName = sName;
                } else {
                    sName = this.curRowSysName;
                }
                if (sName == null) {
                    return "";
                }
                if (NodeIOListFrame.this.inputSelected) {
                    Sensor s = null;
                    s = InstanceManager.sensorManagerInstance().getBySystemName(sName);
                    if (s != null) {
                        return s.getComment();
                    }
                } else {
                    Turnout t = null;
                    t = InstanceManager.turnoutManagerInstance().getBySystemName(sName);
                    if (t != null) {
                        return t.getComment();
                    }
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
        }

        public void printTable(HardcopyWriter w, int[] colWidth) {
            int[] columnSize = new int[5];
            int charPerLine = w.getCharactersPerLine();
            int tableLineWidth = 0;
            int totalColWidth = 0;
            for (int j = 0; j < 5; ++j) {
                totalColWidth += colWidth[j];
            }
            float ratio = (float)charPerLine / (float)totalColWidth;
            for (int j = 0; j < 5; ++j) {
                columnSize[j] = (int)((float)colWidth[j] * ratio) - 1;
                tableLineWidth += columnSize[j] + 1;
            }
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), tableLineWidth);
            String[] columnStrings = new String[5];
            for (int i = 0; i < 5; ++i) {
                columnStrings[i] = this.getColumnName(i);
            }
            this.printColumns(w, columnStrings, columnSize);
            w.setFontStyle(0);
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), tableLineWidth);
            String[] spaces = new String[5];
            for (int k = 0; k < 5; ++k) {
                spaces[k] = "";
                for (int i = 0; i < columnSize[k]; ++i) {
                    spaces[k] = spaces[k] + " ";
                }
            }
            for (int i = 0; i < this.getRowCount(); ++i) {
                for (int j = 0; j < 5; ++j) {
                    columnStrings[j] = this.getValueAt(i, j) == null ? spaces[j] : (String)this.getValueAt(i, j);
                }
                this.printColumns(w, columnStrings, columnSize);
                w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), tableLineWidth);
            }
            w.close();
        }

        protected void printColumns(HardcopyWriter w, String[] columnStrings, int[] columnSize) {
            Object columnString = "";
            StringBuilder lineString = new StringBuilder("");
            String[] spaces = new String[5];
            for (int k = 0; k < 5; ++k) {
                spaces[k] = "";
                for (int i = 0; i < columnSize[k]; ++i) {
                    spaces[k] = spaces[k] + " ";
                }
            }
            boolean complete = false;
            while (!complete) {
                int k;
                complete = true;
                for (int i = 0; i < 5; ++i) {
                    if (columnStrings[i].length() > columnSize[i]) {
                        boolean noWord = true;
                        for (k = columnSize[i]; k >= 1; --k) {
                            if (!columnStrings[i].substring(k - 1, k).equals(" ") && !columnStrings[i].substring(k - 1, k).equals("-") && !columnStrings[i].substring(k - 1, k).equals("_")) continue;
                            columnString = columnStrings[i].substring(0, k) + spaces[i].substring(columnStrings[i].substring(0, k).length());
                            columnStrings[i] = columnStrings[i].substring(k);
                            noWord = false;
                            complete = false;
                            break;
                        }
                        if (noWord) {
                            columnString = columnStrings[i].substring(0, columnSize[i]);
                            columnStrings[i] = columnStrings[i].substring(columnSize[i]);
                            complete = false;
                        }
                    } else {
                        columnString = columnStrings[i] + spaces[i].substring(columnStrings[i].length());
                        columnStrings[i] = "";
                    }
                    lineString.append((String)columnString).append(" ");
                }
                try {
                    w.write(lineString.toString());
                    int iLine = w.getCurrentLineNumber();
                    int i = 0;
                    k = 0;
                    while (i < w.getCharactersPerLine()) {
                        w.write(iLine, i, iLine + 1, i);
                        i = k < 5 ? i + columnSize[k] + 1 : w.getCharactersPerLine();
                        ++k;
                    }
                    w.write("\n");
                    lineString = new StringBuilder("");
                }
                catch (IOException e) {
                    log.warn("error during printing", (Throwable)e);
                }
            }
        }
    }
}

