/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial.serialdriver;

import java.util.Arrays;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.SerialPortAdapter;
import jmri.jmrix.cmri.serial.SerialTrafficController;
import jmri.jmrix.cmri.serial.serialdriver.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDriverAdapter
extends SerialPortAdapter {
    protected String[] validSpeeds = new String[]{Bundle.getMessage("Baud9600"), Bundle.getMessage("Baud19200"), Bundle.getMessage("Baud28800"), Bundle.getMessage("Baud57600"), Bundle.getMessage("Baud115200")};
    protected int[] validSpeedValues = new int[]{9600, 19200, 28800, 57600, 115200};
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    public SerialDriverAdapter() {
        super(new CMRISystemConnectionMemo());
        this.manufacturerName = "C/MRI";
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log, 2);
        if (this.currentSerialPort == null) {
            log.error("failed to connect C/MRI to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting C/MRI to {} {}", (Object)portName, (Object)this.currentSerialPort);
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.NONE);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    public boolean okToSend() {
        return true;
    }

    @Override
    public void configure() {
        SerialTrafficController tc = new SerialTrafficController();
        tc.connectPort(this);
        ((CMRISystemConnectionMemo)this.getSystemConnectionMemo()).setTrafficController(tc);
        ((CMRISystemConnectionMemo)this.getSystemConnectionMemo()).configureManagers();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 1;
    }
}

