/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial.serialmon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.SerialNode;
import jmri.jmrix.cmri.serial.SerialTrafficController;
import jmri.jmrix.cmri.serial.serialmon.Bundle;
import jmri.util.JmriJFrame;

public class SerialFilterFrame
extends JmriJFrame {
    ArrayList<SerialNode> monitorNode = new ArrayList();
    protected JPanel nodeEnablePanel = null;
    protected Border nodeEableBorder = BorderFactory.createEtchedBorder();
    protected Border nodeEableBorderTitled = BorderFactory.createTitledBorder(this.nodeEableBorder, "Monitor Nodes", 1, 1);
    protected Border packetTypesBorder = BorderFactory.createEtchedBorder();
    protected Border packetTypesBorderTitled = BorderFactory.createTitledBorder(this.packetTypesBorder, "Packet Types", 1, 1);
    protected Border enabledBorder = BorderFactory.createEtchedBorder();
    protected Border enabledBorderTitled = BorderFactory.createTitledBorder(this.enabledBorder, "Select Nodes", 1, 1);
    protected Border packetSelectBorder = BorderFactory.createEtchedBorder();
    protected Border packetSelectBorderTitled = BorderFactory.createTitledBorder(this.packetSelectBorder, "Select Packets", 1, 1);
    protected Border mainButtonsBorder = BorderFactory.createEtchedBorder();
    protected Border mainButtonsBorderTitled = BorderFactory.createTitledBorder(this.mainButtonsBorder, "");
    protected JTable nodeTable = null;
    protected TableModel nodeTableModel = null;
    JButton doneButton = new JButton(Bundle.getMessage("DoneButtonText"));
    JButton haltPollButton = new JButton(Bundle.getMessage("HaltPollButtonText"));
    JButton nodeMonitorAll = new JButton(Bundle.getMessage("AllButtonText"));
    JButton nodeMonitorNone = new JButton(Bundle.getMessage("NoneButtonText"));
    JButton packetMonitorAll = new JButton(Bundle.getMessage("AllButtonText"));
    JButton packetMonitorNone = new JButton(Bundle.getMessage("NoneButtonText"));
    public static final int monPktInit = 0;
    public static final int monPktPoll = 1;
    public static final int monPktRead = 2;
    public static final int monPktTransmit = 3;
    public static final int monPktEOT = 4;
    public static final int monPktQuery = 5;
    public static final int monPktDGread = 6;
    public static final int monPktDGwrite = 7;
    public static final int monPktDGack = 8;
    public static final int monPktCodeline = 9;
    public static final int monPktNMRAmast = 10;
    public static final int monPktRFE = 11;
    public static final int numMonPkts = 11;
    public static final int lastStdPkt = 4;
    ArrayList<JCheckBox> packetChkBoxes = new ArrayList();
    String[] packetChkBoxLabels = new String[]{"(I) Initialize    ", "(P) Poll          ", "(R) Read          ", "(T) Transmit      ", "(E) EOT           ", "(Q) Query         ", "(D) Datagram Read ", "(W) Datagram Write", "(A) Datagram Ack  ", "(C) Code Line     ", "(M) NMRA Mast     ", "RFE               "};
    protected JPanel packetTypes = new JPanel();
    HandlerClass packetTypeCkBoxHandler = new HandlerClass();
    private CMRISystemConnectionMemo _memo = null;
    private final String[] nodeEnableColumnsNames = new String[]{"Node", "Monitor"};

    public SerialFilterFrame(CMRISystemConnectionMemo memo) {
        super("CMRInet Packet Filter");
        this._memo = memo;
    }

    @Override
    public void initComponents() {
        this.initializeNodes();
        this.setLayout(new FlowLayout(0));
        this.setPreferredSize(new Dimension(620, 375));
        this.nodeEnablePanel = new JPanel();
        this.nodeEnablePanel.setLayout(new FlowLayout(0));
        this.nodeEnablePanel.setLayout(new BoxLayout(this.nodeEnablePanel, 2));
        this.nodeEnablePanel.setBorder(this.nodeEableBorderTitled);
        this.nodeEnablePanel.setBackground(Color.WHITE);
        this.nodeTableModel = new NodeTableModel();
        this.nodeTable = new JTable(this.nodeTableModel);
        this.nodeTable.setPreferredScrollableViewportSize(new Dimension(200, 90));
        this.nodeTable.setFillsViewportHeight(true);
        this.nodeTable.setShowGrid(true);
        this.nodeTable.setGridColor(Color.WHITE);
        this.nodeTable.setBackground(Color.WHITE);
        this.nodeTable.setRowSelectionAllowed(false);
        this.nodeTable.setFont(new Font("Lucida Grande", 0, 13));
        this.nodeTable.setRowHeight(30);
        this.nodeTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane nodeTableScrollPane = new JScrollPane(this.nodeTable);
        this.nodeEnablePanel.add((Component)nodeTableScrollPane, "Before");
        this.nodeEnablePanel.setBorder(this.nodeEableBorderTitled);
        TableColumnModel nodeEableColumnModel = this.nodeTable.getColumnModel();
        DefaultTableCellRenderer dtcen = new DefaultTableCellRenderer();
        dtcen.setHorizontalAlignment(0);
        DefaultTableCellRenderer dtlft = new DefaultTableCellRenderer();
        dtlft.setHorizontalAlignment(2);
        TableCellRenderer rendererFromHeader = this.nodeTable.getTableHeader().getDefaultRenderer();
        JLabel headerLabel = (JLabel)((Object)rendererFromHeader);
        headerLabel.setHorizontalAlignment(0);
        TableColumn nodeaddrColumn = nodeEableColumnModel.getColumn(0);
        nodeaddrColumn.setCellRenderer(dtcen);
        nodeaddrColumn.setResizable(false);
        TableColumn enabledColumn = nodeEableColumnModel.getColumn(1);
        enabledColumn.setResizable(false);
        this.nodeEnablePanel.setBorder(this.nodeEableBorderTitled);
        this.nodeEnablePanel.setBackground(Color.WHITE);
        this.nodeEnablePanel.setPreferredSize(new Dimension(200, 200));
        this.nodeTable.setAutoCreateRowSorter(true);
        this.nodeTable.getRowSorter().toggleSortOrder(0);
        this.nodeEnablePanel.setVisible(true);
        this.add(this.nodeEnablePanel);
        JPanel packetSelectTypes = new JPanel();
        packetSelectTypes.setLayout(new GridLayout(0, 2));
        packetSelectTypes.setPreferredSize(new Dimension(400, 200));
        packetSelectTypes.setBorder(this.packetTypesBorderTitled);
        packetSelectTypes.setBackground(Color.WHITE);
        for (int i = 0; i < 11; ++i) {
            JCheckBox ckbox = new JCheckBox(this.packetChkBoxLabels[i]);
            this.packetChkBoxes.add(ckbox);
            this.packetChkBoxes.get(i).addItemListener(this.packetTypeCkBoxHandler);
            this.packetChkBoxes.get(i).setVisible(false);
            this.packetChkBoxes.get(i).setEnabled(false);
            this.packetChkBoxes.get(i).setSelected(false);
            if (i < 4) {
                this.packetChkBoxes.get(i).setVisible(true);
                this.packetChkBoxes.get(i).setEnabled(true);
                this.packetChkBoxes.get(i).setSelected(true);
            }
            packetSelectTypes.add(ckbox);
        }
        packetSelectTypes.setVisible(true);
        this.add(packetSelectTypes);
        JPanel enableSelectButtons = new JPanel();
        enableSelectButtons.setLayout(new FlowLayout(1));
        enableSelectButtons.setPreferredSize(new Dimension(200, 60));
        enableSelectButtons.setBackground(Color.WHITE);
        enableSelectButtons.setBorder(this.enabledBorderTitled);
        enableSelectButtons.add(this.nodeMonitorAll);
        this.nodeMonitorAll.setVisible(true);
        this.nodeMonitorAll.setToolTipText(Bundle.getMessage("AllButtonTip"));
        this.nodeMonitorAll.addActionListener(this::nodeMonitorAllButtonActionPerformed);
        enableSelectButtons.add(this.nodeMonitorNone);
        this.nodeMonitorNone.setVisible(true);
        this.nodeMonitorNone.setToolTipText(Bundle.getMessage("NoneButtonTip"));
        this.nodeMonitorNone.addActionListener(this::nodeMonitorNoneButtonActionPerformed);
        this.add(enableSelectButtons);
        JPanel packetSelectButtons = new JPanel();
        packetSelectButtons.setLayout(new FlowLayout(0));
        packetSelectButtons.setPreferredSize(new Dimension(400, 60));
        packetSelectButtons.setBackground(Color.WHITE);
        packetSelectButtons.setBorder(this.packetSelectBorderTitled);
        packetSelectButtons.add(this.packetMonitorAll);
        this.packetMonitorAll.setVisible(true);
        this.packetMonitorAll.setToolTipText(Bundle.getMessage("AllButtonTip"));
        this.packetMonitorAll.addActionListener(this::packetMonitorAllButtonActionPerformed);
        packetSelectButtons.add(this.packetMonitorNone);
        this.packetMonitorNone.setVisible(true);
        this.packetMonitorNone.setToolTipText(Bundle.getMessage("NoneButtonTip"));
        this.packetMonitorNone.addActionListener(this::packetMonitorNoneButtonActionPerformed);
        this.add(packetSelectButtons);
        JPanel mainButtons = new JPanel();
        mainButtons.setLayout(new FlowLayout(2));
        mainButtons.setPreferredSize(new Dimension(600, 60));
        this.haltPollButton.setVisible(true);
        this.haltPollButton.setToolTipText(Bundle.getMessage("HaltPollButtonTip"));
        this.haltPollButton.addActionListener(this::haltpollButtonActionPerformed);
        mainButtons.add(this.haltPollButton);
        mainButtons.add(Box.createRigidArea(new Dimension(30, 0)));
        this.doneButton.setVisible(true);
        this.doneButton.setToolTipText(Bundle.getMessage("DoneButtonTip"));
        this.doneButton.addActionListener(this::doneButtonActionPerformed);
        mainButtons.add(this.doneButton);
        mainButtons.setVisible(true);
        this.add(mainButtons);
        this.addHelpMenu("package.jmri.jmrix.cmri.serial.serialmon.SerialFilterFrame", true);
        this.pack();
    }

    public void initializeNodes() {
        SerialNode node = (SerialNode)this._memo.getTrafficController().getNode(0);
        int index = 1;
        while (node != null) {
            this.monitorNode.add(node);
            node = (SerialNode)this._memo.getTrafficController().getNode(index);
            ++index;
        }
    }

    public void nodeMonitorAllButtonActionPerformed(ActionEvent e) {
        for (int i = 0; i < this.monitorNode.size(); ++i) {
            this.monitorNode.get(i).setMonitorNodePackets(false);
            this.nodeTableModel.setValueAt(this.monitorNode.get(i).getMonitorNodePackets(), i, 1);
        }
    }

    public void nodeMonitorNoneButtonActionPerformed(ActionEvent e) {
        for (int i = 0; i < this.monitorNode.size(); ++i) {
            this.monitorNode.get(i).setMonitorNodePackets(true);
            this.nodeTableModel.setValueAt(this.monitorNode.get(i).getMonitorNodePackets(), i, 1);
        }
    }

    public void packetMonitorAllButtonActionPerformed(ActionEvent e) {
        for (int i = 0; i < 4; ++i) {
            this.packetChkBoxes.get(i).setSelected(true);
        }
    }

    public void packetMonitorNoneButtonActionPerformed(ActionEvent e) {
        for (int i = 0; i < 4; ++i) {
            this.packetChkBoxes.get(i).setSelected(false);
        }
    }

    public void doneButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public void haltpollButtonActionPerformed(ActionEvent e) {
        SerialTrafficController stc;
        stc.setPollNetwork(!(stc = this._memo.getTrafficController()).getPollNetwork());
        if (stc.getPollNetwork()) {
            this.haltPollButton.setText(Bundle.getMessage("HaltPollingText"));
        } else {
            this.haltPollButton.setText(Bundle.getMessage("StartPollingText"));
        }
    }

    public class NodeTableModel
    extends AbstractTableModel {
        public static final int NODEADDR_COLUMN = 0;
        public static final int ENABLED_COLUMN = 1;
        public static final int NUMCOLUMNS = 2;

        @Override
        public String getColumnName(int c) {
            return SerialFilterFrame.this.nodeEnableColumnsNames[c];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return Integer.class;
                }
            }
            return Boolean.class;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c != 0;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SerialFilterFrame.this.monitorNode.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            switch (c) {
                case 0: {
                    return SerialFilterFrame.this.monitorNode.get(r).getNodeAddress();
                }
                case 1: {
                    return SerialFilterFrame.this.monitorNode.get(r).getMonitorNodePackets();
                }
            }
            return true;
        }

        @Override
        public void setValueAt(Object value, int r, int c) {
            if (c == 0) {
                SerialFilterFrame.this.monitorNode.get(r).setPollListPosition((Integer)value);
            } else if (c == 1) {
                SerialFilterFrame.this.monitorNode.get(r).setMonitorNodePackets(!SerialFilterFrame.this.monitorNode.get(r).getMonitorNodePackets());
            }
            this.fireTableDataChanged();
        }
    }

    private class HandlerClass
    implements ItemListener {
        private HandlerClass() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JCheckBox pktTypeChkBox = (JCheckBox)e.getSource();
            int pktTypeIndex = 0;
            do {
                if (pktTypeChkBox != SerialFilterFrame.this.packetChkBoxes.get(pktTypeIndex)) continue;
                for (int i = 0; i < SerialFilterFrame.this.monitorNode.size(); ++i) {
                    SerialNode aNode = SerialFilterFrame.this.monitorNode.get(i);
                    if (aNode == null) continue;
                    aNode.setMonitorPacketBit(pktTypeIndex, SerialFilterFrame.this.packetChkBoxes.get(pktTypeIndex).isSelected());
                }
                return;
            } while (++pktTypeIndex < 11);
        }
    }
}

