/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.cmri.serial.serialmon;

import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import jmri.jmrix.AbstractMonFrame;
import jmri.jmrix.cmri.CMRISystemConnectionMemo;
import jmri.jmrix.cmri.serial.SerialListener;
import jmri.jmrix.cmri.serial.SerialMessage;
import jmri.jmrix.cmri.serial.SerialNode;
import jmri.jmrix.cmri.serial.SerialReply;
import jmri.jmrix.cmri.serial.serialmon.Bundle;
import jmri.jmrix.cmri.serial.serialmon.SerialFilterFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialMonFrame
extends AbstractMonFrame
implements SerialListener {
    protected JButton packetfilterButton = new JButton(Bundle.getMessage("FilterPacketsText"));
    protected static int _DLE = 16;
    private CMRISystemConnectionMemo _memo = null;
    private static final Logger log = LoggerFactory.getLogger(SerialMonFrame.class);

    public SerialMonFrame(CMRISystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected String title() {
        return Bundle.getMessage("SerialCommandMonTitle") + " " + Bundle.getMessage("Connection") + this._memo.getUserName();
    }

    @Override
    protected void init() {
        this._memo.getTrafficController().addSerialListener(this);
        this.initializePacketFilters();
        JPanel paneA = new JPanel();
        paneA.setLayout(new BoxLayout(paneA, 1));
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 0));
        this.packetfilterButton.setText(Bundle.getMessage("FilterPacketsText"));
        this.packetfilterButton.setVisible(true);
        this.packetfilterButton.setToolTipText(Bundle.getMessage("FilterPacketTip"));
        pane1.add(this.packetfilterButton);
        this.packetfilterButton.addActionListener(this::openPacketFilterPerformed);
        paneA.add(pane1);
        this.getContentPane().add(paneA);
        this.pack();
        paneA.setMaximumSize(paneA.getSize());
        this.pack();
        this.getContentPane().setComponentZOrder(paneA, 1);
    }

    @Override
    protected void setHelp() {
        this.addHelpMenu("package.jmri.jmrix.cmri.serial.serialmon.SerialMonFrame", true);
    }

    public void initializePacketFilters() {
        SerialNode node = (SerialNode)this._memo.getTrafficController().getNode(0);
        int index = 1;
        int pktTypeIndex = 0;
        while (node != null) {
            do {
                node.setMonitorPacketBit(pktTypeIndex, true);
            } while (++pktTypeIndex < 11);
            node = (SerialNode)this._memo.getTrafficController().getNode(index);
            ++index;
            pktTypeIndex = 0;
        }
    }

    public void openPacketFilterPerformed(ActionEvent e) {
        SerialFilterFrame f = new SerialFilterFrame(this._memo);
        try {
            f.initComponents();
        }
        catch (Exception ex) {
            log.warn("SerialMonFrame starting SerialFilterFrame: Exception: {}", (Object)ex.toString());
        }
        f.setVisible(true);
    }

    @Override
    public synchronized void message(SerialMessage l) {
        SerialNode monitorNode = (SerialNode)this._memo.getTrafficController().getNodeFromAddress(l.getUA());
        if (monitorNode == null) {
            return;
        }
        if (!monitorNode.getMonitorNodePackets()) {
            return;
        }
        int aPacketTypeID = l.getElement(1);
        if (l.getNumDataElements() < 2) {
            this.nextLine("Truncated message of length " + l.getNumDataElements() + "\n", l.toString());
            return;
        }
        switch (aPacketTypeID) {
            case 80: {
                if (!monitorNode.getMonitorPacketBit(1)) break;
                this.nextLine("Poll ua=" + l.getUA() + "\n", l.toString());
                break;
            }
            case 84: {
                if (!monitorNode.getMonitorPacketBit(3)) break;
                StringBuilder sb = new StringBuilder("Transmit ua=");
                sb.append(l.getUA());
                sb.append(" OB=");
                for (int i = 2; i < l.getNumDataElements(); ++i) {
                    if (this.rawCheckBox.isSelected() && l.getElement(i) == _DLE) {
                        sb.append("<dle>");
                        ++i;
                    }
                    sb.append(Integer.toHexString(l.getElement(i) & 0xFF).toUpperCase());
                    sb.append(" ");
                }
                sb.append("\n");
                this.nextLine(new String(sb), l.toString());
                break;
            }
            case 73: {
                if (!monitorNode.getMonitorPacketBit(0)) break;
                StringBuilder sb = new StringBuilder("Init ua=");
                sb.append(l.getUA());
                sb.append(" type=");
                int ndp = l.getElement(2);
                sb.append((char)ndp);
                int len = l.getNumDataElements();
                switch (ndp) {
                    case 77: 
                    case 78: 
                    case 88: {
                        if (len >= 5) {
                            sb.append(" DL=");
                            sb.append(l.getElement(3) * 256 + l.getElement(4));
                        }
                        if (len < 6) break;
                        sb.append(" NS=");
                        sb.append(l.getElement(5));
                        sb.append(" CT: ");
                        for (int i = 6; i < l.getNumDataElements(); ++i) {
                            sb.append(Integer.toHexString(l.getElement(i) & 0xFF).toUpperCase());
                            sb.append(" ");
                        }
                        break;
                    }
                    case 67: 
                    case 79: {
                        if (len >= 5) {
                            sb.append(" DL=");
                            sb.append(l.getElement(3) * 256 + l.getElement(4));
                        }
                        sb.append(" Opts=");
                        for (int i = 5; i < l.getNumDataElements(); ++i) {
                            if (l.getElement(i) == _DLE) continue;
                            sb.append(Integer.toHexString(l.getElement(i) & 0xFF).toUpperCase());
                            sb.append(" ");
                        }
                        break;
                    }
                    default: {
                        sb.append("Unrecognized node type NDP: [").append(ndp).append("] ");
                    }
                }
                sb.append("\n");
                this.nextLine(new String(sb), l.toString());
                break;
            }
            default: {
                this.nextLine("Unrecognized cmd: \"" + l.toString() + "\"\n", "");
            }
        }
    }

    @Override
    public synchronized void reply(SerialReply l) {
        SerialNode monitorNode = (SerialNode)this._memo.getTrafficController().getNodeFromAddress(l.getUA());
        if (monitorNode == null) {
            return;
        }
        if (!monitorNode.getMonitorNodePackets()) {
            return;
        }
        int aPacketTypeID = l.getElement(1);
        if (l.getNumDataElements() < 2) {
            this.nextLine("Truncated reply of length " + l.getNumDataElements() + "\n", l.toString());
            return;
        }
        switch (aPacketTypeID) {
            case 82: {
                if (!monitorNode.getMonitorPacketBit(2)) break;
                StringBuilder sb = new StringBuilder("Receive ua=");
                sb.append(l.getUA());
                sb.append(" IB=");
                for (int i = 2; i < l.getNumDataElements(); ++i) {
                    if (this.rawCheckBox.isSelected() && l.getElement(i) == _DLE) {
                        sb.append("<dle>");
                        ++i;
                    }
                    sb.append(Integer.toHexString(l.getElement(i) & 0xFF).toUpperCase());
                    sb.append(" ");
                }
                sb.append("\n");
                this.nextLine(new String(sb), l.toString());
                break;
            }
            case 69: {
                if (!monitorNode.getMonitorPacketBit(4)) break;
                StringBuilder sb = new StringBuilder("Receive ua=");
                sb.append(l.getUA());
                sb.append(" eot");
                sb.append("\n");
                this.nextLine(new String(sb), l.toString());
                break;
            }
            default: {
                this.nextLine("Unrecognized response: \"" + l.toString() + "\"\n", "");
            }
        }
    }
}

