/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.configurexml;

import java.util.List;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.PortAdapter;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class AbstractConnectionConfigXml
extends AbstractXmlAdapter {
    protected abstract void getInstance();

    protected abstract void register();

    protected void register(ConnectionConfig c) {
        c.register();
    }

    @Override
    public Element store(Object o, boolean shared) {
        return this.store(o);
    }

    protected void storeCommon(Element e, PortAdapter adapter) {
        if (adapter.getSystemConnectionMemo() != null) {
            e.setAttribute("userName", adapter.getSystemConnectionMemo().getUserName());
            e.setAttribute("systemPrefix", adapter.getSystemConnectionMemo().getSystemPrefix());
        }
        if (adapter.getManufacturer() != null) {
            e.setAttribute("manufacturer", adapter.getManufacturer());
        }
        if (adapter.getDisabled()) {
            e.setAttribute("disabled", "yes");
        } else {
            e.setAttribute("disabled", "no");
        }
        e.setAttribute("reconnectMaxInterval", String.valueOf(adapter.getReconnectMaxInterval()));
        e.setAttribute("reconnectMaxAttempts", String.valueOf(adapter.getReconnectMaxAttempts()));
        this.saveOptions(e, adapter);
    }

    protected void extendElement(Element e) {
    }

    protected void loadCommon(Element shared, Element perNode, PortAdapter adapter) {
        String reconnectA;
        String reconnectI;
        String yesno;
        if (perNode.getAttribute("option1") != null) {
            String option1Setting = perNode.getAttribute("option1").getValue();
            adapter.configureOption1(option1Setting);
        }
        if (perNode.getAttribute("option2") != null) {
            String option2Setting = perNode.getAttribute("option2").getValue();
            adapter.configureOption2(option2Setting);
        }
        if (perNode.getAttribute("option3") != null) {
            String option3Setting = perNode.getAttribute("option3").getValue();
            adapter.configureOption3(option3Setting);
        }
        if (perNode.getAttribute("option4") != null) {
            String option4Setting = perNode.getAttribute("option4").getValue();
            adapter.configureOption4(option4Setting);
        }
        this.loadOptions(perNode.getChild("options"), perNode.getChild("options"), adapter);
        try {
            adapter.setManufacturer(perNode.getAttribute("manufacturer").getValue());
        }
        catch (NullPointerException option4Setting) {
            // empty catch block
        }
        if (adapter.getSystemConnectionMemo() != null) {
            if (shared.getAttribute("userName") != null) {
                adapter.getSystemConnectionMemo().setUserName(shared.getAttribute("userName").getValue());
            }
            if (shared.getAttribute("systemPrefix") != null) {
                adapter.getSystemConnectionMemo().setSystemPrefix(shared.getAttribute("systemPrefix").getValue());
            }
        }
        if (shared.getAttribute("disabled") != null && (yesno = shared.getAttribute("disabled").getValue()) != null && !yesno.isEmpty()) {
            if (yesno.equals("no")) {
                adapter.setDisabled(false);
            } else if (yesno.equals("yes")) {
                adapter.setDisabled(true);
            }
        }
        if (shared.getAttribute("reconnectMaxInterval") != null && (reconnectI = shared.getAttribute("reconnectMaxInterval").getValue()) != null && !reconnectI.isEmpty()) {
            adapter.setReconnectMaxInterval(Integer.parseInt(reconnectI));
        }
        if (shared.getAttribute("reconnectMaxAttempts") != null && (reconnectA = shared.getAttribute("reconnectMaxAttempts").getValue()) != null && !reconnectA.isEmpty()) {
            adapter.setReconnectMaxAttempts(Integer.parseInt(reconnectA));
        }
    }

    protected void saveOptions(Element e, PortAdapter adapter) {
        String[] options;
        Element element = new Element("options");
        for (String i : options = adapter.getOptions()) {
            Element elem = new Element("option");
            elem.addContent((Content)new Element("name").addContent(i));
            elem.addContent((Content)new Element("value").addContent(adapter.getOptionState(i)));
            element.addContent((Content)elem);
        }
        e.addContent((Content)element);
    }

    protected void loadOptions(Element shared, Element perNode, PortAdapter adapter) {
        if (perNode == null) {
            return;
        }
        List optionList = perNode.getChildren("option");
        for (Element so : optionList) {
            adapter.setOptionState(so.getChild("name").getText(), so.getChild("value").getText());
        }
    }

    protected void unpackElement(Element shared, Element perNode) {
    }

    protected String findParmValue(Element e, String name) {
        List l = e.getChildren("parameter");
        for (Element n : l) {
            if (!n.getAttributeValue("name").equals(name)) continue;
            return n.getTextTrim();
        }
        return null;
    }

    protected void setOutputInterval(PortAdapter adapter, Element e) {
        if (adapter.getSystemConnectionMemo().getOutputInterval() > 0) {
            e.setAttribute("turnoutInterval", String.valueOf(adapter.getSystemConnectionMemo().getOutputInterval()));
        } else {
            e.setAttribute("turnoutInterval", "0");
        }
    }

    protected abstract void dispose();
}

