/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.configurexml;

import jmri.jmrix.SerialPortAdapter;
import jmri.jmrix.configurexml.AbstractConnectionConfigXml;
import jmri.jmrix.configurexml.Bundle;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerialConnectionConfigXml
extends AbstractConnectionConfigXml {
    protected SerialPortAdapter adapter;
    private static final Logger log = LoggerFactory.getLogger(AbstractSerialConnectionConfigXml.class);

    protected void getInstance(Object object) {
        this.getInstance();
    }

    @Override
    public Element store(Object object) {
        this.getInstance(object);
        Element e = new Element("connection");
        if (this.adapter == null) {
            log.warn("No adapter found while saving serial port configuration {}", (Object)object.toString());
            return null;
        }
        this.storeCommon(e, this.adapter);
        if (this.adapter.getCurrentPortName() != null) {
            e.setAttribute("port", this.adapter.getCurrentPortName());
        } else {
            e.setAttribute("port", Bundle.getMessage("noneSelected"));
        }
        if (this.adapter.getCurrentBaudRate() != null) {
            e.setAttribute("speed", this.adapter.getCurrentBaudNumber());
        } else {
            e.setAttribute("speed", Bundle.getMessage("noneSelected"));
        }
        this.setOutputInterval(this.adapter, e);
        e.setAttribute("class", this.getClass().getName());
        this.extendElement(e);
        return e;
    }

    @Override
    protected void extendElement(Element e) {
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        boolean result = true;
        this.getInstance();
        log.info("Starting to connect for \"{}\"", (Object)(this.adapter.getSystemConnectionMemo() != null ? this.adapter.getSystemConnectionMemo().getUserName() : "(Unknown Connection)"));
        String portName = perNode.getAttribute("port").getValue();
        this.adapter.setPort(portName);
        String baudNumber = perNode.getAttribute("speed").getValue();
        this.adapter.configureBaudRateFromNumber(baudNumber);
        this.loadCommon(shared, perNode, this.adapter);
        this.register();
        if (this.adapter.getDisabled()) {
            this.unpackElement(shared, perNode);
            return result;
        }
        String status = this.adapter.openPort(portName, "JMRI app");
        if (status != null) {
            this.handleException(status, "opening connection", null, null, null);
            log.debug("load failed");
            return false;
        }
        this.adapter.configure();
        if (perNode.getAttribute("turnoutInterval") != null) {
            this.adapter.getSystemConnectionMemo().setOutputInterval(Integer.parseInt(perNode.getAttribute("turnoutInterval").getValue()));
        }
        this.unpackElement(shared, perNode);
        return result;
    }

    @Override
    public void load(Element element, Object o) {
        log.error("method with two args invoked");
    }

    @Override
    protected void dispose() {
        if (this.adapter != null) {
            this.adapter.dispose();
        }
    }
}

