/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.configurexml;

import jmri.jmrix.AbstractStreamPortController;
import jmri.jmrix.configurexml.AbstractConnectionConfigXml;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamConnectionConfigXml
extends AbstractConnectionConfigXml {
    protected AbstractStreamPortController adapter;
    private static final Logger log = LoggerFactory.getLogger(AbstractStreamConnectionConfigXml.class);

    protected void setAdapter(AbstractStreamPortController streamPortAdapter) {
        log.debug("setAdapter({})", (Object)streamPortAdapter);
        this.adapter = streamPortAdapter;
    }

    protected AbstractStreamPortController getAdapter() {
        log.debug("getAdapter()");
        return this.adapter;
    }

    public AbstractStreamPortController getStreamAdapter() {
        log.debug("getStreamAdapter()");
        return this.adapter;
    }

    protected abstract void getInstance(Object var1);

    @Override
    public Element store(Object object) {
        log.debug("store({})", object);
        this.getInstance(object);
        Element e = new Element("connection");
        if (this.adapter == null) {
            log.warn("No adapter found while saving stream port configuration {}", (Object)object.toString());
            return null;
        }
        this.storeCommon(e, this.adapter);
        e.setAttribute("class", this.getClass().getName());
        this.extendElement(e);
        return e;
    }

    @Override
    protected void extendElement(Element e) {
        log.debug("extendElement({})", (Object)e);
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        log.debug("load({}, {})", (Object)shared, (Object)perNode);
        boolean result = true;
        this.getInstance();
        this.loadCommon(shared, perNode, this.adapter);
        this.register();
        this.unpackElement(shared, perNode);
        return result;
    }

    @Override
    public void load(Element element, Object o) {
        log.debug("load({}, {})", (Object)element, o);
        this.getInstance(o);
        this.loadCommon(element, element, this.adapter);
        this.register();
        this.unpackElement(element, element);
    }

    @Override
    protected void dispose() {
        this.adapter.dispose();
    }
}

