/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.configurexml;

import jmri.jmrix.UsbPortAdapter;
import jmri.jmrix.configurexml.AbstractConnectionConfigXml;
import jmri.jmrix.configurexml.Bundle;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUsbConnectionConfigXml
extends AbstractConnectionConfigXml {
    protected UsbPortAdapter adapter;
    private static final Logger log = LoggerFactory.getLogger(AbstractUsbConnectionConfigXml.class);

    protected void setAdapter(UsbPortAdapter usbPortAdapter) {
        log.debug("setAdapter({})", (Object)usbPortAdapter);
        this.adapter = usbPortAdapter;
    }

    protected UsbPortAdapter getAdapter() {
        log.debug("getAdapter()");
        return this.adapter;
    }

    protected abstract void getInstance(Object var1);

    @Override
    public Element store(Object object) {
        log.debug("store({})", object);
        this.getInstance(object);
        Element e = new Element("connection");
        if (this.adapter == null) {
            log.warn("No adapter found while saving usb port configuration {}", (Object)object.toString());
            return null;
        }
        this.storeCommon(e, this.adapter);
        if (this.adapter.getCurrentPortName() != null) {
            e.setAttribute("port", this.adapter.getCurrentPortName());
        } else {
            e.setAttribute("port", Bundle.getMessage("noneSelected"));
        }
        if (this.adapter.getSerialNumber() != null) {
            e.setAttribute("serialNumber", this.adapter.getSerialNumber());
        }
        e.setAttribute("class", this.getClass().getName());
        this.extendElement(e);
        return e;
    }

    @Override
    protected void extendElement(Element e) {
        log.debug("extendElement({})", (Object)e);
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        log.debug("load({}, {})", (Object)shared, (Object)perNode);
        boolean result = true;
        this.getInstance();
        String portName = perNode.getAttributeValue("port");
        String serialNumber = perNode.getAttributeValue("serialNumber");
        if (serialNumber != null && serialNumber.isEmpty()) {
            serialNumber = null;
        }
        this.adapter.setPort(portName);
        this.adapter.setSerialNumber(serialNumber);
        this.loadCommon(shared, perNode, this.adapter);
        this.register();
        if (this.adapter.getDisabled()) {
            this.unpackElement(shared, perNode);
            return result;
        }
        String status = this.adapter.openPort(portName, serialNumber);
        if (status != null) {
            this.handleException(status, "opening connection", null, null, null);
            log.debug("load failed");
            return false;
        }
        this.adapter.configure();
        this.unpackElement(shared, perNode);
        return result;
    }

    @Override
    public void load(Element element, Object o) {
        log.error("method with two args invoked");
    }

    @Override
    protected void dispose() {
        this.adapter.dispose();
    }
}

