/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dcc4pc;

import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.dcc4pc.Dcc4PcMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dcc4PcReply
extends AbstractMRReply {
    public static final int maxSize = 2048;
    boolean error = false;
    public static final int FAILED = 2;
    public static final int INCOMPLETE = 1;
    public static final int SUCCESS = 0;
    boolean stripRun = false;
    Dcc4PcMessage origMsg;
    private static final Logger log = LoggerFactory.getLogger(Dcc4PcReply.class);

    public Dcc4PcReply() {
    }

    public Dcc4PcReply(byte[] packet) {
        this();
        int i = 0;
        int j = 0;
        this.setBinary(true);
        for (j = 0; j < packet.length; ++j) {
            this.setElement(i, packet[i]);
            ++i;
        }
    }

    @Override
    protected int skipPrefix(int index) {
        return index;
    }

    public Dcc4PcReply(Dcc4PcReply m) {
        this();
        if (m == null) {
            log.error("copy ctor of null message");
            return;
        }
        this._nDataChars = m._nDataChars;
        if (m.isUnsolicited()) {
        }
        for (int i = 0; i < this._nDataChars; ++i) {
            this._dataChars[i] = m._dataChars[i];
        }
    }

    public Dcc4PcReply(String replyString) {
        super(replyString);
    }

    public void setError(boolean boo) {
        this.error = boo;
    }

    public boolean isError() {
        return this.error;
    }

    public void strip() {
        if (this.stripRun) {
            return;
        }
        char[] tmp = new char[this._nDataChars];
        int j = 0;
        if (this._dataChars[0] == 2 || this._dataChars[0] == 1 || this._dataChars[0] == 0) {
            int i;
            for (i = 1; i < this._nDataChars; ++i) {
                tmp[j++] = (char)this._dataChars[i];
            }
            for (i = 0; i < j; ++i) {
                this._dataChars[i] = tmp[i];
            }
            this._nDataChars = j;
            this.stripRun = true;
            return;
        }
    }

    public String toHexString() {
        StringBuffer buf = new StringBuffer();
        buf.append("0x" + Integer.toHexString(0xFF & this._dataChars[0]));
        for (int i = 1; i < this._nDataChars; ++i) {
            buf.append(", 0x" + Integer.toHexString(0xFF & this._dataChars[i]));
        }
        return buf.toString();
    }

    @Override
    public int match(String s) {
        String rep = new String(this._dataChars, 0, this._nDataChars);
        return rep.indexOf(s);
    }

    public int[] getDataAsArray() {
        return (int[])this._dataChars.clone();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("0x");
        buf.append(Integer.toHexString(0xFF & this._dataChars[0]));
        for (int i = 1; i < this._nDataChars; ++i) {
            buf.append(".0x");
            buf.append(Integer.toHexString(0xFF & this._dataChars[i]));
        }
        return buf.toString();
    }

    public byte[] getFormattedReply() {
        int len = this.getNumDataElements();
        int cr = 0;
        byte[] msg = new byte[len + cr];
        for (int i = 0; i < len; ++i) {
            msg[i] = (byte)(0xFF & this.getElement(i));
        }
        return msg;
    }

    @Override
    public int maxSize() {
        return 2048;
    }

    public Dcc4PcMessage getOriginalRequest() {
        return this.origMsg;
    }

    protected void setOriginalRequest(Dcc4PcMessage msg) {
        this.origMsg = msg;
    }

    public int getBoard() {
        if (this.origMsg != null) {
            return this.origMsg.getBoard();
        }
        return -1;
    }

    public int getMessageType() {
        if (this.origMsg != null) {
            return this.origMsg.getMessageType();
        }
        return -1;
    }
}

