/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dcc4pc;

import java.util.Hashtable;
import java.util.Map;
import jmri.InstanceManager;
import jmri.RailCom;
import jmri.RailComManager;
import jmri.implementation.AbstractRailComReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dcc4PcReporter
extends AbstractRailComReporter {
    transient RailComPacket[] rcPacket = new RailComPacket[3];
    int state = 1;
    int packetLength = 0;
    int addr = 0;
    int address_part_1 = 256;
    int address_part_2 = -1;
    int addr_type = -1;
    int actual_speed = -1;
    int actual_load = -1;
    int actual_temperature = -1;
    int fuelLevel = -1;
    int waterLevel = -1;
    int location = -1;
    int routing_no = -1;
    int cvNumber = -1;
    int cvvalue = -1;
    int addressp1found = 0;
    static int packetseen = 0;
    static int packetsinerror = 0;
    private static final Object lock = new Object();
    Hashtable<Integer, Integer> cvValues = new Hashtable();
    public static final char ACK = '\u0080';
    public static final char ACK_1 = '\u0081';
    public static final char ACK_2 = '\u0082';
    public static final char ACK_3 = '\u0083';
    public static final char ACK_4 = '\u0084';
    public static final char ACK_5 = '\u0085';
    public static final char ACK_6 = '\u0086';
    public static final char ERROR = '\u00ff';
    private static final char[] decode = new char[]{'\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u0081', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '3', '\u00ff', '\u00ff', '\u00ff', '4', '\u00ff', '5', '6', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', ':', '\u00ff', '\u00ff', '\u00ff', ';', '\u00ff', '<', '7', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '?', '\u00ff', '=', '8', '\u00ff', '\u00ff', '>', '9', '\u00ff', '\u0085', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '$', '\u00ff', '\u00ff', '\u00ff', '#', '\u00ff', '\"', '!', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u001f', '\u00ff', '\u001e', ' ', '\u00ff', '\u00ff', '\u001d', '\u001c', '\u00ff', '\u001b', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u0019', '\u00ff', '\u0018', '\u001a', '\u00ff', '\u00ff', '\u0017', '\u0016', '\u00ff', '\u0015', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '%', '\u0014', '\u00ff', '\u0013', '\u00ff', '\u00ff', '\u00ff', '2', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u0082', '\u00ff', '\u00ff', '\u00ff', '\u000e', '\u00ff', '\r', '\f', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\n', '\u00ff', '\t', '\u000b', '\u00ff', '\u00ff', '\b', '\u0007', '\u00ff', '\u0006', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u0004', '\u00ff', '\u0003', '\u0005', '\u00ff', '\u00ff', '\u0002', '\u0001', '\u00ff', '\u0000', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u000f', '\u0010', '\u00ff', '\u0011', '\u00ff', '\u00ff', '\u00ff', '\u0012', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u0083', '\u00ff', '+', '0', '\u00ff', '\u00ff', '*', '/', '\u00ff', '1', '\u00ff', '\u00ff', '\u00ff', '\u00ff', ')', '.', '\u00ff', '-', '\u00ff', '\u00ff', '\u00ff', ',', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u0086', '(', '\u00ff', '\'', '\u00ff', '\u00ff', '\u00ff', '&', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u0084', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff', '\u00ff'};
    private static final Logger log = LoggerFactory.getLogger(Dcc4PcReporter.class);

    public Dcc4PcReporter(String systemName, String userName) {
        super(systemName, userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPacket(int[] arraytemp, int dcc_addr_type, int dcc_addr, int cvNumber, int speed, int packetTypeCmd) {
        log.debug("{} dcc_addr {} {} {}", new Object[]{this.getDisplayName(), dcc_addr, cvNumber, speed});
        RailComPacket rc = new RailComPacket(arraytemp, dcc_addr_type, dcc_addr, cvNumber, speed);
        this.decodeRailComInfo(rc, packetTypeCmd);
        this.rcPacket[2] = this.rcPacket[1];
        this.rcPacket[1] = this.rcPacket[0];
        this.rcPacket[0] = rc;
        Object object = lock;
        synchronized (object) {
            log.debug("Packets Seen {} in error {}", (Object)packetseen, (Object)packetsinerror);
        }
    }

    void duplicatePacket(int dup) {
        switch (dup) {
            case 0: {
                break;
            }
            case 2: {
                RailComPacket temp = this.rcPacket[1];
                this.rcPacket[1] = this.rcPacket[0];
                this.rcPacket[0] = temp;
                break;
            }
            case 3: {
                RailComPacket temp = this.rcPacket[2];
                this.rcPacket[2] = this.rcPacket[1];
                this.rcPacket[1] = this.rcPacket[0];
                this.rcPacket[0] = temp;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRailComState(int ori) {
        if (this.state == ori) {
            return;
        }
        this.state = ori;
        if (ori == 4 || ori == 1) {
            Dcc4PcReporter dcc4PcReporter = this;
            synchronized (dcc4PcReporter) {
                this.addr = 0;
                this.address_part_1 = 256;
                this.address_part_2 = -1;
                this.addr_type = -1;
                this.actual_speed = -1;
                this.actual_load = -1;
                this.actual_temperature = -1;
                this.fuelLevel = -1;
                this.waterLevel = -1;
                this.location = -1;
                this.routing_no = -1;
            }
            this.cvNumber = -1;
            this.cvValues = new Hashtable();
            this.setReport(null);
        } else if (ori == 16 || ori == 32) {
            if (super.getCurrentReport() != null && super.getCurrentReport() instanceof RailCom) {
                ((RailCom)super.getCurrentReport()).setOrientation(this.state);
            }
            this.firePropertyChange("currentReport", null, null);
        }
    }

    public int getRailComState() {
        return this.state;
    }

    public String getReport() {
        if (super.getCurrentReport() != null && super.getCurrentReport() instanceof RailCom) {
            return ((RailCom)super.getCurrentReport()).getTagID();
        }
        if (this.getRailComState() < 16 || this.rcPacket[0] == null || this.rcPacket[0].getPacket() == null) {
            return "";
        }
        return "";
    }

    void setPacketLength(int i) {
        this.packetLength = i;
    }

    int getPacketLength() {
        return this.packetLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decodeRailComInfo(RailComPacket rc, int packetTypeCmd) {
        Object object = lock;
        synchronized (object) {
            ++this.addressp1found;
            RailCom rcTag = null;
            if (super.getCurrentReport() instanceof RailCom) {
                rcTag = (RailCom)super.getCurrentReport();
            }
            int[] packet = rc.getPacket();
            if (log.isDebugEnabled()) {
                log.debug("{} packet type {}", (Object)this.getDisplayName(), (Object)packetTypeCmd);
                log.debug("decodeRailComInfo {} {}", (Object)this.getDisplayName(), super.getCurrentReport());
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < packet.length; ++i) {
                    buf.append(packet[i]);
                }
                log.debug("Rail Comm Packets {}", (Object)buf);
            }
            block16: for (int i = 0; i < packet.length; ++i) {
                ++packetseen;
                char chbyte = (char)packet[i];
                if ((chbyte = decode[chbyte]) == '\u00ff') {
                    if (log.isDebugEnabled()) {
                        log.debug("{} Error packet stage 1: {}", (Object)this.getDisplayName(), (Object)Integer.toHexString(packet[i]));
                    }
                    ++packetsinerror;
                    return;
                }
                ++i;
                if ((chbyte & 0x80) == 128) {
                    chbyte = (char)packet[i];
                    ++i;
                    if ((chbyte = decode[chbyte]) == '\u00ff') {
                        log.debug("{} Error packet stage 2", (Object)this.getDisplayName());
                        ++packetsinerror;
                        return;
                    }
                    if ((chbyte & 0x80) == 128) {
                        if (packet.length <= i + 1) {
                            log.debug("No further data to process Only had the ack 1");
                            break;
                        }
                        chbyte = (char)packet[i];
                        ++i;
                        chbyte = decode[chbyte];
                    }
                }
                if (packet.length <= i) break;
                char type = chbyte;
                chbyte = (char)packet[i];
                if ((chbyte = decode[chbyte]) == '\u00ff' || (chbyte & 0x80) == 128) {
                    if (log.isDebugEnabled()) {
                        log.debug("{} Error packet stage 3 {}\n{}", new Object[]{this.getDisplayName(), Integer.toHexString(packet[i]), rc.toHexString()});
                    }
                    ++i;
                    ++packetsinerror;
                    return;
                }
                chbyte = (char)((type & 3) << 6 | chbyte & 0x3F);
                type = (char)(type >> 2 & 0xF);
                switch (type) {
                    case '\u0000': {
                        log.debug("{} CV Value {}{}", new Object[]{this.getDisplayName(), (int)chbyte, rcTag});
                        this.cvvalue = chbyte;
                        if (rcTag == null) continue block16;
                        rcTag.setWhereLastSeen(this);
                        if (rcTag.getExpectedCv() != -1) {
                            rcTag.setCvValue(chbyte);
                            continue block16;
                        }
                        rcTag.setCV(rc.getCvNumber(), chbyte);
                        continue block16;
                    }
                    case '\u0004': {
                        if (log.isDebugEnabled()) {
                            log.debug("{} Create/Get id tag for {}", (Object)this.getDisplayName(), (Object)rc.getDccAddress());
                        }
                        this.addr = rc.getDccAddress();
                        this.addr_type = rc.getAddressType();
                        continue block16;
                    }
                    case '\u0001': {
                        log.debug("Address Byte 1");
                        this.address_part_1 = 0x100 | chbyte;
                        this.addressp1found = 0;
                        continue block16;
                    }
                    case '\u0002': {
                        log.debug("{} Address part 2:", (Object)this.getDisplayName());
                        this.address_part_2 = chbyte;
                        if (packetTypeCmd == 3) {
                            log.debug("Type three packet so shouldn't not pair part one with part two if it came from the previous packet");
                        }
                        if ((this.address_part_1 & 0x100) != 256) {
                            log.debug("{} Break at Address part 1, part one not complete", (Object)this.getDisplayName());
                            continue block16;
                        }
                        rcTag = this.decodeAddress();
                        continue block16;
                    }
                    case '\u0003': {
                        if ((chbyte & 0x80) == 128) {
                            this.actual_speed = chbyte & 0x7F;
                            log.debug("{} Actual Speed: {}", (Object)this.getDisplayName(), (Object)this.actual_speed);
                        } else {
                            this.actual_load = chbyte & 0x7F;
                            log.debug("{} Actual Load: {}", (Object)this.getDisplayName(), (Object)this.actual_load);
                        }
                        if (rcTag == null) continue block16;
                        rcTag.setActualLoad(this.actual_load);
                        rcTag.setActualSpeed(this.actual_speed);
                        rcTag.setWhereLastSeen(this);
                        continue block16;
                    }
                    case '\u0005': {
                        this.routing_no = chbyte;
                        if (rcTag == null) continue block16;
                        rcTag.setRoutingNo(this.routing_no);
                        rcTag.setWhereLastSeen(this);
                        continue block16;
                    }
                    case '\u0006': {
                        this.location = chbyte;
                        if (rcTag == null) continue block16;
                        rcTag.setLocation(this.location);
                        rcTag.setWhereLastSeen(this);
                        continue block16;
                    }
                    case '\u0007': {
                        if ((chbyte & 0x80) == 128) {
                            this.fuelLevel = chbyte & 0x7F;
                        } else {
                            this.waterLevel = chbyte & 0x7F;
                        }
                        if (rcTag == null) continue block16;
                        rcTag.setWaterLevel(this.waterLevel);
                        rcTag.setFuelLevel(this.fuelLevel);
                        rcTag.setWhereLastSeen(this);
                        continue block16;
                    }
                    case '\b': {
                        if ((chbyte & 0x80) != 128) {
                            this.actual_temperature = chbyte & 0x7F;
                        }
                        if (rcTag == null) continue block16;
                        rcTag.setActualTemperature(this.actual_temperature);
                        rcTag.setWhereLastSeen(this);
                        continue block16;
                    }
                    case '\u000f': {
                        log.debug("{} CV Address and value:", (Object)this.getDisplayName());
                        i += 2;
                        continue block16;
                    }
                    default: {
                        log.info("unknown railcom type packet {}", (Object)Character.valueOf(type));
                    }
                }
            }
        }
    }

    RailCom decodeAddress() {
        log.debug("{} Create/Get id tag for {}", (Object)this.getDisplayName(), (Object)this.addr);
        RailCom rcTag = (RailCom)InstanceManager.getDefault(RailComManager.class).provideIdTag("" + this.addr);
        if (this.fuelLevel != -1) {
            rcTag.setFuelLevel(this.fuelLevel);
        }
        if (this.waterLevel != -1) {
            rcTag.setWaterLevel(this.waterLevel);
        }
        if (this.routing_no != -1) {
            rcTag.setRoutingNo(this.routing_no);
        }
        if (this.location != -1) {
            rcTag.setLocation(this.location);
        }
        if (this.actual_temperature != -1) {
            rcTag.setActualTemperature(this.actual_temperature);
        }
        if (this.actual_load != -1) {
            rcTag.setActualLoad(this.actual_load);
        }
        if (this.actual_speed != -1) {
            rcTag.setActualSpeed(this.actual_speed);
        }
        for (Map.Entry<Integer, Integer> entry : this.cvValues.entrySet()) {
            rcTag.setCV(entry.getKey(), entry.getValue());
            if (this.cvvalue == -1) continue;
            rcTag.setCvValue(this.cvvalue);
        }
        this.address_part_1 = 0;
        this.address_part_2 = -1;
        this.notify(rcTag);
        return rcTag;
    }

    RailCom provideTag(int address, int addr_type) {
        log.debug("provide Tag");
        RailCom rcTag = (RailCom)InstanceManager.getDefault(RailComManager.class).provideIdTag("" + address);
        this.notify(rcTag);
        return rcTag;
    }

    static class RailComPacket {
        final transient int[] rcPacket;
        int dcc_addr_type;
        int dccAddress;
        int cvNumber;
        int speed;

        RailComPacket(int[] array, int dcc_addr_type, int dcc_addr, int cvNumber, int speed) {
            this.rcPacket = array;
            this.dcc_addr_type = dcc_addr_type;
            this.dccAddress = dcc_addr;
            this.cvNumber = cvNumber;
            this.speed = speed;
        }

        int[] getPacket() {
            return this.rcPacket;
        }

        int getAddressType() {
            return this.dcc_addr_type;
        }

        int getDccAddress() {
            return this.dccAddress;
        }

        int getCvNumber() {
            return this.cvNumber;
        }

        int getSpeed() {
            return this.speed;
        }

        String toHexString() {
            StringBuilder buf = new StringBuilder();
            buf.append("0x").append(Integer.toHexString(0xFF & this.rcPacket[0]));
            for (int i = 1; i < this.rcPacket.length; ++i) {
                buf.append(", 0x").append(Integer.toHexString(0xFF & this.rcPacket[i]));
            }
            return buf.toString();
        }
    }
}

