/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dcc4pc.serialdriver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jmri.AddressedProgrammerManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.SystemConnectionMemo;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.dcc4pc.Dcc4PcPortController;
import jmri.jmrix.dcc4pc.Dcc4PcSystemConnectionMemo;
import jmri.jmrix.dcc4pc.Dcc4PcTrafficController;
import jmri.jmrix.purejavacomm.CommPortIdentifier;
import jmri.jmrix.purejavacomm.NoSuchPortException;
import jmri.jmrix.purejavacomm.PortInUseException;
import jmri.jmrix.purejavacomm.SerialPort;
import jmri.jmrix.purejavacomm.UnsupportedCommOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDriverAdapter
extends Dcc4PcPortController {
    SerialPort activeSerialPort = null;
    InputStream serialStream = null;
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    public SerialDriverAdapter() {
        super(new Dcc4PcSystemConnectionMemo());
        this.option1Name = "Programmer";
        this.options.put(this.option1Name, new AbstractPortController.Option("Programmer : ", this.validOption1()));
        this.setManufacturer("DCC4PC");
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                this.activeSerialPort.setSerialPortParams(115200, 8, 1, 0);
                this.configureLeadsAndFlowControl(this.activeSerialPort, 0);
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
            }
            log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            this.serialStream = this.activeSerialPort.getInputStream();
            SerialDriverAdapter.purgeStream(this.serialStream);
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud, sees  DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
            this.opened = true;
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException ex) {
            log.error("Unexpected exception while opening port {}", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    public void setHandshake(int mode) {
        try {
            this.activeSerialPort.setFlowControlMode(mode);
        }
        catch (UnsupportedCommOperationException ex) {
            log.error("Unexpected exception while setting COM port handshake mode", (Throwable)ex);
        }
    }

    public SerialPort getSerialPort() {
        return this.activeSerialPort;
    }

    public String[] validOption1() {
        List<SystemConnectionMemo> connList = InstanceManager.getList(SystemConnectionMemo.class);
        if (!connList.isEmpty()) {
            ArrayList<String> progConn = new ArrayList<String>();
            progConn.add("");
            String userName = "Dcc4Pc";
            if (this.getSystemConnectionMemo() != null) {
                userName = this.getSystemConnectionMemo().getUserName();
            }
            for (int i = 0; i < connList.size(); ++i) {
                SystemConnectionMemo scm = connList.get(i);
                if (!scm.provides(AddressedProgrammerManager.class) && !scm.provides(GlobalProgrammerManager.class) || scm.getUserName().equals(userName)) continue;
                progConn.add(scm.getUserName());
            }
            return progConn.toArray(new String[progConn.size()]);
        }
        return new String[]{""};
    }

    public String option2Name() {
        return "Match Detected Locos to Roster: ";
    }

    @Override
    public void configureOption2(String value) {
        super.configureOption2(value);
        log.debug("configureOption2: {}", (Object)value);
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.serialStream);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            return new DataOutputStream(this.activeSerialPort.getOutputStream());
        }
        catch (IOException e) {
            log.error("getOutputStream exception", (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{"115,200 bps"};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{115200};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    @Override
    public void configure() {
        Dcc4PcTrafficController control = new Dcc4PcTrafficController();
        this.getSystemConnectionMemo().setDcc4PcTrafficController(control);
        control.connectPort(this);
        this.getSystemConnectionMemo().configureManagers();
    }
}

