/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dcc4pc.swing.monitor;

import jmri.InstanceManager;
import jmri.jmrix.AbstractMonPane;
import jmri.jmrix.dcc4pc.Dcc4PcListener;
import jmri.jmrix.dcc4pc.Dcc4PcMessage;
import jmri.jmrix.dcc4pc.Dcc4PcReply;
import jmri.jmrix.dcc4pc.Dcc4PcSystemConnectionMemo;
import jmri.jmrix.dcc4pc.swing.Dcc4PcNamedPaneAction;
import jmri.jmrix.dcc4pc.swing.Dcc4PcPanelInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dcc4PcMonPane
extends AbstractMonPane
implements Dcc4PcListener,
Dcc4PcPanelInterface {
    Dcc4PcSystemConnectionMemo memo;
    private static final Logger log = LoggerFactory.getLogger(Dcc4PcMonPane.class);

    @Override
    public String getHelpTarget() {
        return null;
    }

    @Override
    public String getTitle() {
        return "Dcc4PC Command Monitor";
    }

    @Override
    public void dispose() {
        if (this.memo.getDcc4PcTrafficController() != null) {
            this.memo.getDcc4PcTrafficController().removeDcc4PcListener(this);
        }
        super.dispose();
    }

    @Override
    public void init() {
    }

    @Override
    public void initContext(Object context) {
        if (context instanceof Dcc4PcSystemConnectionMemo) {
            this.initComponents((Dcc4PcSystemConnectionMemo)context);
        }
    }

    @Override
    public void initComponents(Dcc4PcSystemConnectionMemo memo) {
        this.memo = memo;
        if (memo.getDcc4PcTrafficController() != null) {
            memo.getDcc4PcTrafficController().addDcc4PcListener(this);
        } else {
            log.error("Connection has not been initiallised");
        }
    }

    @Override
    public synchronized void message(Dcc4PcMessage l) {
        if (l.isBinary()) {
            this.logMessage("Binary cmd: ", l);
        } else {
            this.logMessage("cmd: ", l);
        }
    }

    @Override
    public synchronized void reply(Dcc4PcReply l) {
        if (l.isUnsolicited()) {
            this.logMessage("msg: ", l);
        } else {
            this.logMessage("rep: ", l);
        }
    }

    public synchronized void notifyMessage(Dcc4PcMessage l) {
        if (l.isBinary()) {
            this.logMessage("binary cmd: ", l);
        } else {
            this.logMessage("cmd: ", l);
        }
    }

    public synchronized void notifyReply(Dcc4PcReply l) {
        if (l.isUnsolicited()) {
            this.logMessage("msg: ", l);
        } else {
            this.logMessage("rep: ", l);
        }
    }

    @Override
    public void handleTimeout(Dcc4PcMessage m) {
        log.info("timeout received to our last message {}", (Object)m.toString());
    }

    public static class Default
    extends Dcc4PcNamedPaneAction {
        public Default() {
            super("Dcc4PC Command Monitor", new JmriJFrameInterface(), Dcc4PcMonPane.class.getName(), InstanceManager.getDefault(Dcc4PcSystemConnectionMemo.class));
        }
    }
}

