/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dcc4pc.swing.packetgen;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrix.dcc4pc.Dcc4PcMessage;
import jmri.jmrix.dcc4pc.Dcc4PcSystemConnectionMemo;
import jmri.jmrix.dcc4pc.Dcc4PcTrafficController;
import jmri.jmrix.dcc4pc.swing.Dcc4PcNamedPaneAction;
import jmri.jmrix.dcc4pc.swing.Dcc4PcPanel;
import jmri.jmrix.dcc4pc.swing.Dcc4PcPanelInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketGenPanel
extends Dcc4PcPanel
implements Dcc4PcPanelInterface {
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(20);
    JCheckBox childBoardBox = new JCheckBox("Child Board");
    private static final Logger log = LoggerFactory.getLogger(PacketGenPanel.class);

    @Override
    public void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.jLabel1.setText("Command: ");
        this.jLabel1.setVisible(true);
        this.sendButton.setText("Send");
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText("Send packet");
        this.packetTextField.setText("");
        this.packetTextField.setToolTipText("Enter command");
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        this.childBoardBox.setSelected(false);
        this.add(this.jLabel1);
        this.add(this.packetTextField);
        this.add(this.childBoardBox);
        this.add(this.sendButton);
        this.sendButton.addActionListener(this::sendButtonActionPerformed);
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.dcc4pc.swing.packetgen.PacketGenFrame";
    }

    @Override
    public String getTitle() {
        return "Send DCC4PC command";
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String text = this.packetTextField.getText();
        if (text.startsWith("0x")) {
            this.hexStringToByteArray(text);
            return;
        }
        this.setChildBoardAndSend(new Dcc4PcMessage(text));
    }

    private void setChildBoardAndSend(Dcc4PcMessage m) {
        m.setForChildBoard(this.childBoardBox.isSelected());
        if (this.memo == null) {
            log.error("no System Connection Memo Found when sending {}", (Object)m);
            return;
        }
        Dcc4PcTrafficController tc = this.memo.getDcc4PcTrafficController();
        if (tc != null) {
            tc.sendDcc4PcMessage(m, null);
        } else {
            log.error("no Traffic Controller for sys conn {} Found when sending {}", (Object)this.memo.getUserName(), (Object)m);
        }
    }

    public void hexStringToByteArray(String s) {
        s = s.substring(2);
        int len = s.length();
        byte[] data = new byte[len / 2];
        int loc = 0;
        Dcc4PcMessage m = new Dcc4PcMessage(len / 2);
        for (int i = 0; i < data.length; ++i) {
            byte val = (byte)((Character.digit(s.charAt(loc), 16) << 4) + Character.digit(s.charAt(loc + 1), 16));
            m.setElement(i, val);
            loc += 2;
        }
        this.setChildBoardAndSend(m);
    }

    public static class Default
    extends Dcc4PcNamedPaneAction {
        public Default() {
            super("Dcc4PC Command Monitor", new JmriJFrameInterface(), PacketGenPanel.class.getName(), InstanceManager.getDefault(Dcc4PcSystemConnectionMemo.class));
        }
    }
}

