/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.implementation.DefaultClockControl;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppClockControl
extends DefaultClockControl
implements DCCppListener {
    DCCppSystemConnectionMemo _memo = null;
    DCCppTrafficController _tc = null;
    Timebase timebase;
    Calendar _cal;
    PropertyChangeListener minuteChangeListener;
    boolean isRunning;
    static final long MSECPERHOUR = 3600000L;
    static final long MSECPERMINUTE = 60000L;
    private static final Logger log = LoggerFactory.getLogger(DCCppClockControl.class);

    public DCCppClockControl(DCCppSystemConnectionMemo memo) {
        log.trace("DCCppClockControl (DCCppSystemConnectionMemo {})", (Object)memo);
        this._memo = memo;
        this._tc = this._memo.getDCCppTrafficController();
        this._tc.addDCCppListener(2, this);
        this._cal = Calendar.getInstance();
        this.timebase = InstanceManager.getNullableDefault(Timebase.class);
        if (this.timebase == null) {
            log.error("No Internal Timebase Instance");
            return;
        }
        this.minuteChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                log.trace("minuteChangeListener propertyChange for '{}' from '{}' to '{}'", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
                DCCppClockControl.this.setTime(DCCppClockControl.this.timebase.getTime());
            }
        };
        this.timebase.addMinuteChangeListener(this.minuteChangeListener);
    }

    @Override
    public String getHardwareClockName() {
        log.trace("getHardwareClockName()");
        return "DCC-EX Fast Clock";
    }

    @Override
    public void setRate(double newRate) {
        log.trace("setRate({})", (Object)((int)newRate));
        if (this.timebase.getInternalMaster() && this.timebase.getSynchronize()) {
            this._cal.setTime(this.timebase.getTime());
            int minutes = this._cal.get(10) * 60 + this._cal.get(12);
            if (!this.isRunning) {
                newRate = 0.0;
            }
            this._tc.sendDCCppMessage(DCCppMessage.makeClockSetMsg(minutes, (int)newRate), null);
        }
    }

    public void setRate() {
        this.setRate(this.timebase.getRate());
    }

    @Override
    public double getRate() {
        log.trace("getRate()");
        this._tc.sendDCCppMessage(DCCppMessage.makeClockRequestTimeMsg(), null);
        return this.timebase.getRate();
    }

    @Override
    public void setTime(Date newTimestamp) {
        log.trace("setTime({})", (Object)newTimestamp);
        if (this.timebase.getInternalMaster() && this.timebase.getSynchronize()) {
            this._cal.setTime(newTimestamp);
            int minutes = this._cal.get(10) * 60 + this._cal.get(12);
            this._tc.sendDCCppMessage(DCCppMessage.makeClockSetMsg(minutes, (int)this.timebase.getRate()), null);
        }
    }

    public void setTime() {
        this.setTime(this.timebase.getTime());
    }

    @Override
    public Date getTime() {
        log.trace("getTime()");
        this._tc.sendDCCppMessage(DCCppMessage.makeClockRequestTimeMsg(), null);
        return this.timebase.getTime();
    }

    @Override
    public void startHardwareClock(Date now) {
        log.trace("startHardwareClock({})", (Object)now);
        this.isRunning = true;
        this.setRate();
    }

    @Override
    public void stopHardwareClock() {
        log.trace("stopHardwareClock()");
        this.isRunning = false;
        this.setRate();
    }

    @Override
    public void initializeHardwareClock(double rate, Date now, boolean getTime) {
        log.trace("initializeHardwareClock(rate={}, time={}, getTime={}) sync={}, internal={}", new Object[]{rate, now, getTime, this.timebase.getSynchronize(), this.timebase.getInternalMaster()});
        this.isRunning = this.timebase.getRun();
        if (this.timebase.getSynchronize()) {
            if (this.timebase.getInternalMaster()) {
                this.setRate();
            } else {
                this.getRate();
            }
        }
    }

    @Override
    public boolean requiresIntegerRate() {
        log.trace("requiresIntegerRate() returns true");
        return true;
    }

    @Override
    public void message(DCCppReply msg) {
        log.trace("message(DCCppReply {})", (Object)msg);
        if (msg.isClockReply() && this.timebase.getSynchronize() && this.timebase.getMasterName().equals(this.getHardwareClockName())) {
            log.trace("Clock message(DCCppReply {}), time={}, rate={}", new Object[]{msg, msg.getClockMinutesString(), msg.getClockRateString()});
            Date today = this.timebase.getTime();
            long ms = today.getTime();
            ms -= (long)today.getHours() * 3600000L;
            ms -= (long)today.getMinutes() * 60000L;
            this.timebase.setTime(new Date(ms += (long)msg.getClockMinutesInt() * 60000L));
        }
    }

    @Override
    public void message(DCCppMessage msg) {
        log.trace("message(DCCppMessage {})", (Object)msg);
    }

    @Override
    public void notifyTimeout(DCCppMessage msg) {
        log.trace("notifyTimeout(DCCppMessage {})", (Object)msg);
    }
}

