/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.CommandStation;
import jmri.Version;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppRegisterManager;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppCommandStation
implements CommandStation {
    @Nonnull
    private String stationType = "Unknown";
    @Nonnull
    private String build = "Unknown";
    @Nonnull
    private String version = "0.0.0";
    private DCCppRegisterManager rmgr = null;
    private int maxNumSlots = 12;
    private List<String> trackModes = new ArrayList<String>();
    boolean mInServiceMode = false;
    private DCCppTrafficController _tc = null;
    private DCCppSystemConnectionMemo adaptermemo;
    private static final Logger log = LoggerFactory.getLogger(DCCppCommandStation.class);

    public DCCppCommandStation() {
    }

    public DCCppCommandStation(DCCppSystemConnectionMemo memo) {
        this.adaptermemo = memo;
    }

    public void setStationType(String s) {
        if (!this.stationType.equals(s)) {
            log.info("Station Type set to '{}'", (Object)s);
            this.stationType = s;
        }
    }

    @Nonnull
    public String getStationType() {
        return this.stationType;
    }

    public void setBuild(String s) {
        if (!this.build.equals(s)) {
            log.info("Build set to '{}'", (Object)s);
            this.build = s;
        }
    }

    @Nonnull
    public String getBuild() {
        return this.build;
    }

    public void setVersion(String s) {
        if (!this.version.equals(s)) {
            if (Version.isCanonicalVersion(s)) {
                log.info("Version set to '{}'", (Object)s);
                this.version = s;
            } else {
                log.warn("'{}' is not a canonical version, version not changed", (Object)s);
            }
        }
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    protected void setCommandStationInfo(DCCppReply l) {
        this.setStationType(l.getStationType());
        this.setBuild(l.getBuildString());
        this.setVersion(l.getVersion());
    }

    protected void setCommandStationMaxNumSlots(DCCppReply l) {
        int newNumSlots = l.getValueInt(1);
        this.setCommandStationMaxNumSlots(newNumSlots);
    }

    protected void setCommandStationMaxNumSlots(int newNumSlots) {
        if (newNumSlots < this.maxNumSlots) {
            log.warn("Command Station maxNumSlots cannot be reduced from {} to {}", (Object)this.maxNumSlots, (Object)newNumSlots);
            return;
        }
        if (newNumSlots != this.maxNumSlots) {
            log.info("changing maxNumSlots from {} to {}", (Object)this.maxNumSlots, (Object)newNumSlots);
            this.maxNumSlots = newNumSlots;
        }
    }

    protected int getCommandStationMaxNumSlots() {
        return this.maxNumSlots;
    }

    public String getVersionString() {
        return this.stationType + ": BUILD " + this.build;
    }

    public boolean isOpsModePossible() {
        return true;
    }

    public boolean isFunctionRefreshRequired() {
        boolean ret = true;
        try {
            ret = Version.compareCanonicalVersions(this.version, "3.0.0") < 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ret;
    }

    public boolean isCurrentListSupported() {
        boolean ret = false;
        try {
            ret = Version.compareCanonicalVersions(this.version, "4.2.20") >= 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ret;
    }

    public boolean isReadStartValSupported() {
        boolean ret = false;
        try {
            ret = Version.compareCanonicalVersions(this.version, "3.0.0") >= 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ret;
    }

    public boolean isServoTurnoutCreationSupported() {
        boolean ret = false;
        try {
            ret = Version.compareCanonicalVersions(this.version, "3.2.0") >= 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ret;
    }

    public boolean isTurnoutIDsMessageRequired() {
        boolean ret = false;
        try {
            ret = Version.compareCanonicalVersions(this.version, "5.0.0") >= 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ret;
    }

    public boolean isThrottleRegisterRequired() {
        boolean ret = true;
        try {
            ret = Version.compareCanonicalVersions(this.version, "4.0.0") < 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ret;
    }

    public boolean isFunctionV4Supported() {
        boolean ret = false;
        try {
            ret = Version.compareCanonicalVersions(this.version, "4.0.0") >= 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ret;
    }

    public boolean isProgramV4Supported() {
        boolean ret = false;
        try {
            ret = Version.compareCanonicalVersions(this.version, "4.0.1") >= 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ret;
    }

    public static int getDCCAddressLow(int address) {
        if (address < 128) {
            return address;
        }
        int temp = address + 49152;
        return temp &= 0xFF;
    }

    public static int getDCCAddressHigh(int address) {
        if (address < 128) {
            return 0;
        }
        int temp = address + 49152;
        temp &= 0xFF00;
        return temp /= 256;
    }

    @Override
    public boolean sendPacket(@Nonnull byte[] packet, int repeats) {
        if (this._tc == null) {
            log.error("Send Packet Called without setting traffic controller");
            return false;
        }
        int reg = 0;
        DCCppMessage msg = DCCppMessage.makeWriteDCCPacketMainMsg(reg, packet.length - 1, packet);
        assert (msg != null);
        log.debug("sendPacket:'{}'", (Object)msg);
        for (int i = 0; i < repeats; ++i) {
            this._tc.sendDCCppMessage(msg, null);
        }
        return true;
    }

    public void setTrafficController(DCCppTrafficController tc) {
        this._tc = tc;
    }

    public void setSystemConnectionMemo(DCCppSystemConnectionMemo memo) {
        this.adaptermemo = memo;
    }

    public DCCppSystemConnectionMemo getSystemConnectionMemo() {
        return this.adaptermemo;
    }

    private void creatermgr() {
        if (this.rmgr == null) {
            this.rmgr = new DCCppRegisterManager(this.maxNumSlots);
        }
    }

    @Override
    public String getUserName() {
        if (this.adaptermemo == null) {
            return "DCC++";
        }
        return this.adaptermemo.getUserName();
    }

    @Override
    @Nonnull
    public String getSystemPrefix() {
        if (this.adaptermemo == null) {
            return "D";
        }
        return this.adaptermemo.getSystemPrefix();
    }

    public int requestNewRegister(int addr) {
        this.creatermgr();
        return this.rmgr.requestRegister(addr);
    }

    public void releaseRegister(int addr) {
        this.creatermgr();
        this.rmgr.releaseRegister(addr);
    }

    public int getRegisterNum(int addr) {
        this.creatermgr();
        return this.rmgr.getRegisterNum(addr);
    }

    public int getRegisterAddress(int num) {
        this.creatermgr();
        return this.rmgr.getRegisterAddress(num);
    }

    public void setTrackMode(int i, String mode) {
        if (this.trackModes.size() > i) {
            this.trackModes.set(i, mode);
        } else {
            this.trackModes.add(mode);
        }
    }

    public List<String> getTrackModes() {
        return this.trackModes;
    }

    public String getTrackMode(int i) {
        if (this.trackModes.size() > i) {
            return this.trackModes.get(i);
        }
        return "";
    }
}

