/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import jmri.implementation.AbstractLight;
import jmri.jmrix.dccpp.DCCppLightManager;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppLight
extends AbstractLight
implements DCCppListener {
    private DCCppTrafficController tc = null;
    private DCCppLightManager lm = null;
    int mAddress = 0;
    static final int OFFSENT = 1;
    static final int COMMANDSENT = 2;
    static final int IDLE = 0;
    private static final Logger log = LoggerFactory.getLogger(DCCppLight.class);

    public DCCppLight(DCCppTrafficController tc, DCCppLightManager lm, String systemName) {
        super(systemName);
        this.tc = tc;
        this.lm = lm;
        this.initializeLight(systemName);
    }

    public DCCppLight(DCCppTrafficController tc, DCCppLightManager lm, String systemName, String userName) {
        super(systemName, userName);
        this.tc = tc;
        this.lm = lm;
        this.initializeLight(systemName);
    }

    @Override
    public void dispose() {
        this.tc.removeDCCppListener(11, this);
        super.dispose();
    }

    private synchronized void initializeLight(String systemName) {
        this.mAddress = this.lm.getBitFromSystemName(systemName);
        this.setState(4);
        this.tc.addDCCppListener(11, this);
    }

    @Override
    public synchronized void setState(int newState) {
        if (newState != 2 && newState != 4) {
            log.warn("Unsupported state {} requested for light {}", (Object)newState, (Object)this.getSystemName());
            return;
        }
        log.debug("Light Set State: mstate = {} newstate = {}", (Object)this.mState, (Object)newState);
        if (this.mAddress > 0) {
            boolean state = newState == 2;
            DCCppMessage msg = DCCppMessage.makeAccessoryDecoderMsg(this.mAddress, state);
            this.tc.sendDCCppMessage(msg, this);
            if (newState != this.mState) {
                int oldState = this.mState;
                this.mState = newState;
                this.firePropertyChange("KnownState", oldState, newState);
            }
        }
    }

    @Override
    public synchronized void message(DCCppReply l) {
        log.debug("received message: {}", (Object)l);
    }

    @Override
    public void message(DCCppMessage l) {
    }

    @Override
    public void notifyTimeout(DCCppMessage msg) {
        log.debug("Notified of timeout on message '{}'", (Object)msg);
    }
}

