/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import jmri.jmrix.AbstractNetworkPortController;
import jmri.jmrix.dccpp.DCCppConstants;
import jmri.jmrix.dccpp.DCCppPortController;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DCCppNetworkPortController
extends AbstractNetworkPortController
implements DCCppPortController {
    private static final Logger log = LoggerFactory.getLogger(DCCppNetworkPortController.class);
    protected int commandStationType = 0;
    protected boolean mTurnoutNoRetry = false;
    protected boolean mTurnoutExtraSpace = false;
    protected int[] commandStationTypes = new int[]{1, 2};
    protected String[] commandStationNames = new String[this.commandStationTypes.length];

    protected DCCppNetworkPortController() {
        super(new DCCppSystemConnectionMemo());
        for (int i = 0; i < this.commandStationTypes.length; ++i) {
            this.commandStationNames[i] = DCCppConstants.CommandStationNames[i];
        }
        this.setManufacturer("DCC++");
        this.allowConnectionRecovery = true;
    }

    protected DCCppNetworkPortController(DCCppSystemConnectionMemo connectionMemo) {
        super(connectionMemo);
        for (int i = 0; i < this.commandStationTypes.length; ++i) {
            this.commandStationNames[i] = DCCppConstants.CommandStationNames[i];
        }
        this.setManufacturer("DCC++");
    }

    public void setCommandStationType(String name) {
        for (int i = 0; i < this.commandStationNames.length; ++i) {
            if (!this.commandStationNames[i].matches(name)) continue;
            this.commandStationType = i;
            return;
        }
        log.error("CommandStation Type not found: {}", (Object)name);
        this.commandStationType = 0;
    }

    public void setCommandStationType(int value) {
        log.debug("setCommandStationType: {}", (Object)Integer.toString(value));
        this.commandStationType = value;
    }

    @Override
    public DCCppSystemConnectionMemo getSystemConnectionMemo() {
        return (DCCppSystemConnectionMemo)super.getSystemConnectionMemo();
    }

    public void setTurnoutHandling(String value) {
        if (value.equals("One Only") || value.equals("Both")) {
            this.mTurnoutNoRetry = true;
        }
        if (value.equals("Spread") || value.equals("Both")) {
            this.mTurnoutExtraSpace = true;
        }
        log.debug("turnout no retry: {}", (Object)this.mTurnoutNoRetry);
        log.debug("turnout extra space: {}", (Object)this.mTurnoutExtraSpace);
    }

    @Override
    public void configureOption3(String value) {
        super.configureOption3(value);
        log.debug("configureOption3: {}", (Object)value);
        this.setTurnoutHandling(value);
    }

    @Override
    public abstract boolean status();

    @Override
    public abstract boolean okToSend();

    @Override
    public void setOutputBufferEmpty(boolean s) {
    }

    @Override
    protected void resetupConnection() {
        this.getSystemConnectionMemo().getDCCppTrafficController().connectPort(this);
    }
}

