/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import jmri.JmriException;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppTrafficController;
import jmri.managers.AbstractPowerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppPowerManager
extends AbstractPowerManager<DCCppSystemConnectionMemo>
implements DCCppListener {
    DCCppTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(DCCppPowerManager.class);

    public DCCppPowerManager(DCCppSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getDCCppTrafficController();
        this.tc.addDCCppListener(2, this);
        this.tc.sendDCCppMessage(DCCppMessage.makeCSStatusMsg(), this);
        this.tc.sendDCCppMessage(DCCppMessage.makeTrackManagerRequestMsg(), this);
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.power = 1;
        this.checkTC();
        if (v == 2) {
            this.tc.sendDCCppMessage(DCCppMessage.makeTrackPowerOnMsg(), this);
        } else if (v == 4) {
            this.tc.sendDCCppMessage(DCCppMessage.makeTrackPowerOffMsg(), this);
        }
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void dispose() throws JmriException {
        this.tc.removeDCCppListener(2, this);
        this.tc = null;
    }

    private void checkTC() throws JmriException {
        if (this.tc == null) {
            throw new JmriException("attempt to use PowerManager after dispose");
        }
    }

    @Override
    public void message(DCCppReply m) {
        if (m.isPowerReply()) {
            log.debug("Power Reply message received: {}", (Object)m);
            int old = this.power;
            this.power = m.getPowerBool() ? 2 : 4;
            this.firePowerPropertyChange(old, this.power);
        } else if (m.isStatusReply()) {
            log.debug("Version Info Received: {}", (Object)m);
            this.tc.getCommandStation().setCommandStationInfo(m);
        } else if (m.isTrackManagerReply()) {
            log.debug("Track Manager Reply Received: {}", (Object)m);
            int trackNum = m.getTrackManagerLetter() - 65;
            this.tc.getCommandStation().setTrackMode(trackNum, m.getTrackManagerMode());
        }
    }

    @Override
    public void message(DCCppMessage l) {
    }

    @Override
    public void notifyTimeout(DCCppMessage msg) {
        log.debug("Notified of timeout on message '{}' , {} retries available.", (Object)msg, (Object)msg.getRetries());
        if (msg.getRetries() > 0) {
            msg.setRetries(msg.getRetries() - 1);
            this.tc.sendDCCppMessage(msg, this);
        }
    }
}

