/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.util.HashMap;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Meter;
import jmri.MeterManager;
import jmri.implementation.DefaultMeter;
import jmri.implementation.MeterUpdateTask;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppPredefinedMeters
implements DCCppListener {
    private DCCppTrafficController tc = null;
    private final MeterUpdateTask updateTask;
    private String systemPrefix = null;
    private char beanType;
    private HashMap<String, Meter> meters = new HashMap(2);
    private static final Logger log = LoggerFactory.getLogger(DCCppPredefinedMeters.class);

    public DCCppPredefinedMeters(DCCppSystemConnectionMemo memo) {
        log.debug("Constructor called");
        this.systemPrefix = memo.getSystemPrefix();
        this.beanType = InstanceManager.getDefault(MeterManager.class).typeLetter();
        this.tc = memo.getDCCppTrafficController();
        this.updateTask = new MeterUpdateTask(0, 10000){

            @Override
            public void requestUpdateFromLayout() {
                if (DCCppPredefinedMeters.this.tc.getCommandStation().isCurrentListSupported()) {
                    DCCppPredefinedMeters.this.tc.sendDCCppMessage(DCCppMessage.makeCurrentValuesMsg(), DCCppPredefinedMeters.this);
                } else {
                    DCCppPredefinedMeters.this.tc.sendDCCppMessage(DCCppMessage.makeReadTrackCurrentMsg(), DCCppPredefinedMeters.this);
                }
            }
        };
        this.tc.addDCCppListener(2, this);
        if (!this.tc.getCommandStation().isCurrentListSupported()) {
            this.tc.sendDCCppMessage(DCCppMessage.makeReadTrackCurrentMsg(), this);
        }
        this.tc.sendDCCppMessage(DCCppMessage.makeCurrentMaxesMsg(), this);
        this.updateTask.initTimer();
    }

    public void setDCCppTrafficController(DCCppTrafficController controller) {
        this.tc = controller;
    }

    @Override
    public void message(DCCppReply r) {
        if (r.isCurrentMaxesReply()) {
            for (int t = 0; t <= r.getCurrentMaxesList().size() - 1; ++t) {
                Integer maxValue = r.getCurrentMaxesList().get(t);
                String sysName = this.systemPrefix + this.beanType + t;
                if (this.meters.get(sysName) == null) {
                    String mode = this.tc.getCommandStation().getTrackMode(t);
                    String userName = "Track " + String.valueOf((char)(65 + t)) + " " + mode + " (" + this.systemPrefix + ")";
                    log.debug("Adding new current meter {} ({})", (Object)sysName, (Object)userName);
                    DefaultMeter.DefaultCurrentMeter newMeter = new DefaultMeter.DefaultCurrentMeter(sysName, Meter.Unit.Milli, -5.0, maxValue.intValue(), 1.0, this.updateTask);
                    newMeter.setUserName(userName);
                    this.meters.put(sysName, newMeter);
                    InstanceManager.getDefault(MeterManager.class).register(newMeter);
                    continue;
                }
                log.debug("not creating duplicate meter '{}'", (Object)sysName);
            }
            return;
        }
        if (r.isCurrentValuesReply()) {
            for (int t = 0; t <= r.getCurrentValuesList().size() - 1; ++t) {
                String sysName = this.systemPrefix + this.beanType + t;
                Meter meter = this.meters.get(sysName);
                Integer meterValue = Math.max(r.getCurrentValuesList().get(t), 0);
                log.debug("Setting value for '{}' to {}", (Object)sysName, (Object)meterValue);
                try {
                    meter.setCommandedAnalogValue(meterValue.intValue());
                    continue;
                }
                catch (JmriException e) {
                    log.error("exception thrown when setting meter '{}' to value {}", new Object[]{sysName, meterValue, e});
                }
            }
            return;
        }
        if (r.isTrackManagerReply()) {
            int trackNum = r.getTrackManagerLetter() - 65;
            String userName = "Track " + r.getTrackManagerLetter() + " " + r.getTrackManagerMode() + " (" + this.systemPrefix + ")";
            String sysName = this.systemPrefix + this.beanType + trackNum;
            Meter meter = this.meters.get(sysName);
            if (meter != null) {
                log.debug("Updating username for current meter {} to '{}'", (Object)sysName, (Object)userName);
                meter.setUserName(userName);
            }
            return;
        }
        if (!r.isCurrentReply() && !r.isMeterReply()) {
            return;
        }
        if (this.tc.getCommandStation().isCurrentListSupported()) {
            return;
        }
        log.debug("Handling reply: '{}'", (Object)r);
        String meterName = "CurrentPct";
        double meterValue = 0.0;
        String meterType = "C";
        Meter.Unit meterUnit = Meter.Unit.Percent;
        double minValue = 0.0;
        double maxValue = 100.0;
        double resolution = 0.1;
        double warnValue = 100.0;
        if (r.isMeterReply()) {
            meterName = r.getMeterName();
            meterValue = r.getMeterValue();
            meterType = r.getMeterType();
            minValue = r.getMeterMinValue();
            maxValue = r.getMeterMaxValue();
            resolution = r.getMeterResolution();
            meterUnit = r.getMeterUnit();
            warnValue = r.getMeterWarnValue();
        }
        if (!this.meters.containsKey(meterName)) {
            log.debug("Adding new meter '{}' of type '{}' with unit '{}' {}", new Object[]{meterName, meterType, meterUnit, warnValue});
            String sysName = this.systemPrefix + this.beanType + meterType + "_" + meterName;
            DefaultMeter newMeter = meterType.equals("V") ? new DefaultMeter.DefaultVoltageMeter(sysName, meterUnit, minValue, maxValue, resolution, this.updateTask) : new DefaultMeter.DefaultCurrentMeter(sysName, meterUnit, minValue, maxValue, resolution, this.updateTask);
            this.meters.put(meterName, newMeter);
            InstanceManager.getDefault(MeterManager.class).register(newMeter);
        }
        if (r.isCurrentReply()) {
            meterValue = (float)r.getCurrentInt() * 1.0f / 1024.0f * 100.0f;
        }
        Meter meter = this.meters.get(meterName);
        log.debug("Setting value for '{}' to {}", (Object)meterName, (Object)meterValue);
        try {
            meter.setCommandedAnalogValue(meterValue);
        }
        catch (JmriException e) {
            log.error("exception thrown when setting meter '{}' value {}", new Object[]{meterName, meterValue, e});
        }
    }

    @Override
    public void message(DCCppMessage m) {
    }

    public void dispose() {
        this.meters.forEach((k, v) -> {
            log.debug("disposing '{}'", k);
            this.updateTask.disable((Meter)v);
            InstanceManager.getDefault(MeterManager.class).deregister(v);
            this.updateTask.dispose((Meter)v);
        });
    }

    @Override
    public void notifyTimeout(DCCppMessage msg) {
        log.debug("Notified of timeout on message '{}', not retrying", (Object)msg);
    }
}

