/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.dccpp.DCCppPortController;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DCCppSerialPortController
extends AbstractSerialPortController
implements DCCppPortController {
    private boolean outputBufferEmpty = true;
    protected String[] validOption2 = new String[]{"yes", "no"};
    private boolean checkBuffer = false;
    private static final Logger log = LoggerFactory.getLogger(DCCppSerialPortController.class);

    public DCCppSerialPortController() {
        super(new DCCppSystemConnectionMemo());
    }

    @Override
    public abstract boolean status();

    @Override
    public boolean okToSend() {
        if (this.getFlowControl(this.currentSerialPort) == AbstractSerialPortController.FlowControl.RTSCTS) {
            if (this.checkBuffer) {
                log.debug("CTS: {} Buffer Empty: {}", (Object)this.currentSerialPort.getCTS(), (Object)this.outputBufferEmpty);
                return this.currentSerialPort.getCTS() && this.outputBufferEmpty;
            }
            log.debug("CTS: {}", (Object)this.currentSerialPort.getCTS());
            return this.currentSerialPort.getCTS();
        }
        if (this.checkBuffer) {
            log.debug("Buffer Empty: {}", (Object)this.outputBufferEmpty);
            return this.outputBufferEmpty;
        }
        log.debug("No Flow Control or Buffer Check");
        return true;
    }

    @Override
    public synchronized void setOutputBufferEmpty(boolean s) {
        this.outputBufferEmpty = s;
    }

    protected void setCheckBuffer(boolean b) {
        this.checkBuffer = b;
    }

    @Override
    public DCCppSystemConnectionMemo getSystemConnectionMemo() {
        return (DCCppSystemConnectionMemo)super.getSystemConnectionMemo();
    }
}

