/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.util.EnumSet;
import java.util.HashMap;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppThrottle;
import jmri.jmrix.dccpp.DCCppTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppThrottleManager
extends AbstractThrottleManager
implements DCCppListener {
    protected HashMap<LocoAddress, DCCppThrottle> throttles = new HashMap(5);
    protected DCCppTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(DCCppThrottleManager.class);

    public DCCppThrottleManager(DCCppSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getDCCppTrafficController();
        this.tc.addDCCppListener(16, this);
        this.tc.sendDCCppMessage(DCCppMessage.makeCSMaxNumSlotsMsg(), this);
    }

    @Override
    public void requestThrottleSetup(LocoAddress address, boolean control) {
        log.debug("Requesting Throttle: {}", (Object)address);
        if (this.throttles.containsKey(address)) {
            this.notifyThrottleKnown(this.throttles.get(address), address);
        } else {
            if (this.tc.getCommandStation().requestNewRegister(address.getNumber()) == -1) {
                this.failedThrottleRequest(address, "No Register available for Throttle. Address=" + address);
                log.error("No Register available for Throttle. Address = {}", (Object)address);
                return;
            }
            DCCppThrottle throttle = new DCCppThrottle((DCCppSystemConnectionMemo)this.adapterMemo, address, this.tc);
            this.throttles.put(address, throttle);
            this.notifyThrottleKnown(throttle, address);
        }
    }

    @Override
    public boolean hasDispatchFunction() {
        return false;
    }

    @Override
    protected boolean singleUse() {
        return false;
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return DCCppThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return address >= 1 && !DCCppThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean addressTypeUnique() {
        return true;
    }

    protected static boolean isLongAddress(int num) {
        return num >= 128;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128);
    }

    @Override
    public void message(DCCppReply r) {
        if (r.getElement(0) == 35) {
            log.debug("MaxNumSlots reply received: {}", (Object)r);
            this.tc.getCommandStation().setCommandStationMaxNumSlots(r);
        } else if (r.getElement(0) == 108) {
            log.debug("LocoState reply received: {}", (Object)r);
            int locoId = r.getLocoIdInt();
            DccLocoAddress locoAddress = new DccLocoAddress(locoId, !this.canBeShortAddress(locoId));
            if (this.throttles.containsKey(locoAddress)) {
                DCCppThrottle throttle = this.throttles.get(locoAddress);
                if (log.isDebugEnabled()) {
                    log.debug("Passing locoState to throttle {}", (Object)throttle.getLocoAddress());
                }
                throttle.handleLocoState(r);
            }
        } else {
            log.trace("ignoring reply: {}", (Object)r);
        }
    }

    @Override
    public void message(DCCppMessage l) {
    }

    @Override
    public void notifyTimeout(DCCppMessage msg) {
        log.debug("Notified of timeout on message '{}' , {} retries available.", (Object)msg, (Object)msg.getRetries());
        if (msg.getRetries() > 0) {
            msg.setRetries(msg.getRetries() - 1);
            this.tc.sendDCCppMessage(msg, this);
        }
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        if (super.disposeThrottle(t, l)) {
            DCCppMessage msg = DCCppMessage.makeForgetCabMessage(t.getLocoAddress().getNumber());
            this.tc.sendDCCppMessage(msg, this);
            this.tc.getCommandStation().releaseRegister(t.getLocoAddress().getNumber());
            if (t instanceof DCCppThrottle) {
                DCCppThrottle lnt = (DCCppThrottle)t;
                this.throttles.remove(lnt.getLocoAddress());
                lnt.throttleDispose();
                return true;
            }
        }
        return false;
    }

    @Override
    public void dispose() {
        this.tc.removeDCCppListener(16, this);
    }
}

