/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.Turnout;
import jmri.jmrix.dccpp.Bundle;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppTrafficController;
import jmri.jmrix.dccpp.DCCppTurnout;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppTurnoutManager
extends AbstractTurnoutManager
implements DCCppListener {
    protected DCCppTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(DCCppTurnoutManager.class);

    public DCCppTurnoutManager(DCCppSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getDCCppTrafficController();
        this.tc.addDCCppListener(8, this);
        this.tc.sendDCCppMessage(DCCppMessage.makeTurnoutListMsg(), this);
        this.tc.sendDCCppMessage(DCCppMessage.makeOutputListMsg(), this);
        this.tc.sendDCCppMessage(DCCppMessage.makeTurnoutIDsMsg(), this);
    }

    @Override
    @Nonnull
    public DCCppSystemConnectionMemo getMemo() {
        return (DCCppSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int bitNum = this.getBitFromSystemName(systemName);
        if (bitNum < 0) {
            throw new IllegalArgumentException("Cannot get Bit from System Name " + systemName);
        }
        DCCppTurnout t = new DCCppTurnout(this.getSystemPrefix(), bitNum, this.tc);
        t.setUserName(userName);
        return t;
    }

    @Override
    public void message(DCCppReply l) {
        if (l.isTurnoutReply()) {
            log.debug("received Turnout Reply message: '{}'", (Object)l);
            int addr = l.getTOIDInt();
            if (addr >= 0) {
                log.debug("message has address: {}", (Object)addr);
                String s = this.getSystemNamePrefix() + addr;
                DCCppTurnout found = (DCCppTurnout)this.getBySystemName(s);
                if (found == null) {
                    DCCppTurnout t = (DCCppTurnout)this.provideTurnout(s);
                    t.setFeedbackMode(8);
                    t.initmessage(l);
                } else {
                    found.message(l);
                }
            }
        } else if (l.isOutputReply()) {
            log.debug("received Output Reply message: '{}'", (Object)l);
            int addr = l.getOutputNumInt();
            if (addr >= 0) {
                log.debug("message has address: {}", (Object)addr);
                String s = this.getSystemNamePrefix() + addr;
                DCCppTurnout found = (DCCppTurnout)this.getBySystemName(s);
                if (found == null) {
                    DCCppTurnout t = (DCCppTurnout)this.provideTurnout(s);
                    t.setFeedbackMode(2);
                    t.initmessage(l);
                } else {
                    found.message(l);
                }
            }
        } else if (l.isTurnoutIDsReply()) {
            log.debug("received Turnout ID List message: '{}'", (Object)l);
            ArrayList<Integer> ids = l.getTurnoutIDList();
            for (Integer id : ids) {
                this.tc.sendDCCppMessage(DCCppMessage.makeTurnoutIDMsg(id), this);
                this.tc.sendDCCppMessage(DCCppMessage.makeTurnoutImplMsg(id), this);
            }
        } else if (l.isTurnoutIDReply()) {
            log.debug("received Turnout ID Detail message: '{}'", (Object)l);
            int addr = l.getTOIDInt();
            if (addr >= 0) {
                log.debug("message has address: {}", (Object)addr);
                String s = this.getSystemNamePrefix() + addr;
                DCCppTurnout found = (DCCppTurnout)this.getBySystemName(s);
                if (found == null) {
                    DCCppTurnout t = (DCCppTurnout)this.provideTurnout(s);
                    t.setFeedbackMode(8);
                    if (!l.getTurnoutDescString().isEmpty()) {
                        t.setUserName(l.getTurnoutDescString());
                    }
                    t.initmessage(l);
                } else {
                    if (!l.getTurnoutDescString().isEmpty() && found.getUserName() == null) {
                        found.setUserName(l.getTurnoutDescString());
                    }
                    found.message(l);
                }
            }
        }
    }

    @Override
    @Nonnull
    public String getClosedText() {
        return Bundle.getMessage("TurnoutStateClosed");
    }

    @Override
    @Nonnull
    public String getThrownText() {
        return Bundle.getMessage("TurnoutStateThrown");
    }

    @Override
    public void message(DCCppMessage l) {
    }

    @Override
    public void notifyTimeout(DCCppMessage msg) {
        log.debug("Notified of timeout on message '{}' , {} retries available.", (Object)msg, (Object)msg.getRetries());
        if (msg.getRetries() > 0) {
            msg.setRetries(msg.getRetries() - 1);
            this.tc.sendDCCppMessage(msg, this);
        }
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getBitFromSystemName(systemName) != -1 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return this.validateIntegerSystemNameFormat(systemName, 0, Short.MAX_VALUE, locale);
    }

    public int getBitFromSystemName(String systemName) {
        try {
            this.validateSystemNameFormat(systemName, Locale.getDefault());
        }
        catch (IllegalArgumentException ex) {
            return -1;
        }
        return Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length()));
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

