/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp;

import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppTrafficController;
import jmri.jmrix.dccpp.DCCppTurnout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppTurnoutReplyCache
implements DCCppListener {
    protected DCCppTrafficController tc = null;
    private DCCppReply[] messageCache = new DCCppReply[Short.MAX_VALUE];
    private Boolean[] messagePending;
    private static final Logger log = LoggerFactory.getLogger(DCCppTurnoutReplyCache.class);

    public DCCppTurnoutReplyCache(DCCppTrafficController controller) {
        int i;
        for (i = 0; i < Short.MAX_VALUE; ++i) {
            this.messageCache[i] = null;
        }
        this.messagePending = new Boolean[Short.MAX_VALUE];
        for (i = 0; i < Short.MAX_VALUE; ++i) {
            this.messagePending[i] = false;
        }
        this.tc = controller;
        this.tc.addDCCppListener(8, this);
    }

    public synchronized void requestCachedStateFromLayout(DCCppTurnout turnout) {
        int pNumber = turnout.getNumber();
        if (this.messagePending[pNumber].booleanValue()) {
            return;
        }
        try {
            if (this.messageCache[pNumber] != null) {
                log.debug("Message for turnout {} cached.", (Object)pNumber);
                turnout.message(this.messageCache[pNumber]);
            } else {
                this.messagePending[pNumber] = true;
                turnout.requestUpdateFromLayout();
            }
        }
        catch (NullPointerException npe) {
            this.messagePending[pNumber] = true;
            turnout.requestUpdateFromLayout();
        }
    }

    @Override
    public synchronized void message(DCCppReply l) {
        if (l.isTurnoutReply()) {
            log.debug("received message: {}", (Object)l);
            this.messageCache[l.getTOIDInt()] = l;
            this.messagePending[l.getTOIDInt()] = false;
        }
    }

    @Override
    public void message(DCCppMessage l) {
    }

    @Override
    public void notifyTimeout(DCCppMessage msg) {
        log.debug("Notified of timeout on message '{}'", (Object)msg);
    }
}

