/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.dccppovertcp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.LinkedList;
import javax.annotation.concurrent.GuardedBy;
import jmri.InstanceManager;
import jmri.Version;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.dccppovertcp.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientRxHandler
extends Thread
implements DCCppListener {
    Socket clientSocket;
    BufferedReader inStream;
    OutputStream outStream;
    @GuardedBy(value="replyQueue")
    final LinkedList<DCCppReply> replyQueue = new LinkedList();
    Thread txThread;
    String inString;
    String remoteAddress;
    DCCppMessage lastSentMessage;
    private static final String oldSendPrefix = "SEND";
    private static final String oldReceivePrefix = "RECEIVE ";
    private static final String sendPrefix = "<";
    private static final String oldServerVersionString = "VERSION JMRI Server ";
    private static final String newServerVersionString = "VERSION DCC++ Server ";
    boolean useOldPrefix = false;
    private static final Logger log = LoggerFactory.getLogger(ClientRxHandler.class);

    public ClientRxHandler(String newRemoteAddress, Socket newSocket) {
        this.clientSocket = newSocket;
        this.setDaemon(true);
        this.setPriority(10);
        this.remoteAddress = newRemoteAddress;
        this.setName("ClientRxHandler:" + this.remoteAddress);
        this.lastSentMessage = null;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DCCppSystemConnectionMemo memo = InstanceManager.getDefault(DCCppSystemConnectionMemo.class);
        try {
            this.txThread = new Thread(new ClientTxHandler(this));
            this.txThread.setDaemon(true);
            this.txThread.setPriority(10);
            this.txThread.setName("ClientTxHandler:" + this.remoteAddress);
            this.inStream = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            this.outStream = this.clientSocket.getOutputStream();
            memo.getDCCppTrafficController().addDCCppListener(-1, this);
            this.txThread.start();
            while (!this.isInterrupted()) {
                this.inString = this.inStream.readLine();
                if (this.inString == null) {
                    log.debug("ClientRxHandler: Remote Connection Closed");
                    this.interrupt();
                    continue;
                }
                log.debug("ClientRxHandler: Received: {}", (Object)this.inString);
                if (this.inString.startsWith(oldServerVersionString)) {
                    this.useOldPrefix = true;
                }
                if (this.inString.startsWith(oldSendPrefix)) {
                    this.useOldPrefix = true;
                    int trim = oldSendPrefix.length();
                    this.inString = this.inString.substring(trim);
                    log.debug("Adapted String: {}", (Object)this.inString);
                }
                if (!this.inString.startsWith(sendPrefix)) {
                    log.debug("Invalid packet format: {}", (Object)this.inString);
                    continue;
                }
                DCCppMessage msg = new DCCppMessage(this.inString.substring(this.inString.indexOf(60) + 1, this.inString.lastIndexOf(62)));
                memo.getDCCppTrafficController().sendDCCppMessage(msg, null);
                this.lastSentMessage = msg;
            }
        }
        catch (IOException ex) {
            log.debug("ClientRxHandler: IO Exception: ", (Throwable)ex);
        }
        memo.getDCCppTrafficController().removeDCCppListener(-1, this);
        this.txThread.interrupt();
        this.txThread = null;
        this.inStream = null;
        this.outStream = null;
        LinkedList<DCCppReply> ex = this.replyQueue;
        synchronized (ex) {
            this.replyQueue.clear();
        }
        try {
            this.clientSocket.close();
        }
        catch (IOException ex1) {
            log.trace("Exception while closing client socket", (Throwable)ex1);
        }
        InstanceManager.getDefault(Server.class).removeClient(this);
        log.info("ClientRxHandler: Exiting");
    }

    public void close() {
        try {
            this.clientSocket.close();
        }
        catch (IOException ex1) {
            log.error("close, which closing clientSocket", (Throwable)ex1);
        }
    }

    @Override
    public void message(DCCppMessage msg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(DCCppReply msg) {
        LinkedList<DCCppReply> linkedList = this.replyQueue;
        synchronized (linkedList) {
            this.replyQueue.add(msg);
            this.replyQueue.notifyAll();
        }
        log.debug("Message added to queue: {}", (Object)msg);
    }

    @Override
    public void notifyTimeout(DCCppMessage m) {
    }

    class ClientTxHandler
    implements Runnable {
        DCCppReply msg;
        StringBuilder outBuf;
        Thread parentThread;

        ClientTxHandler(Thread creator) {
            this.parentThread = creator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.outBuf = new StringBuilder(ClientRxHandler.newServerVersionString);
                this.outBuf.append(Version.name()).append("\r\n");
                ClientRxHandler.this.outStream.write(this.outBuf.toString().getBytes());
                while (!ClientRxHandler.this.isInterrupted()) {
                    this.msg = null;
                    LinkedList<DCCppReply> linkedList = ClientRxHandler.this.replyQueue;
                    synchronized (linkedList) {
                        if (ClientRxHandler.this.replyQueue.isEmpty()) {
                            ClientRxHandler.this.replyQueue.wait();
                        }
                        if (!ClientRxHandler.this.replyQueue.isEmpty()) {
                            this.msg = ClientRxHandler.this.replyQueue.removeFirst();
                            log.debug("Prepping to send message: {}", (Object)this.msg);
                        }
                    }
                    if (this.msg == null) continue;
                    this.outBuf.setLength(0);
                    if (ClientRxHandler.this.useOldPrefix) {
                        this.outBuf.append(ClientRxHandler.oldReceivePrefix);
                    }
                    this.outBuf.append(ClientRxHandler.sendPrefix);
                    this.outBuf.append(this.msg.toString());
                    this.outBuf.append(">");
                    log.debug("ClientTxHandler: Send: {}", (Object)this.outBuf);
                    this.outBuf.append("\r\n");
                    ClientRxHandler.this.outStream.write(this.outBuf.toString().getBytes());
                    ClientRxHandler.this.outStream.flush();
                }
            }
            catch (IOException ex) {
                log.error("ClientTxHandler: IO Exception");
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                log.debug("ClientTxHandler: Interrupted Exception");
            }
            this.parentThread.interrupt();
            this.parentThread = null;
            this.msg = null;
            this.outBuf = null;
            log.info("ClientTxHandler: Exiting");
        }
    }
}

