/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.dccppovertcp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.GuardedBy;
import javax.swing.SwingUtilities;
import jmri.jmrix.dccpp.DCCppCommandStation;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppNetworkPortController;
import jmri.jmrix.dccpp.DCCppPacketizer;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.util.WaitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppOverTcpPacketizer
extends DCCppPacketizer {
    static final String OLD_RECEIVE_PREFIX = "RECEIVE ";
    static final String OLD_SEND_PREFIX = "SEND";
    static final String RECEIVE_PREFIX = "<";
    static final String SEND_PREFIX = "";
    static final String OLD_SERVER_VERSION_STRING = "VERSION JMRI Server ";
    static final String NEW_SERVER_VERSION_STRING = "VERSION DCC++ Server ";
    boolean useOldPrefix = false;
    protected BufferedReader istreamReader = null;
    @GuardedBy(value="xmtHandler")
    protected final Runnable xmtHandler;
    protected Runnable rcvHandler;
    @GuardedBy(value="xmtHandler")
    protected LinkedList<DCCppMessage> xmtList = new LinkedList();
    public DCCppNetworkPortController networkController = null;
    private static final Logger log = LoggerFactory.getLogger(DCCppOverTcpPacketizer.class);

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Only used during system initialization")
    public DCCppOverTcpPacketizer(DCCppCommandStation cs) {
        super(cs);
        this.xmtHandler = new XmtHandler();
        this.rcvHandler = new RcvHandler(this);
        log.debug("DCCppOverTcpPacketizer created.");
    }

    public boolean isXmtBusy() {
        return this.networkController != null;
    }

    public void connectPort(DCCppNetworkPortController p) {
        this.istream = p.getInputStream();
        this.istreamReader = new BufferedReader(new InputStreamReader(this.istream));
        this.ostream = p.getOutputStream();
        if (this.networkController != null) {
            log.warn("connectPort: connect called while connected");
        }
        this.networkController = p;
    }

    public void disconnectPort(DCCppNetworkPortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.networkController != p) {
            log.warn("disconnectPort: disconnect called from non-connected DCCppNetworkPortController");
        }
        this.networkController = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendDCCppMessage(DCCppMessage m, DCCppListener reply) {
        log.debug("queue DCCpp packet: {}", (Object)m);
        try {
            Runnable runnable = this.xmtHandler;
            synchronized (runnable) {
                this.xmtList.addLast(m);
                this.xmtHandler.notifyAll();
            }
        }
        catch (Exception e) {
            log.warn("passing to xmit: unexpected exception: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startThreads() {
        Thread xmtThread;
        int priority = Thread.currentThread().getPriority();
        log.debug("startThreads current priority = {} max available {} default = {} min available = {}", new Object[]{priority, 10, 5, 1});
        int xmtpriority = 9 > priority ? 9 : 10;
        Runnable runnable = this.xmtHandler;
        synchronized (runnable) {
            xmtThread = new Thread(this.xmtHandler, "DCC++ transmit handler");
        }
        log.debug("Xmt thread starts at priority {}", (Object)xmtpriority);
        xmtThread.setDaemon(true);
        xmtThread.setPriority(9);
        xmtThread.start();
        if (this.rcvHandler == null) {
            this.rcvHandler = new RcvHandler(this);
        }
        Thread rcvThread = new Thread(this.rcvHandler, "DCC++ receive handler");
        rcvThread.setDaemon(true);
        rcvThread.setPriority(10);
        rcvThread.start();
    }

    @Override
    public void terminateThreads() {
        this.threadStopRequest = true;
        if (this.xmtThread != null) {
            this.xmtThread.interrupt();
            try {
                this.xmtThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.rcvThread != null) {
            this.rcvThread.interrupt();
            try {
                this.rcvThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class XmtHandler
    implements Runnable {
        XmtHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!DCCppOverTcpPacketizer.this.threadStopRequest) {
                try {
                    DCCppMessage msg;
                    log.debug("check for input");
                    Runnable runnable = DCCppOverTcpPacketizer.this.xmtHandler;
                    synchronized (runnable) {
                        msg = DCCppOverTcpPacketizer.this.xmtList.removeFirst();
                    }
                    try {
                        if (DCCppOverTcpPacketizer.this.ostream != null) {
                            log.debug("start write to network stream");
                            StringBuilder packet = new StringBuilder(msg.length() + DCCppOverTcpPacketizer.SEND_PREFIX.length() + 2);
                            if (DCCppOverTcpPacketizer.this.useOldPrefix) {
                                packet.append(DCCppOverTcpPacketizer.OLD_SEND_PREFIX);
                            }
                            packet.append(DCCppOverTcpPacketizer.RECEIVE_PREFIX).append(msg.toString()).append(">");
                            if (log.isDebugEnabled()) {
                                log.debug("Write to LbServer: {}", (Object)packet.toString());
                            }
                            packet.append("\r\n");
                            DCCppOverTcpPacketizer.this.ostream.write(packet.toString().getBytes());
                            DCCppOverTcpPacketizer.this.ostream.flush();
                            log.debug("end write to stream");
                            continue;
                        }
                        log.warn("sendDCCppMessage: no connection established");
                    }
                    catch (IOException e) {
                        log.warn("sendDCCppMessage: IOException: {}", (Object)e.toString());
                    }
                }
                catch (NoSuchElementException e) {
                    log.debug("start wait");
                    new WaitHandler(this);
                    log.debug("end wait");
                }
            }
        }
    }

    class RcvHandler
    implements Runnable {
        public RcvHandler(DCCppOverTcpPacketizer lt) {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (DCCppOverTcpPacketizer.this.istreamReader == null) {
                            log.error("istreamReader not initialized!");
                            return;
                        }
                        String rxLine = DCCppOverTcpPacketizer.this.istreamReader.readLine();
                        if (rxLine == null) {
                            log.warn("run: input stream returned null, exiting loop");
                            return;
                        }
                        log.debug("Received: {}", (Object)rxLine);
                        if (rxLine.startsWith(DCCppOverTcpPacketizer.OLD_SERVER_VERSION_STRING)) {
                            DCCppOverTcpPacketizer.this.useOldPrefix = true;
                        }
                        if (rxLine.startsWith(DCCppOverTcpPacketizer.OLD_RECEIVE_PREFIX)) {
                            int trim = DCCppOverTcpPacketizer.OLD_RECEIVE_PREFIX.length();
                            rxLine = rxLine.substring(trim);
                        }
                        if (!rxLine.startsWith(DCCppOverTcpPacketizer.RECEIVE_PREFIX)) {
                            log.debug("Wrong Prefix: {}", (Object)rxLine);
                            continue;
                        }
                        int firstidx = rxLine.indexOf(DCCppOverTcpPacketizer.RECEIVE_PREFIX);
                        int lastidx = rxLine.lastIndexOf(">");
                        log.debug("String {} Index1 {} Index 2{}", new Object[]{rxLine, firstidx, lastidx});
                        DCCppReply msg = DCCppReply.parseDCCppReply(rxLine.substring(rxLine.indexOf(DCCppOverTcpPacketizer.RECEIVE_PREFIX) + 1, rxLine.lastIndexOf(">")));
                        if (!msg.isValidReplyFormat()) {
                            log.warn("Invalid Reply Format: {}", (Object)msg.toString());
                            continue;
                        }
                        log.debug("queue reply for notification");
                        final DCCppReply thisMsg = msg;
                        Runnable r = new Runnable(){
                            final DCCppReply msgForLater;
                            {
                                this.msgForLater = thisMsg;
                            }

                            @Override
                            public void run() {
                                DCCppOverTcpPacketizer.this.notifyReply(this.msgForLater, null);
                            }
                        };
                        SwingUtilities.invokeLater(r);
                    }
                }
                catch (EOFException e) {
                    log.debug("EOFException, is DCC++ serial I/O using timeouts?");
                    continue;
                }
                catch (IOException e) {
                    log.debug("IOException, should only happen with HexFile: ", (Throwable)e);
                    log.info("End of file");
                    return;
                }
                catch (Exception e) {
                    log.warn("run: unexpected Exception: ", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

