/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.serial;

import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.dccpp.DCCppCommandStation;
import jmri.jmrix.dccpp.DCCppInitializationManager;
import jmri.jmrix.dccpp.DCCppSerialPortController;
import jmri.jmrix.dccpp.serial.Bundle;
import jmri.jmrix.dccpp.serial.SerialDCCppPacketizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppAdapter
extends DCCppSerialPortController {
    protected String[] validSpeeds = new String[]{Bundle.getMessage("Baud115200")};
    protected int[] validSpeedValues = new int[]{115200};
    protected String[] validStartupDelays = new String[]{"1.5 seconds", "5 seconds", "10 seconds", "20 seconds", "30 seconds"};
    protected int[] validStartupDelayValues = new int[]{1500, 5000, 10000, 20000, 30000};
    private static final Logger log = LoggerFactory.getLogger(DCCppAdapter.class);

    public DCCppAdapter() {
        this.option1Name = "StartUpDelay";
        this.options.put(this.option1Name, new AbstractPortController.Option("Wait at startup: ", this.validStartupDelays));
        ((AbstractPortController.Option)this.options.get(this.option1Name)).setCurrentValue("10 seconds");
        ((AbstractPortController.Option)this.options.get(this.option1Name)).setConfiguredValue("10 seconds");
        this.manufacturerName = "DCC++";
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("failed to connect DCC++ to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting DCC++ to {} {}", (Object)portName, (Object)this.currentSerialPort);
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.NONE);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        SerialDCCppPacketizer packets = new SerialDCCppPacketizer(new DCCppCommandStation());
        String selectedStartupDelay = this.getOptionState(this.option1Name);
        packets.startUpDelay = this.validStartupDelayValues[2];
        for (int i = 0; i < this.validStartupDelayValues.length; ++i) {
            if (!selectedStartupDelay.equals(this.validStartupDelays[i])) continue;
            packets.startUpDelay = this.validStartupDelayValues[i];
        }
        packets.connectPort(this);
        this.getSystemConnectionMemo().setDCCppTrafficController(packets);
        new DCCppInitializationManager(this.getSystemConnectionMemo());
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

