/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.simulator;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.TimerTask;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.dccpp.DCCppCommandStation;
import jmri.jmrix.dccpp.DCCppInitializationManager;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppPacketizer;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppSimulatorPortController;
import jmri.jmrix.dccpp.simulator.Bundle;
import jmri.util.ImmediatePipedOutputStream;
import jmri.util.ThreadingUtil;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppSimulatorAdapter
extends DCCppSimulatorPortController
implements Runnable {
    static final int SENSOR_MSG_RATE = 10;
    private boolean outputBufferEmpty = true;
    private final boolean checkBuffer = true;
    private boolean trackPowerState = false;
    private final int[] CVs = new int[1025];
    private TimerTask keepAliveTimer;
    private static final long keepAliveTimeoutValue = 30000L;
    private LinkedHashMap<Integer, String> turnouts = new LinkedHashMap();
    private LinkedHashMap<Integer, Integer> locoSpeedByte = new LinkedHashMap();
    private LinkedHashMap<Integer, Integer> locoFunctions = new LinkedHashMap();
    static volatile DCCppSimulatorAdapter mInstance = null;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    private Thread sourceThread;
    private static final Logger log = LoggerFactory.getLogger(DCCppSimulatorAdapter.class);

    public DCCppSimulatorAdapter() {
        this.setPort(Bundle.getMessage("None"));
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Object)e.toString());
            return;
        }
        for (int i = 0; i < 1025; ++i) {
            this.CVs[i] = 0;
        }
    }

    @Override
    public String openPort(String portName, String appName) {
        this.setPort(portName);
        return null;
    }

    @Override
    public synchronized void setOutputBufferEmpty(boolean s) {
        this.outputBufferEmpty = s;
    }

    @Override
    public boolean okToSend() {
        log.debug("Buffer Empty: {}", (Object)this.outputBufferEmpty);
        return this.outputBufferEmpty;
    }

    @Override
    public void configure() {
        DCCppPacketizer packets = new DCCppPacketizer(new DCCppCommandStation());
        packets.connectPort(this);
        this.getSystemConnectionMemo().setDCCppTrafficController(packets);
        this.sourceThread = ThreadingUtil.newThread(this);
        this.sourceThread.start();
        new DCCppInitializationManager(this.getSystemConnectionMemo());
    }

    private void keepAliveTimer() {
        if (this.keepAliveTimer == null) {
            this.keepAliveTimer = new TimerTask(){

                @Override
                public void run() {
                    DCCppSimulatorAdapter.this.getSystemConnectionMemo().getDCCppTrafficController().sendDCCppMessage(DCCppMessage.makeCSStatusMsg(), null);
                }
            };
        } else {
            this.keepAliveTimer.cancel();
        }
        TimerUtil.schedule(this.keepAliveTimer, 30000L, 30000L);
    }

    @Override
    public DataInputStream getInputStream() {
        if (this.pin == null) {
            log.error("getInputStream called before load(), stream not available");
            ConnectionStatus.instance().setConnectionState(this.getUserName(), this.getCurrentPortName(), "Not Connected");
        }
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (this.pout == null) {
            log.error("getOutputStream called before load(), stream not available");
            ConnectionStatus.instance().setConnectionState(this.getUserName(), this.getCurrentPortName(), "Not Connected");
        }
        return this.pout;
    }

    @Override
    public boolean status() {
        return this.pout != null && this.pin != null;
    }

    @Override
    public String[] validBaudRates() {
        return new String[0];
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[0];
    }

    @Override
    public void run() {
        log.debug("Simulator Thread Started");
        this.keepAliveTimer();
        ConnectionStatus.instance().setConnectionState(this.getUserName(), this.getCurrentPortName(), "Connected");
        while (true) {
            int rand;
            DCCppMessage m = this.readMessage();
            log.debug("Simulator Thread received message '{}'", (Object)m);
            DCCppReply r = this.generateReply(m);
            if (r != null) {
                this.writeReply(r);
            }
            if ((rand = ThreadLocalRandom.current().nextInt(10)) != 1) continue;
            this.generateRandomSensorReply();
        }
    }

    private DCCppMessage readMessage() {
        DCCppMessage msg = null;
        try {
            msg = this.loadChars();
        }
        catch (IOException e) {
            ConnectionStatus.instance().setConnectionState(this.getUserName(), this.getCurrentPortName(), "Not Connected");
        }
        this.setOutputBufferEmpty(true);
        return msg;
    }

    @SuppressFBWarnings(value={"FS_BAD_DATE_FORMAT_FLAG_COMBO"}, justification="both am/pm and 24hr flags present ok as only used for display output")
    private DCCppReply generateReply(DCCppMessage msg) {
        Object r = null;
        DCCppReply reply = null;
        log.debug("Generate Reply to message type '{}' string = '{}'", (Object)msg.getElement(0), (Object)msg);
        switch (msg.getElement(0)) {
            case 116: {
                log.debug("THROTTLE_CMD detected");
                String s = msg.toString();
                try {
                    Pattern p = Pattern.compile("t\\s*(\\d+)\\s+(\\d+)\\s+([-]*\\d+)\\s+([1,0])\\s*");
                    Matcher m = p.matcher(s);
                    if (!m.matches()) {
                        p = Pattern.compile("t\\s*(\\d+)\\s+([-]*\\d+)\\s+([01])\\s*");
                        m = p.matcher(s);
                        if (!m.matches()) {
                            log.error("Malformed Throttle Command: {}", (Object)s);
                            return null;
                        }
                        int locoId = Integer.parseInt(m.group(1));
                        int speed = Integer.parseInt(m.group(2));
                        int dir = Integer.parseInt(m.group(3));
                        this.storeLocoSpeedByte(locoId, speed, dir);
                        r = this.getLocoStateString(locoId);
                    } else {
                        r = "T " + m.group(1) + " " + m.group(3) + " " + m.group(4);
                    }
                }
                catch (PatternSyntaxException e) {
                    log.error("Malformed pattern syntax! ");
                    return null;
                }
                catch (IllegalStateException e) {
                    log.error("Group called before match operation executed string= {}", (Object)s);
                    return null;
                }
                catch (IndexOutOfBoundsException e) {
                    log.error("Index out of bounds string= {}", (Object)s);
                    return null;
                }
                reply = DCCppReply.parseDCCppReply((String)r);
                log.debug("Reply generated = '{}'", (Object)reply);
                break;
            }
            case 70: {
                log.debug("FunctionV4Detected");
                String s = msg.toString();
                r = "";
                try {
                    Pattern p = Pattern.compile("F\\s*([0-9]{1,4})\\s+([0-9]{1,2})\\s+([01])\\s*");
                    Matcher m = p.matcher(s);
                    if (!m.matches()) {
                        log.error("Malformed FunctionV4 Command: {}", (Object)s);
                        return null;
                    }
                    int locoId = Integer.parseInt(m.group(1));
                    int fn = Integer.parseInt(m.group(2));
                    int state = Integer.parseInt(m.group(3));
                    this.storeLocoFunction(locoId, fn, state);
                    r = this.getLocoStateString(locoId);
                }
                catch (PatternSyntaxException e) {
                    log.error("Malformed pattern syntax!");
                    return null;
                }
                catch (IllegalStateException e) {
                    log.error("Group called before match operation executed string= {}", (Object)s);
                    return null;
                }
                catch (IndexOutOfBoundsException e) {
                    log.error("Index out of bounds string= {}", (Object)s);
                    return null;
                }
                reply = DCCppReply.parseDCCppReply((String)r);
                log.debug("Reply generated = '{}'", (Object)reply);
                break;
            }
            case 84: {
                if (msg.isTurnoutAddMessage() || msg.isTurnoutAddDCCMessage() || msg.isTurnoutAddServoMessage() || msg.isTurnoutAddVpinMessage()) {
                    log.debug("Add Turnout Message");
                    String s = "H" + msg.toString().substring(1) + " 0";
                    this.turnouts.put(msg.getTOIDInt(), s);
                    r = "O";
                } else if (msg.isTurnoutDeleteMessage()) {
                    log.debug("Delete Turnout Message");
                    this.turnouts.remove(msg.getTOIDInt());
                    r = "O";
                } else {
                    if (msg.isListTurnoutsMessage()) {
                        log.debug("List Turnouts Message");
                        this.generateTurnoutListReply();
                        break;
                    }
                    if (msg.isTurnoutCmdMessage()) {
                        log.debug("Turnout Command Message");
                        Object s = this.turnouts.get(msg.getTOIDInt());
                        if (s != null) {
                            s = ((String)s).substring(0, ((String)s).length() - 1) + msg.getTOStateInt();
                            this.turnouts.put(msg.getTOIDInt(), (String)s);
                            r = "H " + msg.getTOIDString() + " " + msg.getTOStateInt();
                        } else {
                            log.warn("Unknown turnout ID '{}'", (Object)msg.getTOIDInt());
                            r = "X";
                        }
                    } else {
                        log.debug("Unknown TURNOUT_CMD detected");
                        r = "X";
                    }
                }
                reply = DCCppReply.parseDCCppReply((String)r);
                log.debug("Reply generated = '{}'", (Object)reply);
                break;
            }
            case 90: {
                if (msg.isOutputCmdMessage()) {
                    log.debug("Output Command Message: '{}'", (Object)msg);
                    Object s = this.turnouts.get(msg.getOutputIDInt());
                    if (s != null) {
                        s = ((String)s).substring(0, ((String)s).length() - 1) + (msg.getOutputStateBool() ? "1" : "0");
                        this.turnouts.put(msg.getOutputIDInt(), (String)s);
                        r = "Y " + msg.getOutputIDInt() + " " + (msg.getOutputStateBool() ? "1" : "0");
                        reply = DCCppReply.parseDCCppReply((String)r);
                        log.debug("Reply generated = {}", (Object)reply.toString());
                    } else {
                        log.warn("Unknown output ID '{}'", (Object)msg.getOutputIDInt());
                        r = "X";
                    }
                } else if (msg.isOutputAddMessage()) {
                    log.debug("Output Add Message");
                    String s = "Y" + msg.toString().substring(1) + " 0";
                    this.turnouts.put(msg.getOutputIDInt(), s);
                    r = "O";
                } else if (msg.isOutputDeleteMessage()) {
                    log.debug("Output Delete Message");
                    this.turnouts.remove(msg.getOutputIDInt());
                    r = "O";
                } else {
                    if (msg.isListOutputsMessage()) {
                        log.debug("Output List Message");
                        this.generateTurnoutListReply();
                        break;
                    }
                    log.error("Unknown Output Command: '{}'", (Object)msg.toString());
                    r = "X";
                }
                reply = DCCppReply.parseDCCppReply((String)r);
                log.debug("Reply generated = '{}'", (Object)reply);
                break;
            }
            case 83: {
                if (msg.isSensorAddMessage()) {
                    log.debug("SENSOR_CMD Add detected");
                    r = "O";
                } else if (msg.isSensorDeleteMessage()) {
                    log.debug("SENSOR_CMD Delete detected");
                    r = "O";
                } else if (msg.isListSensorsMessage()) {
                    r = "Q 1 4 1";
                } else {
                    log.debug("Invalid SENSOR_CMD detected");
                    r = "X";
                }
                reply = DCCppReply.parseDCCppReply((String)r);
                log.debug("Reply generated = '{}'", (Object)reply);
                break;
            }
            case 87: {
                log.debug("PROG_WRITE_CV_BYTE detected");
                String s = msg.toString();
                r = "";
                try {
                    if (s.matches("W\\s*(\\d+)\\s(\\d+)\\s(\\d+)\\s(\\d+)")) {
                        Pattern p = Pattern.compile("W\\s*(\\d+)\\s(\\d+)\\s(\\d+)\\s(\\d+)");
                        Matcher m = p.matcher(s);
                        if (!m.matches()) {
                            log.error("Malformed ProgWriteCVByte Command: {}", (Object)s);
                            return null;
                        }
                        r = "r " + m.group(3) + "|" + m.group(4) + "|" + m.group(1) + " " + m.group(2);
                        this.CVs[Integer.parseInt((String)m.group((int)1))] = Integer.parseInt(m.group(2));
                    } else if (s.matches("W\\s*(\\d+)\\s(\\d+)")) {
                        Pattern p = Pattern.compile("W\\s*(\\d+)\\s(\\d+)");
                        Matcher m = p.matcher(s);
                        if (!m.matches()) {
                            log.error("Malformed ProgWriteCVByte Command: {}", (Object)s);
                            return null;
                        }
                        r = "r " + m.group(1) + " " + m.group(2);
                        this.CVs[Integer.parseInt((String)m.group((int)1))] = Integer.parseInt(m.group(2));
                    }
                    reply = DCCppReply.parseDCCppReply((String)r);
                    log.debug("Reply generated = {}", (Object)reply.toString());
                    break;
                }
                catch (PatternSyntaxException e) {
                    log.error("Malformed pattern syntax!");
                    return null;
                }
                catch (IllegalStateException e) {
                    log.error("Group called before match operation executed string= {}", (Object)s);
                    return null;
                }
                catch (IndexOutOfBoundsException e) {
                    log.error("Index out of bounds string= {}", (Object)s);
                    return null;
                }
            }
            case 66: {
                log.debug("PROG_WRITE_CV_BIT detected");
                String s = msg.toString();
                try {
                    Pattern p = Pattern.compile("B\\s*(\\d+)\\s([0-7])\\s([1,0])\\s(\\d+)\\s(\\d+)");
                    Matcher m = p.matcher(s);
                    if (!m.matches()) {
                        log.error("Malformed ProgWriteCVBit Command: {}", (Object)s);
                        return null;
                    }
                    r = "r " + m.group(4) + "|" + m.group(5) + "|" + m.group(1) + " " + m.group(2) + m.group(3);
                    int idx = Integer.parseInt(m.group(1));
                    int bit = Integer.parseInt(m.group(2));
                    int v = Integer.parseInt(m.group(3));
                    this.CVs[idx] = v == 1 ? this.CVs[idx] | 1 << bit : this.CVs[idx] & ~(1 << bit);
                    reply = DCCppReply.parseDCCppReply((String)r);
                    log.debug("Reply generated = {}", (Object)reply.toString());
                    break;
                }
                catch (PatternSyntaxException e) {
                    log.error("Malformed pattern syntax!");
                    return null;
                }
                catch (IllegalStateException e) {
                    log.error("Group called before match operation executed string= {}", (Object)s);
                    return null;
                }
                catch (IndexOutOfBoundsException e) {
                    log.error("Index out of bounds string= {}", (Object)s);
                    return null;
                }
            }
            case 82: {
                log.debug("PROG_READ_CV detected");
                String s = msg.toString();
                r = "";
                try {
                    if (s.matches("R\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)")) {
                        Pattern p = Pattern.compile("R\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)");
                        Matcher m = p.matcher(s);
                        int cv = Integer.parseInt(m.group(1));
                        int cvVal = 0;
                        if (cv < this.CVs.length) {
                            cvVal = this.CVs[Integer.parseInt(m.group(1))];
                        }
                        r = "r " + m.group(2) + "|" + m.group(3) + "|" + m.group(1) + " " + cvVal;
                    } else if (s.matches("R\\s*(\\d+)")) {
                        Pattern p = Pattern.compile("R\\s*(\\d+)");
                        Matcher m = p.matcher(s);
                        if (!m.matches()) {
                            log.error("Malformed PROG_READ_CV Command: {}", (Object)s);
                            return null;
                        }
                        int cv = Integer.parseInt(m.group(1));
                        int cvVal = 0;
                        if (cv < this.CVs.length) {
                            cvVal = this.CVs[Integer.parseInt(m.group(1))];
                        }
                        r = "r " + m.group(1) + " " + cvVal;
                    } else if (s.matches("R")) {
                        int locoId = ThreadLocalRandom.current().nextInt(9999) + 1;
                        r = "r " + locoId;
                    } else {
                        log.error("Malformed PROG_READ_CV Command: {}", (Object)s);
                        return null;
                    }
                    reply = DCCppReply.parseDCCppReply((String)r);
                    log.debug("Reply generated = {}", (Object)reply.toString());
                    break;
                }
                catch (PatternSyntaxException e) {
                    log.error("Malformed pattern syntax!");
                    return null;
                }
                catch (IllegalStateException e) {
                    log.error("Group called before match operation executed string= {}", (Object)s);
                    return null;
                }
                catch (IndexOutOfBoundsException e) {
                    log.error("Index out of bounds string= {}", (Object)s);
                    return null;
                }
            }
            case 86: {
                log.debug("PROG_VERIFY_CV detected");
                String s = msg.toString();
                try {
                    Pattern p = Pattern.compile("V\\s*(\\d+)\\s+(\\d+)\\s*");
                    Matcher m = p.matcher(s);
                    if (!m.matches()) {
                        log.error("Malformed PROG_VERIFY_CV Command: {}", (Object)s);
                        return null;
                    }
                    int cv = Integer.parseInt(m.group(1));
                    int cvVal = 0;
                    if (cv < this.CVs.length) {
                        cvVal = this.CVs[cv];
                    }
                    r = "v " + cv + " " + cvVal;
                    reply = DCCppReply.parseDCCppReply((String)r);
                    log.debug("Reply generated = {}", (Object)reply.toString());
                    break;
                }
                catch (PatternSyntaxException e) {
                    log.error("Malformed pattern syntax!");
                    return null;
                }
                catch (IllegalStateException e) {
                    log.error("Group called before match operation executed string= {}", (Object)s);
                    return null;
                }
                catch (IndexOutOfBoundsException e) {
                    log.error("Index out of bounds string= {}", (Object)s);
                    return null;
                }
            }
            case 49: {
                log.debug("TRACK_POWER_ON detected");
                this.trackPowerState = true;
                reply = DCCppReply.parseDCCppReply("p1");
                break;
            }
            case 48: {
                log.debug("TRACK_POWER_OFF detected");
                this.trackPowerState = false;
                reply = DCCppReply.parseDCCppReply("p0");
                break;
            }
            case 35: {
                log.debug("READ_MAXNUMSLOTS detected");
                reply = DCCppReply.parseDCCppReply("# 12");
                break;
            }
            case 99: {
                log.debug("READ_TRACK_CURRENT detected");
                this.generateMeterReplies();
                break;
            }
            case 61: {
                log.debug("TRACKMANAGER_CMD detected");
                reply = DCCppReply.parseDCCppReply("= A MAIN");
                this.writeReply(reply);
                reply = DCCppReply.parseDCCppReply("= B PROG");
                this.writeReply(reply);
                reply = DCCppReply.parseDCCppReply("= C MAIN");
                this.writeReply(reply);
                reply = DCCppReply.parseDCCppReply("= D MAIN");
                break;
            }
            case 64: {
                log.debug("LCD_TEXT_CMD detected");
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss a");
                LocalDateTime now = LocalDateTime.now();
                String dateTimeString = now.format(formatter);
                reply = DCCppReply.parseDCCppReply("@ 0 0 \"Welcome to DCC-EX -- " + dateTimeString + "\"");
                this.writeReply(reply);
                reply = DCCppReply.parseDCCppReply("@ 0 1 \"LCD Line 1\"");
                this.writeReply(reply);
                reply = DCCppReply.parseDCCppReply("@ 0 2 \"LCD Line 2\"");
                this.writeReply(reply);
                reply = DCCppReply.parseDCCppReply("@ 0 3 \"     LCD Line 3 with spaces   \"");
                this.writeReply(reply);
                reply = DCCppReply.parseDCCppReply("@ 0 4 \"1234567890123456789012345678901234567890\"");
                break;
            }
            case 115: {
                log.debug("READ_CS_STATUS detected");
                this.generateReadCSStatusReply();
                break;
            }
            case 74: {
                log.debug("THROTTLE_COMMANDS detected");
                if (msg.isCurrentMaxesMessage()) {
                    reply = DCCppReply.parseDCCppReply("jG 4998 4998 4998 4998");
                    break;
                }
                if (!msg.isCurrentValuesMessage()) break;
                this.generateCurrentValuesReply();
                break;
            }
            case 45: 
            case 77: 
            case 80: 
            case 97: 
            case 98: 
            case 102: 
            case 119: {
                log.debug("non-reply message detected: '{}'", (Object)msg);
                return null;
            }
            default: {
                log.debug("unknown message detected: '{}'", (Object)msg);
                return null;
            }
        }
        return reply;
    }

    private void storeLocoSpeedByte(int locoId, int speed, int dir) {
        if (speed > 0) {
            ++speed;
        }
        if (speed < 0) {
            speed = 1;
        }
        int dirBit = dir * 128;
        int speedByte = dirBit + speed;
        this.locoSpeedByte.put(locoId, speedByte);
        if (!this.locoFunctions.containsKey(locoId)) {
            this.locoFunctions.put(locoId, 0);
        }
    }

    private void storeLocoFunction(int locoId, int function, int state) {
        int functions = 0;
        if (this.locoFunctions.containsKey(locoId)) {
            functions = this.locoFunctions.get(locoId);
        }
        int mask = 1 << function;
        functions = state == 1 ? (functions |= mask) : (functions &= ~mask);
        this.locoFunctions.put(locoId, functions);
        if (!this.locoSpeedByte.containsKey(locoId)) {
            this.locoSpeedByte.put(locoId, 0);
        }
    }

    private String getLocoStateString(int locoId) {
        int speedByte = this.locoSpeedByte.get(locoId);
        int functions = this.locoFunctions.get(locoId);
        String s = "l " + locoId + " 0 " + speedByte + " " + functions;
        return s;
    }

    private void generateReadCSStatusReply() {
        DCCppReply r = new DCCppReply("p" + (this.trackPowerState ? "1" : "0"));
        this.writeReply(r);
        r = DCCppReply.parseDCCppReply("iDCC-EX V-5.0.4 / MEGA / STANDARD_MOTOR_SHIELD G-9db6d36");
        this.writeReply(r);
        this.generateTurnoutStatesReply();
    }

    private void generateTurnoutListReply() {
        if (!this.turnouts.isEmpty()) {
            this.turnouts.forEach((key, value) -> {
                DCCppReply r = new DCCppReply((String)value);
                this.writeReply(r);
            });
        } else {
            this.writeReply(new DCCppReply("X No Turnouts Defined"));
        }
    }

    private void generateTurnoutStatesReply() {
        if (!this.turnouts.isEmpty()) {
            this.turnouts.forEach((key, value) -> {
                String s = value.substring(0, 2) + key + value.substring(value.length() - 2);
                DCCppReply r = new DCCppReply(s);
                this.writeReply(r);
            });
        } else {
            this.writeReply(new DCCppReply("X No Turnouts Defined"));
        }
    }

    private void generateMeterReplies() {
        int currentmA = 1100 + ThreadLocalRandom.current().nextInt(64);
        double voltageV = 14.5 + (double)ThreadLocalRandom.current().nextInt(10) / 10.0;
        String rs = "c CurrentMAIN " + (this.trackPowerState ? Double.toString(currentmA) : "0") + " C Milli 0 1997 1 1997";
        DCCppReply r = new DCCppReply(rs);
        this.writeReply(r);
        r = new DCCppReply("c VoltageMAIN " + voltageV + " V NoPrefix 0 18.0 0.1 16.0");
        this.writeReply(r);
    }

    private void generateCurrentValuesReply() {
        int currentmA_0 = 1100 + ThreadLocalRandom.current().nextInt(64);
        int currentmA_1 = 320 + ThreadLocalRandom.current().nextInt(64);
        int currentmA_2 = 1100 + ThreadLocalRandom.current().nextInt(64);
        int currentmA_3 = 1100 + ThreadLocalRandom.current().nextInt(64);
        String rs = "jI " + (this.trackPowerState ? Integer.toString(currentmA_0) : "0") + " " + (this.trackPowerState ? Integer.toString(currentmA_1) : "0") + " " + (this.trackPowerState ? Integer.toString(currentmA_2) : "0") + " " + (this.trackPowerState ? Integer.toString(currentmA_3) : "0");
        DCCppReply r = new DCCppReply(rs);
        this.writeReply(r);
    }

    private void generateRandomSensorReply() {
        int sensorNum = ThreadLocalRandom.current().nextInt(10) + 1;
        int value = ThreadLocalRandom.current().nextInt(2);
        String reply = (value == 1 ? "Q " : "q ") + sensorNum;
        DCCppReply r = DCCppReply.parseDCCppReply(reply);
        this.writeReply(r);
    }

    private void writeReply(DCCppReply r) {
        log.debug("Simulator Thread sending Reply '{}'", (Object)r);
        int len = r.getLength();
        try {
            this.outpipe.writeByte(60);
            for (int i = 0; i < len; ++i) {
                this.outpipe.writeByte((byte)r.getElement(i));
            }
            this.outpipe.writeByte(62);
        }
        catch (IOException ex) {
            ConnectionStatus.instance().setConnectionState(this.getUserName(), this.getCurrentPortName(), "Not Connected");
        }
    }

    private DCCppMessage loadChars() throws IOException {
        byte char1;
        StringBuilder s = new StringBuilder();
        boolean found_start = false;
        while (!found_start) {
            char1 = this.readByteProtected(this.inpipe);
            if ((char1 & 0xFF) == 60) {
                found_start = true;
                log.trace("Found starting < ");
                break;
            }
            this.readByteProtected(this.inpipe);
        }
        for (int i = 0; i < 30; ++i) {
            char1 = this.readByteProtected(this.inpipe);
            if (char1 == 62) {
                log.trace("msg found > ");
                break;
            }
            log.trace("msg read byte {}", (Object)char1);
            char c = (char)(char1 & 0xFF);
            s.append(c);
        }
        log.debug("Complete message = {}", (Object)s);
        return new DCCppMessage(s.toString());
    }

    protected byte readByteProtected(DataInputStream istream) throws IOException {
        int nchars;
        byte[] rcvBuffer = new byte[1];
        while ((nchars = istream.read(rcvBuffer, 0, 1)) <= 0) {
        }
        return rcvBuffer[0];
    }
}

