/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.swing;

import java.awt.event.ActionEvent;
import jmri.InstanceManager;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppTrafficController;
import jmri.jmrix.dccpp.swing.Bundle;
import jmri.jmrix.dccpp.swing.ConfigBaseStationFrame;
import jmri.jmrix.dccpp.swing.DCCppSystemConnectionAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBaseStationAction
extends DCCppSystemConnectionAction {
    private ConfigBaseStationFrame f = null;
    private static final Logger log = LoggerFactory.getLogger(ConfigBaseStationAction.class);

    public ConfigBaseStationAction(String name, DCCppSystemConnectionMemo memo) {
        super(name, memo);
    }

    public ConfigBaseStationAction(DCCppSystemConnectionMemo memo) {
        super(Bundle.getMessage("FieldManageBaseStationFrameTitle"), memo);
    }

    public ConfigBaseStationAction() {
        this(InstanceManager.getNullableDefault(DCCppSystemConnectionMemo.class));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.f == null || !this.f.isVisible()) {
            DCCppSystemConnectionMemo memo = (DCCppSystemConnectionMemo)this.getSystemConnectionMemo();
            if (memo == null) {
                log.error("connection memo was null!");
                return;
            }
            this.f = new ConfigBaseStationFrame(memo);
            DCCppTrafficController tc = memo.getDCCppTrafficController();
            tc.addDCCppListener(2, this.f);
            tc.sendDCCppMessage(DCCppMessage.makeSensorListMsg(), this.f);
            tc.sendDCCppMessage(DCCppMessage.makeTurnoutListMsg(), this.f);
            tc.sendDCCppMessage(DCCppMessage.makeOutputListMsg(), this.f);
            if (tc.getCommandStation().isTurnoutIDsMessageRequired()) {
                tc.sendDCCppMessage(DCCppMessage.makeTurnoutIDsMsg(), this.f);
            }
        }
        this.f.setExtendedState(0);
    }
}

