/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.swing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import jmri.script.ScriptEngineSelector;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppRosterExportAction
extends AbstractAction {
    private final ScriptEngineSelector _scriptEngineSelector = new ScriptEngineSelector();
    private final String scriptFilename = "program:jython" + File.separator + "DCC-EX" + File.separator + "RosterExportToDCC-EX.py";
    private static final Logger log = LoggerFactory.getLogger(DCCppRosterExportAction.class);

    public DCCppRosterExportAction(String s) {
        super(s);
    }

    public DCCppRosterExportAction() {
        this("Roster Export to DCC-EX");
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="Same message is used in dialog")
    public void actionPerformed(ActionEvent e) {
        log.debug("in actionPerformed");
        ScriptEngineSelector.Engine engine = this._scriptEngineSelector.getSelectedEngine();
        if (engine == null) {
            String em = "Script engine is null";
            log.error(em);
            JmriJOptionPane.showMessageDialog(null, em, "Script Error", 0);
            return;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(FileUtil.getExternalFilename(this.scriptFilename)), StandardCharsets.UTF_8);){
            engine.getScriptEngine().eval(reader);
        }
        catch (IOException | ScriptException ex) {
            String em = "Cannot execute script: " + ex;
            log.error(em);
            JmriJOptionPane.showMessageDialog(null, em, "Script Error", 0);
        }
    }
}

