/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.swing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jmri.jmrix.dccpp.swing.Bundle;

public abstract class DCCppTableModel
extends AbstractTableModel {
    protected List<List<Object>> rowData;
    protected List<List<Object>> deletedData;
    protected String[] columnNames;
    private int _dirtyCol = 0;
    private int _newCol = 0;
    private int _deleteCol = 0;
    protected int _lastDataCol = 0;

    public DCCppTableModel(int dc, int nc, int delc, int numc) {
        this._dirtyCol = dc;
        this._newCol = nc;
        this._deleteCol = delc;
        this._lastDataCol = numc - 4;
        this.rowData = new ArrayList<List<Object>>();
        this.deletedData = new ArrayList<List<Object>>();
    }

    public int getDeleteColumn() {
        return 3;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.rowData.size(); ++i) {
            if (!this.isDirtyRow(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isNewRow(int row) {
        return (Boolean)this.rowData.get(row).get(this._newCol);
    }

    public void setNewRow(int row, boolean n) {
        this.rowData.get(row).set(this._newCol, n);
    }

    public boolean isDirtyRow(int row) {
        return (Boolean)this.rowData.get(row).get(this._dirtyCol);
    }

    public void setDirtyRow(int row, boolean d) {
        this.rowData.get(row).set(this._dirtyCol, d);
    }

    public boolean isMarkedForDelete(int row) {
        return (Boolean)this.rowData.get(row).get(this._deleteCol);
    }

    public void removeRow(int row) {
        this.deletedData.add(this.rowData.get(row));
        this.rowData.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void markForDelete(int row, boolean mark) {
        this.rowData.get(row).set(this._deleteCol, mark);
        if (mark) {
            this.removeRow(row);
        }
    }

    public int findRow(List<Object> v) {
        for (int i = 0; i < this.rowData.size(); ++i) {
            if (!this.rowData.get(i).get(0).equals(v.get(0))) continue;
            return i;
        }
        return -1;
    }

    public void insertData(List<Object> v, boolean isnew) {
        v.add(Bundle.getMessage("ColumnDelete"));
        v.add(isnew);
        v.add(false);
        v.add(false);
        int index = this.findRow(v);
        if (index < 0) {
            this.rowData.add(v);
        } else {
            this.rowData.set(index, v);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.rowData.get(row).set(col, value);
        if (col < this._lastDataCol) {
            this.setDirtyRow(row, true);
        }
        this.fireTableCellUpdated(row, col);
    }

    public List<List<Object>> getRowData() {
        return this.rowData;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.rowData.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= 0 && row < this.rowData.size()) {
            return this.rowData.get(row).get(col);
        }
        return 0;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }
}

