/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.swing.mon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import jmri.jmrix.AbstractMonFrame;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppTrafficController;
import jmri.jmrix.dccpp.serial.SerialDCCppPacketizer;
import jmri.jmrix.dccpp.swing.mon.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCppMonFrame
extends AbstractMonFrame
implements DCCppListener {
    final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrix.dccpp.swing.DCCppSwingBundle");
    private DCCppTrafficController tc = null;
    private DCCppSystemConnectionMemo _memo = null;
    private SerialDCCppPacketizer serialDCCppTC = null;
    private final JPanel serialPane = new JPanel();
    private final JLabel queuedEntriesLabel = new JLabel("", 2);
    private final JToggleButton pauseRefreshButton = new JToggleButton();
    private final JButton clearRefreshQueueButton = new JButton();
    private final JCheckBox displayTranslatedCheckBox = new JCheckBox(Bundle.getMessage("ButtonShowTranslation"));
    private final String doNotDisplayTranslatedCheck = this.getClass().getName() + ".DoNotDisplayTranslated";
    private int previouslyQueuedMessages = -1;
    private static final Logger log = LoggerFactory.getLogger(DCCppMonFrame.class);

    public DCCppMonFrame(DCCppSystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    protected String title() {
        return this.rb.getString("DCCppMonFrameTitle") + " (" + this._memo.getSystemPrefix() + ")";
    }

    @Override
    protected void init() {
        this.tc = this._memo.getDCCppTrafficController();
        this.tc.addDCCppListener(-1, this);
        if (this.tc instanceof SerialDCCppPacketizer && this.tc.getCommandStation().isFunctionRefreshRequired()) {
            this.serialDCCppTC = (SerialDCCppPacketizer)this.tc;
            this.pauseRefreshButton.setSelected(!this.serialDCCppTC.isActiveRefresh());
            this.refreshQueuedMessages();
            this.add((Component)this.serialPane, "Last");
        }
        JLabel functionLabel = new JLabel(Bundle.getMessage("LabelFunctionRefresh"), 2);
        this.pauseRefreshButton.setText(Bundle.getMessage("ButtonPauseRefresh"));
        this.pauseRefreshButton.setVisible(true);
        this.pauseRefreshButton.setToolTipText(Bundle.getMessage("TooltipPauseRefresh"));
        this.clearRefreshQueueButton.setText(Bundle.getMessage("ButtonClearRefreshQueue"));
        this.clearRefreshQueueButton.setVisible(true);
        this.clearRefreshQueueButton.setToolTipText(Bundle.getMessage("TooltipClearRefreshQueue"));
        this.serialPane.setLayout(new BoxLayout(this.serialPane, 2));
        this.serialPane.add(functionLabel);
        this.serialPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.serialPane.add(this.pauseRefreshButton);
        this.serialPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.serialPane.add(this.clearRefreshQueueButton);
        this.serialPane.add(Box.createRigidArea(new Dimension(5, 0)));
        this.serialPane.add(this.queuedEntriesLabel);
        this.pauseRefreshButton.addActionListener(e -> this.pauseButtonEvent(e));
        this.clearRefreshQueueButton.addActionListener(e -> this.clearButtonEvent(e));
        this.pack();
    }

    @Override
    public synchronized void message(DCCppMessage l) {
        StringBuilder text = new StringBuilder();
        if (this.displayTranslatedCheckBox.isSelected()) {
            text.append("TX: ");
            text.append(l.toMonitorString());
        }
        text.append("\n");
        this.nextLine(text.toString(), this.rawCheckBox.isSelected() ? l.toString() : "");
        this.refreshQueuedMessages();
    }

    @Override
    public void message(DCCppReply l) {
        if (log.isDebugEnabled()) {
            log.debug("Message in Monitor: '{}' opcode {}", (Object)l, (Object)Character.toString(l.getOpCodeChar()));
        }
        StringBuilder text = new StringBuilder();
        if (this.displayTranslatedCheckBox.isSelected()) {
            text.append(" RX: ");
            text.append(l.toMonitorString());
        }
        text.append("\n");
        this.nextLine(text.toString(), this.rawCheckBox.isSelected() ? l.toString() : "");
        if (l.isStatusReply()) {
            if (this.tc.getCommandStation().isFunctionRefreshRequired()) {
                this.serialPane.setVisible(true);
            } else {
                this.serialPane.setVisible(false);
            }
        }
    }

    @Override
    public void notifyTimeout(DCCppMessage msg) {
    }

    private void clearButtonEvent(ActionEvent e) {
        if (this.serialDCCppTC != null) {
            this.serialDCCppTC.clearRefreshQueue();
        }
        this.refreshQueuedMessages();
    }

    private void pauseButtonEvent(ActionEvent e) {
        JToggleButton source = (JToggleButton)e.getSource();
        if (this.serialDCCppTC != null) {
            this.serialDCCppTC.setActiveRefresh(!source.isSelected());
        }
    }

    public synchronized void refreshQueuedMessages() {
        int currentlyQueuedMessages;
        if (this.serialDCCppTC != null && (currentlyQueuedMessages = this.serialDCCppTC.getQueueLength()) != this.previouslyQueuedMessages) {
            this.queuedEntriesLabel.setText(Bundle.getMessage("LabelQueuedEntries", String.valueOf(currentlyQueuedMessages)));
            this.clearRefreshQueueButton.setEnabled(currentlyQueuedMessages > 0);
            this.previouslyQueuedMessages = currentlyQueuedMessages;
        }
    }

    private void displayTranslatedEvent(ActionEvent e) {
        if (this.neitherCheckBoxSelected()) {
            this.rawCheckBox.setSelected(true);
        }
    }

    private void rawCheckBoxEvent(ActionEvent e) {
        if (this.neitherCheckBoxSelected()) {
            this.displayTranslatedCheckBox.setSelected(true);
        }
    }

    private boolean neitherCheckBoxSelected() {
        return !this.displayTranslatedCheckBox.isSelected() && !this.rawCheckBox.isSelected();
    }

    @Override
    public JPanel getCheckBoxPanel() {
        JPanel a = super.getCheckBoxPanel();
        a.add((Component)this.displayTranslatedCheckBox, 0);
        this.displayTranslatedCheckBox.addActionListener(this::displayTranslatedEvent);
        this.rawCheckBox.addActionListener(this::rawCheckBoxEvent);
        this.displayTranslatedCheckBox.setSelected(!this.userPrefs.getSimplePreferenceState(this.doNotDisplayTranslatedCheck));
        this.rawCheckBoxEvent(null);
        return a;
    }

    @Override
    public void dispose() {
        if (this.tc != null) {
            this.tc.removeDCCppListener(-1, this);
        }
        if (this.userPrefs != null) {
            this.userPrefs.setSimplePreferenceState(this.doNotDisplayTranslatedCheck, !this.displayTranslatedCheckBox.isSelected());
        }
        super.dispose();
    }
}

