/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.swing.packetgen;

import java.awt.event.ActionEvent;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppTrafficController;
import jmri.jmrix.dccpp.swing.packetgen.Bundle;
import jmri.jmrix.swing.AbstractPacketGenFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketGenFrame
extends AbstractPacketGenFrame {
    private DCCppTrafficController _tc = null;
    private DCCppSystemConnectionMemo _memo;
    private static final Logger log = LoggerFactory.getLogger(PacketGenFrame.class);

    public PacketGenFrame(DCCppSystemConnectionMemo memo) {
        this._tc = memo.getDCCppTrafficController();
        this._memo = memo;
    }

    @Override
    public void initComponents() {
        super.initComponents();
        this.setTitle(Bundle.getMessage("PacketGenFrameTitle") + " (" + this._memo.getSystemPrefix() + ")");
        this.packetTextField.setToolTipText("Enter packet as a text string without the < > brackets");
        this.pack();
    }

    @Override
    public void sendButtonActionPerformed(ActionEvent e) {
        DCCppMessage msg = this.createPacket(this.packetTextField.getSelectedItem().toString());
        if (msg != null) {
            this._tc.sendDCCppMessage(msg, null);
        } else {
            log.error("Frame packet '{}' not valid", (Object)this.packetTextField.getSelectedItem().toString());
        }
    }

    DCCppMessage createPacket(String s) {
        if (s.equals("")) {
            log.debug("Empty Packet...");
            return null;
        }
        if (s.charAt(0) == '<') {
            s = s.substring(1);
        }
        if (s.lastIndexOf(62) != -1) {
            s = s.substring(0, s.lastIndexOf(62));
        }
        DCCppMessage m = new DCCppMessage(s);
        log.debug("Sending: '{}'", (Object)m);
        return m;
    }
}

