/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.dccpp.swing.virtuallcd;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrix.dccpp.DCCppListener;
import jmri.jmrix.dccpp.DCCppMessage;
import jmri.jmrix.dccpp.DCCppReply;
import jmri.jmrix.dccpp.DCCppSystemConnectionMemo;
import jmri.jmrix.dccpp.DCCppTrafficController;
import jmri.jmrix.dccpp.swing.virtuallcd.Bundle;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualLCDFrame
extends JmriJFrame
implements DCCppListener {
    private DCCppTrafficController _tc = null;
    private DCCppSystemConnectionMemo _memo;
    static final int TOTALLINES = 64;
    private ArrayList<JLabel> lines;
    private static final Logger log = LoggerFactory.getLogger(VirtualLCDFrame.class);

    public VirtualLCDFrame(DCCppSystemConnectionMemo memo) {
        this._tc = memo.getDCCppTrafficController();
        this._memo = memo;
        this._tc.sendDCCppMessage(DCCppMessage.makeLCDRequestMsg(), null);
        this.lines = new ArrayList(65);
    }

    @Override
    public void message(DCCppMessage msg) {
    }

    @Override
    public void message(DCCppReply msg) {
        int displayNumber;
        if (msg.isLCDTextReply() && (displayNumber = msg.getLCDDisplayNumInt()) == 0) {
            int lineNumber = msg.getLCDLineNumInt();
            if (lineNumber < 64) {
                this.lines.get(lineNumber).setText(msg.getLCDTextString() + "   ");
                this.pack();
            } else {
                log.warn("Received LCD message for line {}, but configured for TOTALLINES limit of {}", (Object)lineNumber, (Object)63);
            }
            log.debug("Received LCD message for display# {}, only display 0 supported at this time.", (Object)displayNumber);
        }
    }

    @Override
    public void notifyTimeout(DCCppMessage msg) {
    }

    @Override
    public void initComponents() {
        super.initComponents();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        Font font = null;
        try {
            FileInputStream stream = new FileInputStream(new File("resources/fonts/5x8_lcd_hd44780u_a02.ttf"));
            font = Font.createFont(0, stream).deriveFont(16.0f).deriveFont(1);
        }
        catch (IOException e1) {
            log.error("failed to find or open font file");
        }
        catch (FontFormatException e2) {
            log.error("font file not valid");
        }
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        for (int i = 0; i < 64; ++i) {
            JLabel label = new JLabel();
            if (font != null) {
                label.setFont(font);
            }
            label.setOpaque(true);
            label.setBackground(Color.BLACK);
            label.setForeground(Color.WHITE);
            this.lines.add(label);
            pane.add(this.lines.get(i));
        }
        pane.setOpaque(true);
        pane.setBackground(Color.BLACK);
        this.add(pane);
        this.setTitle(Bundle.getMessage("VirtualLCDFrameTitle") + " (" + this._memo.getSystemPrefix() + ")");
        this.pack();
    }
}

