/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.debugthrottle;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.SystemConnectionMemo;
import jmri.jmrix.AbstractThrottle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugThrottle
extends AbstractThrottle {
    DccLocoAddress address;
    private static final Logger log = LoggerFactory.getLogger(DebugThrottle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugThrottle(DccLocoAddress address, SystemConnectionMemo memo) {
        super(memo);
        log.debug("DebugThrottle constructor called for address {}", (Object)address);
        DebugThrottle debugThrottle = this;
        synchronized (debugThrottle) {
            this.speedSetting = 0.0f;
        }
        this.isForward = true;
        this.address = address;
        this.setSpeedStepMode(SpeedStepMode.NMRA_DCC_128);
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    public String toString() {
        return this.getLocoAddress().toString();
    }

    @Override
    protected void sendFunctionGroup1() {
        log.debug("sendFunctionGroup1 called for address {}, dir={},F0={},F1={},F2={},F3={},F4={}", new Object[]{this.address, this.isForward ? "FWD" : "REV", this.getFunction(0) ? "On" : "Off", this.getFunction(1) ? "On" : "Off", this.getFunction(2) ? "On" : "Off", this.getFunction(3) ? "On" : "Off", this.getFunction(4) ? "On" : "Off"});
    }

    @Override
    protected void sendFunctionGroup2() {
        log.debug("sendFunctionGroup2() called");
    }

    @Override
    protected void sendFunctionGroup3() {
        log.debug("sendFunctionGroup3() called");
    }

    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public synchronized void setSpeedSetting(float speed) {
        log.debug("setSpeedSetting: float speed: {} for address {}", (Object)Float.valueOf(speed), (Object)this.address);
        float oldSpeed = this.speedSetting;
        if ((double)speed > 1.0) {
            log.warn("Speed was set too high: {}", (Object)Float.valueOf(speed));
        }
        this.speedSetting = speed;
        this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        this.record(speed);
    }

    @Override
    public void setIsForward(boolean forward) {
        log.debug("setIsForward({}) called for address {}, was {}", new Object[]{forward, this.address, this.isForward});
        boolean old = this.isForward;
        this.isForward = forward;
        this.sendFunctionGroup1();
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    @Override
    public void throttleDispose() {
        log.debug("throttleDispose() called for address {}", (Object)this.address);
        this.finishRecord();
    }
}

