/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.debugthrottle;

import java.util.EnumSet;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.SystemConnectionMemo;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.debugthrottle.DebugThrottle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugThrottleManager
extends AbstractThrottleManager {
    private static final Logger log = LoggerFactory.getLogger(DebugThrottleManager.class);

    public DebugThrottleManager() {
    }

    public DebugThrottleManager(SystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public void requestThrottleSetup(LocoAddress a, boolean control) {
        if (a instanceof DccLocoAddress) {
            DccLocoAddress address = (DccLocoAddress)a;
            log.debug("new debug throttle for {}", (Object)address);
            this.notifyThrottleKnown(new DebugThrottle(address, this.adapterMemo), a);
        } else {
            log.error("LocoAddress {} is not a DccLocoAddress", (Object)a);
        }
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return address >= 1;
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return address <= 127;
    }

    @Override
    public boolean addressTypeUnique() {
        return false;
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        log.debug("disposeThrottle called for {}", (Object)t);
        if (super.disposeThrottle(t, l)) {
            if (t instanceof DebugThrottle) {
                DebugThrottle lnt = (DebugThrottle)t;
                lnt.throttleDispose();
                return true;
            }
            log.error("DccThrottle {} is not a DebugThrottle", (Object)t);
        }
        return false;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.allOf(SpeedStepMode.class);
    }
}

