/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.direct;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.NmraPacket;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.direct.Message;

public class Throttle
extends AbstractThrottle {
    private CommandStation tcl;
    DccLocoAddress address;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throttle(DccLocoAddress address, CommandStation tc) {
        super(null);
        this.tcl = tc;
        Throttle throttle = this;
        synchronized (throttle) {
            this.speedSetting = 0.0f;
        }
        this.address = address;
        this.isForward = true;
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    @Override
    protected void sendFunctionGroup1() {
        byte[] result = NmraPacket.function0Through4Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunction(0), this.getFunction(1), this.getFunction(2), this.getFunction(3), this.getFunction(4));
        this.tcl.sendPacket(result, 1);
    }

    @Override
    protected void sendFunctionGroup2() {
        byte[] result = NmraPacket.function5Through8Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunction(5), this.getFunction(6), this.getFunction(7), this.getFunction(8));
        this.tcl.sendPacket(result, 1);
    }

    @Override
    protected void sendFunctionGroup3() {
        byte[] result = NmraPacket.function9Through12Packet(this.address.getNumber(), this.address.isLongAddress(), this.getFunction(9), this.getFunction(10), this.getFunction(11), this.getFunction(12));
        this.tcl.sendPacket(result, 1);
    }

    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public synchronized void setSpeedSetting(float speed) {
        float oldSpeed = this.speedSetting;
        this.speedSetting = speed;
        int value = (int)(126.0f * speed);
        if (value > 0) {
            ++value;
        }
        if (value > 127) {
            value = 127;
        }
        if (value < 0) {
            value = 1;
        }
        String step = "" + value;
        Message m = new Message(1 + step.length());
        int i = 0;
        if (this.isForward) {
            m.setElement(i++, 62);
        } else {
            m.setElement(i++, 60);
        }
        for (int j = 0; j < step.length(); ++j) {
            m.setElement(i++, step.charAt(j));
        }
        this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        this.record(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        Throttle throttle = this;
        synchronized (throttle) {
            this.setSpeedSetting(this.speedSetting);
        }
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    @Override
    public void throttleDispose() {
        this.finishRecord();
    }
}

