/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.direct;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import jmri.CommandStation;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.direct.DirectSystemConnectionMemo;
import jmri.jmrix.direct.MakePacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficController
implements CommandStation {
    private DirectSystemConnectionMemo _memo = null;
    private AbstractSerialPortController controller = null;
    protected DataInputStream istream = null;
    protected OutputStream ostream = null;
    private static final Logger log = LoggerFactory.getLogger(TrafficController.class);

    public TrafficController(DirectSystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    public boolean sendPacket(byte[] packet, int repeats) {
        int[] msgAsInt;
        if (repeats != 1) {
            log.warn("Only single transmissions currently available");
        }
        if ((msgAsInt = MakePacket.createStream(packet))[0] == 0) {
            log.error("Failed to convert packet to transmitable form: {}", (Object)Arrays.toString(packet));
            return false;
        }
        byte[] msg = new byte[msgAsInt[0]];
        for (int i = 0; i < msg.length; ++i) {
            msg[i] = (byte)(msgAsInt[i + 1] & 0xFF);
        }
        try {
            if (this.ostream != null) {
                if (log.isDebugEnabled()) {
                    StringBuilder f = new StringBuilder();
                    for (int i = 0; i < msg.length; ++i) {
                        f.append(Integer.toHexString(0xFF & msg[i])).append(" ");
                    }
                    log.debug("write message: {}", (Object)f);
                }
                this.ostream.write(msg);
            } else {
                log.warn("sendMessage: no connection established");
            }
        }
        catch (IOException e) {
            log.warn("sendMessage: Exception: {}", (Object)e.getMessage());
        }
        return true;
    }

    public boolean status() {
        return this.ostream != null && this.istream != null;
    }

    public void connectPort(AbstractSerialPortController p) {
        this.istream = p.getInputStream();
        this.ostream = p.getOutputStream();
        if (this.controller != null) {
            log.warn("connectPort: connect called while connected");
        } else {
            log.debug("connectPort invoked");
        }
        this.controller = p;
    }

    public void disconnectPort(AbstractSerialPortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.controller != p) {
            log.warn("disconnectPort: disconnect called from non-connected AbstractPortController");
        }
        this.controller = null;
    }

    @Override
    public String getUserName() {
        return this._memo.getUserName();
    }

    @Override
    public String getSystemPrefix() {
        return this._memo.getSystemPrefix();
    }
}

