/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.direct.serial;

import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.direct.DirectSystemConnectionMemo;
import jmri.jmrix.direct.PortController;
import jmri.jmrix.direct.TrafficController;
import jmri.jmrix.direct.serial.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDriverAdapter
extends PortController {
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("failed to connect Direct Serial to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting Direct Serial to {} {}", (Object)portName, (Object)this.currentSerialPort);
        this.setBaudRate(this.currentSerialPort, 19200);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.NONE);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        TrafficController tc = new TrafficController((DirectSystemConnectionMemo)this.getSystemConnectionMemo());
        ((DirectSystemConnectionMemo)this.getSystemConnectionMemo()).setTrafficController(tc);
        tc.connectPort(this);
        ((DirectSystemConnectionMemo)this.getSystemConnectionMemo()).configureManagers();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{Bundle.getMessage("Baud19200")};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{19200};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

