/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.direct.simulator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import jmri.jmrix.direct.DirectSystemConnectionMemo;
import jmri.jmrix.direct.Message;
import jmri.jmrix.direct.PortController;
import jmri.jmrix.direct.Reply;
import jmri.jmrix.direct.TrafficController;
import jmri.jmrix.direct.simulator.Bundle;
import jmri.util.ImmediatePipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatorAdapter
extends PortController
implements Runnable {
    private Thread sourceThread;
    private boolean outputBufferEmpty = true;
    private boolean checkBuffer = true;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    private static final Logger log = LoggerFactory.getLogger(SimulatorAdapter.class);

    public SimulatorAdapter() {
        super(new DirectSystemConnectionMemo("N", Bundle.getMessage("DirectSimulatorName")));
        this.setManufacturer("Others");
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            log.debug("tempPipeI created");
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            log.debug("inpipe created {}", (Object)(this.inpipe != null ? 1 : 0));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Object)e.toString());
        }
        this.opened = true;
        return null;
    }

    public synchronized void setOutputBufferEmpty(boolean s) {
        this.outputBufferEmpty = s;
    }

    public boolean okToSend() {
        if (this.checkBuffer) {
            log.debug("Buffer Empty: {}", (Object)this.outputBufferEmpty);
            return this.outputBufferEmpty;
        }
        log.debug("No Flow Control or Buffer Check");
        return true;
    }

    @Override
    public void configure() {
        TrafficController tc = new TrafficController((DirectSystemConnectionMemo)this.getSystemConnectionMemo());
        ((DirectSystemConnectionMemo)this.getSystemConnectionMemo()).setTrafficController(tc);
        tc.connectPort(this);
        log.debug("set tc for memo {}", (Object)this.getSystemConnectionMemo().getUserName());
        ((DirectSystemConnectionMemo)this.getSystemConnectionMemo()).configureManagers();
        this.sourceThread = new Thread(this);
        this.sourceThread.setName("Direct Simulator");
        this.sourceThread.setPriority(1);
        this.sourceThread.start();
    }

    @Override
    public void connect() throws IOException {
        log.debug("connect called");
        super.connect();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened || this.pin == null) {
            log.error("getInputStream called before load(), stream not available");
        }
        log.debug("DataInputStream pin returned");
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened || this.pout == null) {
            log.error("getOutputStream called before load(), stream not available");
        }
        log.debug("DataOutputStream pout returned");
        return this.pout;
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        log.debug("validBaudRates should not have been invoked");
        return new String[0];
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[0];
    }

    @Override
    public String getCurrentBaudRate() {
        return "";
    }

    @Override
    public String getCurrentPortName() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("Direct Simulator Started");
        while (true) {
            Reply r;
            int i;
            StringBuffer buf;
            try {
                SimulatorAdapter simulatorAdapter = this;
                synchronized (simulatorAdapter) {
                    this.wait(50L);
                }
            }
            catch (InterruptedException e) {
                log.debug("interrupted, ending");
                return;
            }
            Message m = this.readMessage();
            if (log.isDebugEnabled()) {
                buf = new StringBuffer();
                if (m != null) {
                    for (i = 0; i < m.getNumDataElements(); ++i) {
                        buf.append(Integer.toHexString(0xFF & m.getElement(i))).append(" ");
                    }
                } else {
                    buf.append("null message buffer");
                }
                log.trace("Direct Simulator Thread received message:  {}", (Object)buf);
            }
            if (m == null || (r = this.generateReply(m)) == null) continue;
            this.writeReply(r);
            if (!log.isDebugEnabled()) continue;
            buf = new StringBuffer();
            for (i = 0; i < r.getNumDataElements(); ++i) {
                buf.append(Integer.toHexString(0xFF & r.getElement(i))).append(" ");
            }
            log.debug("Direct Simulator Thread sent reply: {}", (Object)buf);
        }
    }

    private Message readMessage() {
        Message msg = null;
        try {
            if (this.inpipe != null && this.inpipe.available() > 0) {
                msg = this.loadChars();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setOutputBufferEmpty(true);
        return msg;
    }

    private Reply generateReply(Message msg) {
        log.debug("Generate Reply to message (string = {})", (Object)msg.toString());
        Reply reply = new Reply();
        int addr = msg.getAddr();
        log.debug("Message address={}", (Object)addr);
        switch (addr) {
            case 3: {
                reply.setElement(0, addr | 0x80);
                reply.setElement(1, 0);
                log.debug("Reply generated {}", (Object)reply);
                break;
            }
            default: {
                reply = null;
                log.debug("Message ignored");
            }
        }
        return reply;
    }

    private void writeReply(Reply r) {
        if (r == null) {
            return;
        }
        for (int i = 0; i < r.getNumDataElements(); ++i) {
            try {
                this.outpipe.writeByte((byte)r.getElement(i));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.outpipe.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Message loadChars() throws IOException {
        byte[] rcvBuffer = new byte[32];
        int nchars = this.inpipe.read(rcvBuffer, 0, 32);
        log.debug("new message received");
        Message msg = new Message(nchars);
        for (int i = 0; i < nchars; ++i) {
            msg.setElement(i, rcvBuffer[i] & 0xFF);
        }
        return msg;
    }
}

