/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc;

import jmri.DccLocoAddress;
import jmri.NmraPacket;
import jmri.implementation.DccConsist;
import jmri.jmrix.easydcc.EasyDccMessage;
import jmri.jmrix.easydcc.EasyDccSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyDccConsist
extends DccConsist {
    private final EasyDccSystemConnectionMemo _memo;
    private static final Logger log = LoggerFactory.getLogger(EasyDccConsist.class);

    public EasyDccConsist(int address, EasyDccSystemConnectionMemo memo) {
        super(address);
        this._memo = memo;
    }

    public EasyDccConsist(DccLocoAddress address, EasyDccSystemConnectionMemo memo) {
        super(address);
        this._memo = memo;
    }

    @Override
    public void setConsistType(int consist_type) {
        switch (consist_type) {
            case 0: 
            case 1: {
                this.consistType = consist_type;
                break;
            }
            default: {
                log.error("Consist Type Not Supported");
                this.notifyConsistListeners(new DccLocoAddress(0, false), 1);
            }
        }
    }

    @Override
    public boolean isAddressAllowed(DccLocoAddress address) {
        return address.getNumber() != 0;
    }

    @Override
    public int sizeLimit() {
        switch (this.consistType) {
            case 0: {
                return -1;
            }
            case 1: {
                return 8;
            }
        }
        return 0;
    }

    @Override
    public boolean contains(DccLocoAddress address) {
        if (this.consistType == 0 || this.consistType == 1) {
            return this.consistList.contains(address);
        }
        log.error("Consist Type Not Supported");
        this.notifyConsistListeners(address, 1);
        return false;
    }

    @Override
    public boolean getLocoDirection(DccLocoAddress address) {
        if (this.consistType == 0 || this.consistType == 1) {
            return this.consistDir.getOrDefault(address, false);
        }
        log.error("Consist Type Not Supported");
        this.notifyConsistListeners(address, 1);
        return false;
    }

    private synchronized void addToConsistList(DccLocoAddress locoAddress, boolean directionNormal) {
        if (!this.consistList.contains(locoAddress)) {
            this.consistList.add(locoAddress);
        }
        this.consistDir.put(locoAddress, directionNormal);
        if (this.consistType == 1 && this.consistList.size() == 8) {
            this.notifyConsistListeners(locoAddress, 10);
        } else {
            this.notifyConsistListeners(locoAddress, 2);
        }
    }

    private synchronized void removeFromConsistList(DccLocoAddress locoAddress) {
        this.consistDir.remove(locoAddress);
        this.consistList.remove(locoAddress);
        this.notifyConsistListeners(locoAddress, 2);
    }

    @Override
    public synchronized void add(DccLocoAddress locoAddress, boolean directionNormal) {
        if (this.consistType == 0) {
            this.addToConsistList(locoAddress, directionNormal);
            this.addToAdvancedConsist(locoAddress, directionNormal);
            this.setRosterEntryCVValue(locoAddress);
        } else if (this.consistType == 1) {
            if (this.consistList.size() < 8) {
                this.addToConsistList(locoAddress, directionNormal);
                this.addToCSConsist(locoAddress, directionNormal);
            } else {
                this.notifyConsistListeners(locoAddress, 12);
            }
        } else {
            log.error("Consist Type Not Supported");
            this.notifyConsistListeners(locoAddress, 1);
        }
    }

    @Override
    public synchronized void restore(DccLocoAddress locoAddress, boolean directionNormal) {
        switch (this.consistType) {
            case 0: 
            case 1: {
                this.addToConsistList(locoAddress, directionNormal);
                break;
            }
            default: {
                log.error("Consist Type Not Supported");
                this.notifyConsistListeners(locoAddress, 1);
            }
        }
    }

    @Override
    public synchronized void remove(DccLocoAddress locoAddress) {
        switch (this.consistType) {
            case 0: {
                this.resetRosterEntryCVValue(locoAddress);
                this.removeFromAdvancedConsist(locoAddress);
                this.removeFromConsistList(locoAddress);
                break;
            }
            case 1: {
                this.removeFromCSConsist(locoAddress);
                this.removeFromConsistList(locoAddress);
                break;
            }
            default: {
                log.error("Consist Type Not Supported");
                this.notifyConsistListeners(locoAddress, 1);
            }
        }
    }

    @Override
    protected synchronized void addToAdvancedConsist(DccLocoAddress locoAddress, boolean directionNormal) {
        log.debug("Add Locomotive {} to advanced consist {} With Direction Normal {}.", new Object[]{locoAddress, this.consistAddress, directionNormal});
        byte[] contents = NmraPacket.consistControl(locoAddress.getNumber(), locoAddress.isLongAddress(), this.consistAddress.getNumber(), directionNormal);
        EasyDccMessage msg = new EasyDccMessage(4 + 3 * contents.length);
        msg.setOpCode(83);
        msg.setElement(1, 32);
        msg.setElement(2, 48);
        msg.setElement(3, 53);
        int j = 4;
        for (int i = 0; i < contents.length; ++i) {
            msg.setElement(++j, 32);
            msg.addIntAsTwoHex(contents[i] & 0xFF, j);
            j += 2;
        }
        this._memo.getTrafficController().sendEasyDccMessage(msg, null);
    }

    @Override
    protected synchronized void removeFromAdvancedConsist(DccLocoAddress locoAddress) {
        log.debug(" Remove Locomotive {} from advanced consist {}", (Object)locoAddress, (Object)this.consistAddress);
        byte[] contents = NmraPacket.consistControl(locoAddress.getNumber(), locoAddress.isLongAddress(), 0, true);
        EasyDccMessage msg = new EasyDccMessage(4 + 3 * contents.length);
        msg.setOpCode(83);
        msg.setElement(1, 32);
        msg.setElement(2, 48);
        msg.setElement(3, 53);
        int j = 4;
        for (int i = 0; i < contents.length; ++i) {
            msg.setElement(++j, 32);
            msg.addIntAsTwoHex(contents[i] & 0xFF, j);
            j += 2;
        }
        this._memo.getTrafficController().sendEasyDccMessage(msg, null);
    }

    private synchronized void addToCSConsist(DccLocoAddress locoAddress, boolean directionNormal) {
        log.debug("Add Locomotive {} to Standard Consist {} With Direction Normal {}.", new Object[]{locoAddress, this.consistAddress, directionNormal});
        EasyDccMessage m = directionNormal ? EasyDccMessage.getAddConsistNormal(this.consistAddress.getNumber(), locoAddress) : EasyDccMessage.getAddConsistReverse(this.consistAddress.getNumber(), locoAddress);
        this._memo.getTrafficController().sendEasyDccMessage(m, null);
    }

    public synchronized void removeFromCSConsist(DccLocoAddress LocoAddress2) {
        log.debug("Remove Locomotive {} from Standard Consist {}.", (Object)LocoAddress2, (Object)this.consistAddress);
        EasyDccMessage m = EasyDccMessage.getSubtractConsist(this.consistAddress.getNumber(), LocoAddress2);
        this._memo.getTrafficController().sendEasyDccMessage(m, null);
    }
}

