/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc;

import jmri.Consist;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.implementation.AbstractConsistManager;
import jmri.jmrix.easydcc.EasyDccConsist;
import jmri.jmrix.easydcc.EasyDccListener;
import jmri.jmrix.easydcc.EasyDccMessage;
import jmri.jmrix.easydcc.EasyDccReply;
import jmri.jmrix.easydcc.EasyDccSystemConnectionMemo;
import jmri.jmrix.easydcc.EasyDccTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyDccConsistManager
extends AbstractConsistManager {
    private EasyDccConsistReader reader = new EasyDccConsistReader();
    private EasyDccSystemConnectionMemo _memo = null;
    private EasyDccTrafficController trafficController = null;
    private static final Logger log = LoggerFactory.getLogger(EasyDccConsistManager.class);

    public EasyDccConsistManager(EasyDccSystemConnectionMemo memo) {
        this._memo = memo;
        this.trafficController = memo.getTrafficController();
    }

    @Override
    public boolean isCommandStationConsistPossible() {
        return true;
    }

    @Override
    public boolean csConsistNeedsSeperateAddress() {
        return true;
    }

    @Override
    public Consist addConsist(LocoAddress address) {
        if (!(address instanceof DccLocoAddress)) {
            throw new IllegalArgumentException("address is not a DccLocoAddress object");
        }
        if (this.consistTable.containsKey(address)) {
            return (Consist)this.consistTable.get(address);
        }
        EasyDccConsist consist = new EasyDccConsist((DccLocoAddress)address, this._memo);
        this.consistTable.put(address, consist);
        this.notifyConsistListChanged();
        return consist;
    }

    @Override
    public void requestUpdateFromLayout() {
        if (this.shouldRequestUpdateFromLayout()) {
            this.reader.searchNext();
        }
    }

    @Override
    protected boolean shouldRequestUpdateFromLayout() {
        return this.reader.currentState == 0;
    }

    private class EasyDccConsistReader
    implements Runnable,
    EasyDccListener {
        int _lastAddress = 0;
        static final int IDLE = 0;
        static final int SEARCHREQUESTSENT = 1;
        int currentState = 0;

        EasyDccConsistReader() {
        }

        @Override
        public void run() {
        }

        private void searchNext() {
            log.debug("Sending request for next consist, _lastAddress is: {}", (Object)this._lastAddress);
            this.currentState = 1;
            EasyDccMessage msg = EasyDccMessage.getDisplayConsist(++this._lastAddress);
            EasyDccConsistManager.this.trafficController.sendEasyDccMessage(msg, this);
        }

        @Override
        public void reply(EasyDccReply r) {
            if (this.currentState == 1) {
                if (log.isDebugEnabled()) {
                    log.debug("Message Received in SEARCHREQUESTSENT state. Message is: {}", (Object)r.toString());
                }
                if (r.getOpCode() == 71) {
                    Boolean newConsist = true;
                    EasyDccConsist currentConsist = null;
                    String sa = "" + (char)r.getElement(1) + (char)r.getElement(2);
                    int consistAddr = Integer.valueOf(sa, 16);
                    for (int i = 3; i < r.getNumDataElements(); i += 4) {
                        boolean directionNormal;
                        if ((char)r.getElement(i) == ' ') {
                            ++i;
                        } else if (Character.digit((char)r.getElement(i), 16) == -1) break;
                        String sb = "" + (char)r.getElement(i) + (char)r.getElement(i + 1) + (char)r.getElement(i + 2) + (char)r.getElement(i + 3);
                        int tempAddr = Integer.valueOf(sb, 16);
                        boolean bl = directionNormal = (tempAddr & 0x8000) == 0;
                        if (tempAddr == 0) continue;
                        if (newConsist.booleanValue()) {
                            currentConsist = (EasyDccConsist)EasyDccConsistManager.this.addConsist(new DccLocoAddress(consistAddr, false));
                            newConsist = false;
                        }
                        DccLocoAddress locoAddress = new DccLocoAddress(tempAddr & Short.MAX_VALUE, (tempAddr & Short.MAX_VALUE) > 99);
                        if (currentConsist != null) {
                            currentConsist.restore(locoAddress, directionNormal);
                            continue;
                        }
                        log.error("currentConsist is null!");
                    }
                    if (this._lastAddress < 255) {
                        this.searchNext();
                    } else {
                        this.currentState = 0;
                        EasyDccConsistManager.this.notifyConsistListChanged();
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Message Received in IDLE state. Message is: {}", (Object)r.toString());
                }
            }
        }

        @Override
        public void message(EasyDccMessage m) {
        }
    }
}

