/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.easydcc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.NmraPacket;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.easydcc.EasyDccMessage;
import jmri.jmrix.easydcc.EasyDccProgrammer;
import jmri.jmrix.easydcc.EasyDccSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyDccOpsModeProgrammer
extends EasyDccProgrammer
implements AddressedProgrammer {
    int mAddress;
    boolean mLongAddr;
    private static final Logger log = LoggerFactory.getLogger(EasyDccOpsModeProgrammer.class);

    public EasyDccOpsModeProgrammer(int pAddress, boolean pLongAddr, EasyDccSystemConnectionMemo memo) {
        super(memo);
        this.mAddress = pAddress;
        this.mLongAddr = pLongAddr;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("write CV={} val={}", (Object)CV, (Object)val);
        byte[] contents = NmraPacket.opsCvWriteByte(this.mAddress, this.mLongAddr, CV, val);
        EasyDccMessage msg = new EasyDccMessage(4 + 3 * contents.length);
        msg.setOpCode(83);
        msg.setElement(1, 32);
        msg.setElement(2, 48);
        msg.setElement(3, 53);
        int j = 4;
        for (int i = 0; i < contents.length; ++i) {
            msg.setElement(j++, 32);
            msg.addIntAsTwoHex(contents[i] & 0xFF, j);
            j += 2;
        }
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 2;
        this._val = val;
        this._cv = CV;
        this.startShortTimer();
        this.tc.sendEasyDccMessage(msg, this);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("read CV={}", (Object)CV);
        log.error("readCV not available in this protocol");
        throw new ProgrammerException();
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        log.debug("confirm CV={}", (Object)CV);
        log.error("confirmCV not available in this protocol");
        throw new ProgrammerException();
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.OPSBYTEMODE);
        return ret;
    }

    @Override
    public boolean getCanRead() {
        return false;
    }

    @Override
    public boolean getLongAddress() {
        return this.mLongAddr;
    }

    @Override
    public int getAddressNumber() {
        return this.mAddress;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }

    @Override
    void cleanup() {
    }
}

